/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.exception.AlreadyExistsException;
import org.bonitasoft.engine.exception.CreationException;
import org.bonitasoft.engine.exception.DeletionException;
import org.bonitasoft.engine.exception.RetrieveException;
import org.bonitasoft.engine.identity.CustomUserInfoDefinition;
import org.bonitasoft.engine.identity.CustomUserInfoDefinitionCreator;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SCustomUserInfoDefinitionAlreadyExistsException;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.model.SCustomUserInfoDefinition;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoDefinitionBuilder;
import org.bonitasoft.engine.identity.model.builder.SCustomUserInfoDefinitionBuilderFactory;
import org.bonitasoft.engine.service.ModelConvertor;

public class CustomUserInfoDefinitionAPIDelegate {
    private static final int MAX_NAME_LENGHT = 75;
    private final IdentityService service;

    public CustomUserInfoDefinitionAPIDelegate(IdentityService service) {
        this.service = service;
    }

    public CustomUserInfoDefinition create(SCustomUserInfoDefinitionBuilderFactory factory, CustomUserInfoDefinitionCreator creator) throws CreationException {
        this.checkParameter(creator);
        SCustomUserInfoDefinitionBuilder builder = factory.createNewInstance();
        builder.setName(creator.getName());
        builder.setDescription(creator.getDescription());
        try {
            return ModelConvertor.convert(this.service.createCustomUserInfoDefinition(builder.done()));
        }
        catch (SCustomUserInfoDefinitionAlreadyExistsException e) {
            throw new AlreadyExistsException(e.getMessage());
        }
        catch (SIdentityException e) {
            throw new CreationException((Throwable)e);
        }
    }

    private void checkParameter(CustomUserInfoDefinitionCreator creator) throws CreationException {
        if (creator == null) {
            throw new CreationException("Can not create null custom user details.");
        }
        if (creator.getName() == null || creator.getName().trim().isEmpty()) {
            throw new CreationException("The definition name cannot be null or empty.");
        }
        if (creator.getName().length() > 75) {
            throw new CreationException("The definition name cannot be longer then 75 characters.");
        }
    }

    public void delete(long id) throws DeletionException {
        try {
            this.service.deleteCustomUserInfoDefinition(id);
        }
        catch (SIdentityException e) {
            throw new DeletionException((Throwable)e);
        }
    }

    public List<CustomUserInfoDefinition> list(int startIndex, int maxResult) {
        try {
            ArrayList<CustomUserInfoDefinition> definitions = new ArrayList<CustomUserInfoDefinition>();
            for (SCustomUserInfoDefinition sDefinition : this.service.getCustomUserInfoDefinitions(startIndex, maxResult)) {
                definitions.add((CustomUserInfoDefinition)ModelConvertor.convert(sDefinition));
            }
            return definitions;
        }
        catch (SIdentityException e) {
            throw new RetrieveException((Throwable)e);
        }
    }

    public long count() {
        try {
            return this.service.getNumberOfCustomUserInfoDefinition();
        }
        catch (SIdentityException e) {
            throw new RetrieveException((Throwable)e);
        }
    }
}

