/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.connector;

import java.util.List;
import org.bonitasoft.engine.api.impl.connector.ConnectorResetStrategy;
import org.bonitasoft.engine.api.impl.connector.ConnectorReseter;
import org.bonitasoft.engine.bpm.connector.ConnectorState;
import org.bonitasoft.engine.bpm.connector.ConnectorStateReset;
import org.bonitasoft.engine.bpm.flownode.ActivityExecutionException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstanceWithFailureInfo;

public class ResetAllFailedConnectorStrategy
implements ConnectorResetStrategy {
    private final ConnectorInstanceService connectorInstanceService;
    private final ConnectorReseter connectorReseter;
    private final int maxResults;

    public ResetAllFailedConnectorStrategy(ConnectorInstanceService connectorInstanceService, ConnectorReseter connectorReseter, int maxResults) {
        this.connectorInstanceService = connectorInstanceService;
        this.connectorReseter = connectorReseter;
        this.maxResults = maxResults;
    }

    @Override
    public void resetConnectorsOf(long flowNodeInstanceId) throws ActivityExecutionException {
        try {
            List<SConnectorInstanceWithFailureInfo> failedConnectors;
            int startIndex = 0;
            do {
                failedConnectors = this.connectorInstanceService.getConnectorInstancesWithFailureInfo(flowNodeInstanceId, "flowNode", ConnectorState.FAILED.name(), startIndex, this.maxResults);
                this.resetCurrentPage(failedConnectors);
                startIndex += this.maxResults;
            } while (failedConnectors.size() == this.maxResults);
        }
        catch (SBonitaException e) {
            throw new ActivityExecutionException((Throwable)e);
        }
    }

    private void resetCurrentPage(List<SConnectorInstanceWithFailureInfo> failedConnectors) throws ActivityExecutionException {
        for (SConnectorInstanceWithFailureInfo failedConnector : failedConnectors) {
            this.connectorReseter.resetState(failedConnector, ConnectorStateReset.TO_RE_EXECUTE);
        }
    }
}

