/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.archive.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.persistence.ArchivedPersistentObject;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;

public class BatchArchiveCallable
implements Callable<Void> {
    private final PersistenceService persistenceService;
    private final List<? extends ArchivedPersistentObject> archivedObjects;

    public BatchArchiveCallable(PersistenceService persistenceService, ArchiveInsertRecord ... records) {
        this.persistenceService = persistenceService;
        this.archivedObjects = records == null ? new ArrayList<ArchivedPersistentObject>() : this.createArchivedObjectsList(records);
    }

    protected List<ArchivedPersistentObject> createArchivedObjectsList(ArchiveInsertRecord ... records) {
        ArrayList<ArchivedPersistentObject> archivedObjects = new ArrayList<ArchivedPersistentObject>();
        for (ArchiveInsertRecord record : records) {
            if (record == null) continue;
            archivedObjects.add(record.getEntity());
        }
        return archivedObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws SPersistenceException {
        if (this.hasObjects()) {
            try {
                if (this.archivedObjects.size() == 1) {
                    this.persistenceService.insert(this.archivedObjects.get(0));
                } else {
                    this.persistenceService.insertInBatch(new ArrayList<PersistentObject>(this.archivedObjects));
                }
            }
            finally {
                this.archivedObjects.clear();
            }
        }
        return null;
    }

    public boolean hasObjects() {
        return this.archivedObjects != null && !this.archivedObjects.isEmpty();
    }
}

