/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.connector.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.io.IOUtil;
import org.bonitasoft.engine.connector.Connector;
import org.bonitasoft.engine.connector.ConnectorExecutor;
import org.bonitasoft.engine.connector.exception.SConnectorException;
import org.bonitasoft.engine.core.connector.ConnectorResult;
import org.bonitasoft.engine.core.connector.ConnectorService;
import org.bonitasoft.engine.core.connector.exception.SInvalidConnectorImplementationException;
import org.bonitasoft.engine.core.connector.impl.SConnectorAdapter;
import org.bonitasoft.engine.core.connector.parser.ConnectorImplementationBinding;
import org.bonitasoft.engine.core.connector.parser.JarDependenciesBinding;
import org.bonitasoft.engine.core.connector.parser.SConnectorImplementationDescriptor;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.dependency.model.SDependency;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.dependency.model.builder.SDependencyBuilderFactory;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.STenantIdNotSetException;
import org.bonitasoft.engine.tracking.TimeTracker;
import org.bonitasoft.engine.xml.ElementBinding;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.ParserFactory;
import org.bonitasoft.engine.xml.SXMLParseException;

public class ConnectorServiceImpl
implements ConnectorService {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String IMPLEMENTATION_EXT = ".impl";
    private static final String CONNECTOR_FOLDER = "connector";
    protected static final String CONNECTOR_CACHE_NAME = "CONNECTOR";
    private static final String CLASSPATH_FOLDER = "classpath";
    private final Parser parser;
    private final CacheService cacheService;
    private final ConnectorExecutor connectorExecutor;
    private final ReadSessionAccessor sessionAccessor;
    private final ExpressionResolverService expressionResolverService;
    private final OperationService operationService;
    private final DependencyService dependencyService;
    private final TechnicalLoggerService logger;
    private final TimeTracker timeTracker;

    public ConnectorServiceImpl(CacheService cacheService, ConnectorExecutor connectorExecutor, ParserFactory parserFactory, ReadSessionAccessor sessionAccessor, ExpressionResolverService expressionResolverService, OperationService operationService, DependencyService dependencyService, TechnicalLoggerService logger, TimeTracker timeTracker) {
        this.cacheService = cacheService;
        this.connectorExecutor = connectorExecutor;
        this.sessionAccessor = sessionAccessor;
        this.expressionResolverService = expressionResolverService;
        ArrayList<Class<? extends ElementBinding>> bindings = new ArrayList<Class<? extends ElementBinding>>();
        bindings.add(ConnectorImplementationBinding.class);
        bindings.add(JarDependenciesBinding.class);
        this.parser = parserFactory.createParser(bindings);
        this.operationService = operationService;
        this.dependencyService = dependencyService;
        this.logger = logger;
        this.timeTracker = timeTracker;
    }

    @Override
    public ConnectorResult executeConnector(long rootDefinitionId, SConnectorInstance sConnectorInstance, ClassLoader classLoader, Map<String, Object> inputParameters) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        ConnectorResult connectorResult;
        try {
            String tenantId = String.valueOf(this.sessionAccessor.getTenantId());
            SConnectorImplementationDescriptor descriptor = this.getImplementation(rootDefinitionId, tenantId, sConnectorInstance.getConnectorId(), sConnectorInstance.getVersion());
            if (descriptor == null) {
                this.loadConnectors(rootDefinitionId, (long)Integer.valueOf(tenantId).intValue());
                descriptor = this.getImplementation(rootDefinitionId, tenantId, sConnectorInstance.getConnectorId(), sConnectorInstance.getVersion());
                if (descriptor == null) {
                    throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("There is no implementation found for the connector " + sConnectorInstance.getConnectorId() + " with version " + sConnectorInstance.getVersion());
                }
            }
            String implementationClassName = descriptor.getImplementationClassName();
            connectorResult = this.executeConnectorInClassloader(implementationClassName, classLoader, inputParameters);
        }
        catch (SCacheException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        catch (STenantIdNotSetException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            String message = "Executed connector " + ConnectorServiceImpl.buildConnectorContextMessage(sConnectorInstance) + ConnectorServiceImpl.buildConnectorInputMessage(inputParameters);
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, message);
        }
        return connectorResult;
    }

    private static String buildConnectorContextMessage(SConnectorInstance conectorInstance) {
        StringBuilder stb = new StringBuilder();
        stb.append(" [name: <");
        stb.append(conectorInstance.getName());
        stb.append(">, version: <");
        stb.append(conectorInstance.getVersion());
        stb.append(">, connector id: <");
        stb.append(conectorInstance.getConnectorId());
        stb.append(">, connector instance id: <");
        stb.append(conectorInstance.getId());
        stb.append(">, container type: <");
        stb.append(conectorInstance.getContainerType());
        stb.append(">, container id: <");
        stb.append(conectorInstance.getContainerId());
        stb.append(">, activation event: <");
        stb.append(conectorInstance.getActivationEvent());
        stb.append(">]");
        return stb.toString();
    }

    private static String buildConnectorInputMessage(Map<String, Object> inputParameters) {
        StringBuilder stb = new StringBuilder();
        if (inputParameters != null && !inputParameters.isEmpty()) {
            stb.append(LINE_SEPARATOR);
            stb.append("Inputs: ");
            stb.append(LINE_SEPARATOR);
            Set<String> inputNames = inputParameters.keySet();
            for (String inputName : inputNames) {
                stb.append("    <" + inputName + "> : <" + inputParameters.get(inputName) + ">");
                stb.append(LINE_SEPARATOR);
            }
        }
        return stb.toString();
    }

    @Override
    public void executeOutputOperation(List<SOperation> outputs, SExpressionContext expressionContext, ConnectorResult result) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        long startTime = System.currentTimeMillis();
        try {
            expressionContext.setInputValues(new HashMap<String, Object>(result.getResult()));
            this.operationService.execute(outputs, (long)expressionContext.getContainerId(), expressionContext.getContainerType(), expressionContext);
            this.disconnect(result);
        }
        catch (SOperationExecutionException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        finally {
            if (this.timeTracker.isTrackable("EXECUTE_CONNECTOR_OUTPUT_OPERATIONS")) {
                long endTime = System.currentTimeMillis();
                StringBuilder desc = new StringBuilder();
                desc.append("ConnectorResult: ");
                desc.append(result);
                this.timeTracker.track("EXECUTE_CONNECTOR_OUTPUT_OPERATIONS", desc.toString(), endTime - startTime);
            }
        }
    }

    @Override
    public void disconnect(ConnectorResult result) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        long startTime = System.currentTimeMillis();
        try {
            this.connectorExecutor.disconnect(new SConnectorAdapter(result.getConnector()));
        }
        catch (SConnectorException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        finally {
            if (this.timeTracker.isTrackable("EXECUTE_CONNECTOR_DISCONNECT")) {
                long endTime = System.currentTimeMillis();
                StringBuilder desc = new StringBuilder();
                desc.append("ConnectorResult: ");
                desc.append(result);
                this.timeTracker.track("EXECUTE_CONNECTOR_DISCONNECT", desc.toString(), endTime - startTime);
            }
        }
    }

    private SConnectorImplementationDescriptor getImplementation(long rootDefinitionId, String tenantId, String connectorId, String version) throws org.bonitasoft.engine.core.connector.exception.SConnectorException, SCacheException {
        SConnectorImplementationDescriptor descriptor;
        try {
            String key = this.buildConnectorImplementationKey(rootDefinitionId, connectorId, version);
            descriptor = (SConnectorImplementationDescriptor)this.cacheService.get(CONNECTOR_CACHE_NAME, key);
            if (descriptor == null) {
                this.loadConnectors(rootDefinitionId, Long.parseLong(tenantId));
                descriptor = (SConnectorImplementationDescriptor)this.cacheService.get(CONNECTOR_CACHE_NAME, key);
            }
        }
        catch (NumberFormatException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        catch (SCacheException e) {
            throw e;
        }
        return descriptor;
    }

    private void storeImplementation(long processDefinitionId, SConnectorImplementationDescriptor connectorImplementation) throws SCacheException {
        String key = this.buildConnectorImplementationKey(processDefinitionId, connectorImplementation.getDefinitionId(), connectorImplementation.getDefinitionVersion());
        this.cacheService.store(CONNECTOR_CACHE_NAME, (Serializable)((Object)key), connectorImplementation);
    }

    protected String buildConnectorImplementationKey(long rootDefinitionId, String connectorId, String version) {
        return rootDefinitionId + ":" + connectorId + "-" + version;
    }

    @Override
    public ConnectorResult executeMutipleEvaluation(long processDefinitionId, String connectorDefinitionId, String connectorDefinitionVersion, Map<String, SExpression> connectorInputParameters, Map<String, Map<String, Serializable>> inputValues, ClassLoader classLoader, SExpressionContext sexpContext) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        try {
            SConnectorImplementationDescriptor implementation = this.getImplementation(processDefinitionId, String.valueOf(this.sessionAccessor.getTenantId()), connectorDefinitionId, connectorDefinitionVersion);
            if (implementation == null) {
                throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Can not find implementation for connector(definitionId = " + connectorDefinitionId + ", definitionVersion = " + connectorDefinitionVersion + ") for process:" + processDefinitionId);
            }
            String implementationClassName = implementation.getImplementationClassName();
            Map<String, Object> inputParameters = this.evaluateInputParameters(implementation.getDefinitionId(), connectorInputParameters, sexpContext, inputValues);
            ConnectorResult connectorResult = this.executeConnectorInClassloader(implementationClassName, classLoader, inputParameters);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Executed connector <" + implementation.getImplementationClassName() + "> with definition id <" + implementation.getDefinitionId() + ">, version <" + implementation.getDefinitionVersion() + ">, and inputs :");
                if (inputParameters != null) {
                    Set<String> inputNames = inputParameters.keySet();
                    for (String inputName : inputNames) {
                        this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "    <" + inputName + "> : <" + inputParameters.get(inputName) + ">");
                    }
                }
            }
            return connectorResult;
        }
        catch (org.bonitasoft.engine.core.connector.exception.SConnectorException e) {
            throw e;
        }
        catch (SBonitaException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
    }

    private ConnectorResult executeConnectorInClassloader(String implementationClassName, ClassLoader classLoader, Map<String, Object> inputParameters) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Connector connector = (Connector)Class.forName(implementationClassName, true, classLoader).newInstance();
            SConnectorAdapter sConnectorAdapter = new SConnectorAdapter(connector);
            ConnectorResult connectorResult = new ConnectorResult(connector, this.connectorExecutor.execute(sConnectorAdapter, inputParameters, classLoader));
            return connectorResult;
        }
        catch (ClassNotFoundException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(implementationClassName + " can not be found.", e);
        }
        catch (InstantiationException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(implementationClassName + " can not be instantiated.", e);
        }
        catch (IllegalAccessException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        catch (SConnectorException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> evaluateInputParameters(String connectorId, Map<String, SExpression> parameters, SExpressionContext sExpressionContext, Map<String, Map<String, Serializable>> inputValues) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        long startTime = System.currentTimeMillis();
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(parameters.size());
        try {
            for (Map.Entry<String, SExpression> input : parameters.entrySet()) {
                if (sExpressionContext != null) {
                    String key = input.getKey();
                    if (inputValues != null && !inputValues.isEmpty() && inputValues.containsKey(key)) {
                        sExpressionContext.setSerializableInputValues(inputValues.get(key));
                    }
                    inputParameters.put(input.getKey(), this.expressionResolverService.evaluate(input.getValue(), sExpressionContext));
                    continue;
                }
                inputParameters.put(input.getKey(), this.expressionResolverService.evaluate(input.getValue()));
            }
        }
        finally {
            if (this.timeTracker.isTrackable("EXECUTE_CONNECTOR_INPUT_EXPRESSIONS")) {
                long endTime = System.currentTimeMillis();
                StringBuilder desc = new StringBuilder();
                desc.append("Connector ID: ");
                desc.append(connectorId);
                desc.append(" - input parameters: ");
                desc.append(inputParameters);
                this.timeTracker.track("EXECUTE_CONNECTOR_INPUT_EXPRESSIONS", desc.toString(), endTime - startTime);
            }
        }
        return inputParameters;
    }

    @Override
    public boolean loadConnectors(SProcessDefinition sDefinition, long tenantId) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        return this.loadConnectors(sDefinition.getId(), tenantId);
    }

    protected boolean loadConnectors(long processDefinitionId, long tenantId) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        boolean resolved;
        block8: {
            resolved = true;
            try {
                String processesFolder = this.getProcessFolder(tenantId);
                File connectorsFolder = new File(new File(processesFolder, String.valueOf(processDefinitionId)), CONNECTOR_FOLDER);
                File[] listFiles = connectorsFolder.listFiles();
                if (listFiles == null || listFiles.length <= 0) break block8;
                Pattern pattern = Pattern.compile("^.*\\.impl$");
                for (File file : listFiles) {
                    String name = file.getName();
                    if (!pattern.matcher(name).matches()) continue;
                    try {
                        Object objectFromXML = this.parser.getObjectFromXML(file);
                        if (objectFromXML == null) {
                            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Can not parse ConnectorImplementation XML. The file name is <" + name + ">.");
                        }
                        SConnectorImplementationDescriptor connectorImplementation = (SConnectorImplementationDescriptor)objectFromXML;
                        this.storeImplementation(processDefinitionId, connectorImplementation);
                    }
                    catch (IOException e) {
                        throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Can not load ConnectorImplementation XML. The file name is <" + name + ">.", e);
                    }
                    catch (SXMLParseException e) {
                        throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Can not load ConnectorImplementation XML. The file name is <" + name + ">.", e);
                    }
                    catch (SCacheException e) {
                        throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Unable to cache the connector implementation " + name + ".", e);
                    }
                    resolved = true;
                }
            }
            catch (BonitaHomeNotSetException e) {
                throw new BonitaRuntimeException("Bonita home is not set !!");
            }
        }
        return resolved;
    }

    private String getProcessFolder(long tenantId) throws BonitaHomeNotSetException {
        String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
        return processesFolder;
    }

    @Override
    public void setConnectorImplementation(SProcessDefinition sProcessDefinition, long tenantId, String connectorId, String connectorVersion, byte[] connectorImplementationArchive) throws org.bonitasoft.engine.core.connector.exception.SConnectorException, SInvalidConnectorImplementationException {
        this.replaceConnectorImpl(sProcessDefinition, tenantId, connectorImplementationArchive, connectorId, connectorVersion);
        this.reLoadConnectors(sProcessDefinition, tenantId, connectorId, connectorVersion);
    }

    private void replaceConnectorImpl(SProcessDefinition sDefinition, long tenantId, byte[] connectorImplementationArchive, String connectorId, String connectorVersion) throws org.bonitasoft.engine.core.connector.exception.SConnectorException, SInvalidConnectorImplementationException {
        this.checkConnectorImplementationIsValid(connectorImplementationArchive, connectorId, connectorVersion);
        this.unzipNewImplementation(sDefinition, tenantId, connectorImplementationArchive, connectorId, connectorVersion);
        try {
            this.deployNewDependencies(sDefinition.getId(), tenantId);
        }
        catch (SDependencyException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Problem recording connector dependencies.", e);
        }
        catch (BonitaHomeNotSetException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        catch (IOException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Problem reading connector dependency jar files.", e);
        }
    }

    private void deployNewDependencies(long processDefinitionId, long tenantId) throws SDependencyException, IOException, BonitaHomeNotSetException {
        File processFolder = new File(new File(BonitaHomeServer.getInstance().getProcessesFolder(tenantId)), String.valueOf(processDefinitionId));
        File file = new File(processFolder, CLASSPATH_FOLDER);
        ArrayList<SDependency> dependencies = new ArrayList<SDependency>();
        if (file.exists() && file.isDirectory()) {
            File[] listFiles;
            for (File jarFile : listFiles = file.listFiles()) {
                String name = jarFile.getName();
                byte[] jarContent = IOUtil.getAllContentFrom(jarFile);
                SDependency sDependency = BuilderFactory.get(SDependencyBuilderFactory.class).createNewInstance(name, processDefinitionId, ScopeType.PROCESS, name + ".jar", jarContent).done();
                dependencies.add(sDependency);
            }
            this.dependencyService.updateDependenciesOfArtifact(processDefinitionId, ScopeType.PROCESS, dependencies);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void checkConnectorImplementationIsValid(byte[] connectorImplementationArchive, String connectorId, String connectorVersion) throws org.bonitasoft.engine.core.connector.exception.SConnectorException, SInvalidConnectorImplementationException {
        ZipInputStream zipInputstream = null;
        boolean isClosed = false;
        try {
            zipInputstream = new ZipInputStream(new ByteArrayInputStream(connectorImplementationArchive));
            ZipEntry zipEntry = zipInputstream.getNextEntry();
            if (zipEntry == null) {
                throw new SInvalidConnectorImplementationException("the zip is empty or is not a valid zip file");
            }
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                if (entryName.endsWith(IMPLEMENTATION_EXT)) {
                    SConnectorImplementationDescriptor connectorImplementationDescriptor = this.getConnectorImplementationDescriptor(zipInputstream);
                    if (!connectorImplementationDescriptor.getDefinitionId().equals(connectorId)) throw new SInvalidConnectorImplementationException("The connector must implement the connectorDefinition with id = <" + connectorId + "> and version = <" + connectorVersion + ">.", connectorImplementationDescriptor);
                    if (!connectorImplementationDescriptor.getDefinitionVersion().equals(connectorVersion)) {
                        throw new SInvalidConnectorImplementationException("The connector must implement the connectorDefinition with id = <" + connectorId + "> and version = <" + connectorVersion + ">.", connectorImplementationDescriptor);
                    }
                    isClosed = true;
                    return;
                }
                zipInputstream.closeEntry();
                zipEntry = zipInputstream.getNextEntry();
            }
            throw new SInvalidConnectorImplementationException("There no Implementation file is the zip");
        }
        catch (IOException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        finally {
            try {
                if (zipInputstream != null && !isClosed) {
                    zipInputstream.close();
                }
            }
            catch (IOException e) {
                throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
            }
        }
    }

    private void unzipNewImplementation(SProcessDefinition sDefinition, long tenantId, byte[] connectorImplementationArchive, String connectorId, String connectorVersion) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        ZipInputStream zipInputstream = null;
        try {
            String processesFolder = this.getProcessFolder(tenantId);
            File connectorsFolder = new File(new File(processesFolder, String.valueOf(sDefinition.getId())), CONNECTOR_FOLDER);
            if (!connectorsFolder.exists()) {
                throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Connector folder '" + connectorsFolder.getName() + "' not found!");
            }
            File processDefFolder = new File(processesFolder, String.valueOf(sDefinition.getId()));
            File classPathFolder = new File(processDefFolder, CLASSPATH_FOLDER);
            this.deleteOldImplementation(connectorsFolder, classPathFolder, connectorId, connectorVersion);
            zipInputstream = new ZipInputStream(new ByteArrayInputStream(connectorImplementationArchive));
            ZipEntry zipEntry = zipInputstream.getNextEntry();
            while (zipEntry != null) {
                String entryName = zipEntry.getName();
                entryName = entryName.endsWith(".jar") ? this.handleClasspathEntryName(classPathFolder, entryName) : this.handleEntryName(connectorsFolder, entryName);
                File newFile = new File(entryName);
                if (newFile.exists() && !entryName.endsWith(IMPLEMENTATION_EXT)) {
                    zipEntry = zipInputstream.getNextEntry();
                    continue;
                }
                if (zipEntry.isDirectory()) {
                    if (!newFile.mkdirs()) {
                        break;
                    }
                    zipEntry = zipInputstream.getNextEntry();
                    continue;
                }
                newFile.getParentFile().mkdirs();
                IOUtil.copyFile(zipInputstream, newFile);
                zipInputstream.closeEntry();
                zipEntry = zipInputstream.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        catch (BonitaHomeNotSetException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        finally {
            try {
                if (zipInputstream != null) {
                    zipInputstream.close();
                }
            }
            catch (IOException e) {
                throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
            }
        }
    }

    private SConnectorImplementationDescriptor getConnectorImplementationDescriptor(File file) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        try {
            Object objectFromXML = this.parser.getObjectFromXML(file);
            SConnectorImplementationDescriptor connectorImplementation = (SConnectorImplementationDescriptor)objectFromXML;
            if (connectorImplementation == null) {
                throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Can not parse ConnectorImplementation XML. The file name is " + file.getName());
            }
            return connectorImplementation;
        }
        catch (IOException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Can not load ConnectorImplementation XML. The file name is " + file.getName(), e);
        }
        catch (SXMLParseException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Can not load ConnectorImplementation XML. The file name is " + file.getName(), e);
        }
    }

    private SConnectorImplementationDescriptor getConnectorImplementationDescriptor(InputStream is) throws SInvalidConnectorImplementationException {
        try {
            Object objectFromXML = this.parser.getObjectFromXML(is);
            SConnectorImplementationDescriptor connectorImplementation = (SConnectorImplementationDescriptor)objectFromXML;
            if (connectorImplementation == null) {
                throw new SInvalidConnectorImplementationException("Can not parse ConnectorImplementation XML.");
            }
            return connectorImplementation;
        }
        catch (IOException e) {
            throw new SInvalidConnectorImplementationException("Can not load ConnectorImplementation XML.", e);
        }
        catch (SXMLParseException e) {
            throw new SInvalidConnectorImplementationException("Can not load ConnectorImplementation XML.", e);
        }
    }

    private void deleteOldImplementation(File connectorsFolder, File classPathFolder, String connectorId, String connectorVersion) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        File[] listFiles = connectorsFolder.listFiles();
        Pattern pattern = Pattern.compile("^.*\\.impl$");
        List<String> jarFileNames = null;
        for (File file : listFiles) {
            SConnectorImplementationDescriptor connectorImplementation;
            String name = file.getName();
            if (!pattern.matcher(name).matches() || !connectorId.equals((connectorImplementation = this.getConnectorImplementationDescriptor(file)).getDefinitionId()) || !connectorVersion.equals(connectorImplementation.getDefinitionVersion())) continue;
            file.delete();
            jarFileNames = connectorImplementation.getJarDependencies().getDependencies();
            break;
        }
        if (jarFileNames != null) {
            for (String jarFileName : jarFileNames) {
                String jarFileAbsolutePath = this.handleEntryName(classPathFolder, jarFileName);
                File jarFile = new File(jarFileAbsolutePath);
                if (!jarFile.exists()) continue;
                jarFile.delete();
            }
        }
    }

    private void reLoadConnectors(SProcessDefinition sProcessDefinition, long tenantId, String connectorId, String connectorVersion) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        String connectorKey = this.buildConnectorImplementationKey(sProcessDefinition.getId(), connectorId, connectorVersion);
        try {
            this.cacheService.remove(CONNECTOR_CACHE_NAME, connectorKey);
            this.loadConnectors(sProcessDefinition, tenantId);
        }
        catch (SCacheException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
    }

    private String handleEntryName(File connectorImplFolder, String entryName) {
        entryName = entryName.replace('/', File.separatorChar);
        entryName = entryName.replace('\\', File.separatorChar);
        return connectorImplFolder.getAbsolutePath() + File.separatorChar + entryName;
    }

    private String handleClasspathEntryName(File classpathFolder, String entryName) {
        int startIndex = Math.max(0, entryName.lastIndexOf(47));
        return classpathFolder.getAbsolutePath() + File.separatorChar + entryName.substring(startIndex);
    }

    @Override
    public Long getNumberOfConnectorImplementations(long processDefinitionId, long tenantId) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        return this.getAllConnectorImplementations(processDefinitionId, tenantId).size();
    }

    @Override
    public List<SConnectorImplementationDescriptor> getConnectorImplementations(long processDefinitionId, long tenantId, int fromIndex, int numberPerPage, String field, OrderByType order) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        List<SConnectorImplementationDescriptor> sConnectorImplementationDescriptors = this.getAllConnectorImplementations(processDefinitionId, tenantId);
        if (sConnectorImplementationDescriptors != null && sConnectorImplementationDescriptors.size() > 0) {
            int endIndex;
            if (sConnectorImplementationDescriptors.size() <= fromIndex) {
                throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("page out of range excepton. Total size is <" + sConnectorImplementationDescriptors.size() + ">, but from index is <" + fromIndex + ">");
            }
            SConnectorImplementationDescriptor.comparedFiled = field;
            Collections.sort(sConnectorImplementationDescriptors);
            if (order != null && order == OrderByType.DESC) {
                Collections.reverse(sConnectorImplementationDescriptors);
            }
            if ((endIndex = fromIndex + numberPerPage) >= sConnectorImplementationDescriptors.size()) {
                endIndex = sConnectorImplementationDescriptors.size();
            }
            return sConnectorImplementationDescriptors.subList(fromIndex, endIndex);
        }
        return Collections.emptyList();
    }

    private List<SConnectorImplementationDescriptor> getAllConnectorImplementations(long processDefinitionId, long tenantId) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        List<SConnectorImplementationDescriptor> sConnectorImplementationDescriptors = null;
        try {
            int size = this.cacheService.getCacheSize(CONNECTOR_CACHE_NAME);
            if (size == 0) {
                this.loadConnectors(processDefinitionId, tenantId);
            }
            if ((sConnectorImplementationDescriptors = this.getConnectorImplementationsFromCacheService(processDefinitionId, tenantId)).isEmpty()) {
                this.loadConnectors(processDefinitionId, tenantId);
                sConnectorImplementationDescriptors = this.getConnectorImplementationsFromCacheService(processDefinitionId, tenantId);
            }
        }
        catch (SCacheException e) {
            // empty catch block
        }
        return sConnectorImplementationDescriptors;
    }

    private List<SConnectorImplementationDescriptor> getConnectorImplementationsFromCacheService(long processDefinitionId, long tenantId) throws SCacheException, org.bonitasoft.engine.core.connector.exception.SConnectorException {
        ArrayList<SConnectorImplementationDescriptor> sConnectorImplementationDescriptors = new ArrayList<SConnectorImplementationDescriptor>();
        List<Object> cacheKeys = this.cacheService.getKeys(CONNECTOR_CACHE_NAME);
        if (cacheKeys.size() > 0) {
            for (Object cacheKey : cacheKeys) {
                if (!String.valueOf(cacheKey).startsWith(String.valueOf(processDefinitionId))) continue;
                SConnectorImplementationDescriptor connectorImplementationDescriptor = (SConnectorImplementationDescriptor)this.cacheService.get(CONNECTOR_CACHE_NAME, cacheKey);
                if (!this.isGoodImplementation(connectorImplementationDescriptor)) {
                    this.loadConnectors(processDefinitionId, tenantId);
                    connectorImplementationDescriptor = (SConnectorImplementationDescriptor)this.cacheService.get(CONNECTOR_CACHE_NAME, cacheKey);
                }
                sConnectorImplementationDescriptors.add(connectorImplementationDescriptor);
            }
        }
        return sConnectorImplementationDescriptors;
    }

    private boolean isGoodImplementation(SConnectorImplementationDescriptor connectorImplementationDescriptor) {
        return connectorImplementationDescriptor != null && connectorImplementationDescriptor.getImplementationClassName() != null && connectorImplementationDescriptor.getId() != null && connectorImplementationDescriptor.getVersion() != null && connectorImplementationDescriptor.getDefinitionId() != null && connectorImplementationDescriptor.getDefinitionVersion() != null;
    }

    @Override
    public SConnectorImplementationDescriptor getConnectorImplementation(long processDefinitionId, String connectorId, String connectorVersion, long tenantId) throws org.bonitasoft.engine.core.connector.exception.SConnectorException {
        SConnectorImplementationDescriptor connectorImplementationDescriptor;
        try {
            String connectorImplementationNameInCache = this.buildConnectorImplementationKey(processDefinitionId, connectorId, connectorVersion);
            connectorImplementationDescriptor = (SConnectorImplementationDescriptor)this.cacheService.get(CONNECTOR_CACHE_NAME, connectorImplementationNameInCache);
            if (connectorImplementationDescriptor == null) {
                this.loadConnectors(processDefinitionId, tenantId);
                connectorImplementationDescriptor = (SConnectorImplementationDescriptor)this.cacheService.get(CONNECTOR_CACHE_NAME, connectorImplementationNameInCache);
                if (connectorImplementationDescriptor == null) {
                    throw new org.bonitasoft.engine.core.connector.exception.SConnectorException("Connector implementation not found with id = " + connectorId + " and version = " + connectorVersion + " in process + " + processDefinitionId);
                }
            }
        }
        catch (SCacheException e) {
            throw new org.bonitasoft.engine.core.connector.exception.SConnectorException(e);
        }
        return connectorImplementationDescriptor;
    }
}

