/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.document.model.recorder;

import java.util.HashMap;
import org.bonitasoft.engine.core.document.model.SDocument;
import org.bonitasoft.engine.core.document.model.SMappedDocument;
import org.bonitasoft.engine.core.document.model.archive.SAMappedDocument;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;

public class SelectDescriptorBuilder {
    public static SelectListDescriptor<SMappedDocument> getDocumentMappingsForProcessInstance(long processInstanceId, int fromIndex, int maxResults, String sortFieldOrder, OrderByType orderBy) {
        QueryOptions queryOptions;
        String queryName = "getSMappedDocumentOfProcess";
        if (sortFieldOrder == null) {
            queryOptions = new QueryOptions(fromIndex, maxResults);
            queryName = "getSMappedDocumentOfProcessOrderedById";
        } else {
            queryOptions = new QueryOptions(fromIndex, maxResults, SMappedDocument.class, sortFieldOrder, orderBy);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("processInstanceId", processInstanceId);
        return new SelectListDescriptor<SMappedDocument>(queryName, parameters, SMappedDocument.class, queryOptions);
    }

    public static SelectOneDescriptor<SMappedDocument> getSMappedDocumentOfProcessWithName(long processInstanceId, String documentName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(2);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("name", documentName);
        return new SelectOneDescriptor<SMappedDocument>("getSMappedDocumentOfProcessWithName", parameters, SMappedDocument.class);
    }

    public static SelectOneDescriptor<Long> getNumberOfSMappedDocumentOfProcess(long processInstanceId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("processInstanceId", processInstanceId);
        return new SelectOneDescriptor<Long>("getNumberOfSMappedDocumentOfProcess", parameters, SDocument.class);
    }

    public static SelectListDescriptor<SAMappedDocument> getSAMappedDocumentOfProcessWithName(long processInstanceId, String documentName, long time) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("name", documentName);
        parameters.put("time", time);
        return new SelectListDescriptor<SAMappedDocument>("getSAMappedDocumentOfProcessWithName", parameters, SAMappedDocument.class, new QueryOptions(0, 1));
    }

    public static SelectByIdDescriptor<SAMappedDocument> getArchivedDocumentById(long documentId) {
        return new SelectByIdDescriptor<SAMappedDocument>("getArchivedDocumentById", SAMappedDocument.class, documentId);
    }

    public static SelectOneDescriptor<SAMappedDocument> getArchivedVersionOdDocument(long documentId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put("sourceObjectId", documentId);
        return new SelectOneDescriptor<SAMappedDocument>("getArchivedVersionOfDocument", parameters, SAMappedDocument.class);
    }

    public static SelectListDescriptor<SMappedDocument> getDocumentList(String name, long processInstanceId, QueryOptions queryOptions) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("name", name);
        return new SelectListDescriptor<SMappedDocument>("getDocumentList", parameters, SMappedDocument.class, queryOptions);
    }

    public static SelectListDescriptor<SAMappedDocument> getArchivedDocumentList(String name, long processInstanceId, QueryOptions queryOptions, long time) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("name", name);
        parameters.put("time", time);
        return new SelectListDescriptor<SAMappedDocument>("getArchivedDocumentList", parameters, SAMappedDocument.class, queryOptions);
    }

    public static SelectListDescriptor<SMappedDocument> getDocumentListCreatedBefore(String name, long processInstanceId, QueryOptions queryOptions, long time) {
        HashMap<String, Object> parameters = new HashMap<String, Object>(3);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("name", name);
        parameters.put("time", time);
        return new SelectListDescriptor<SMappedDocument>("getDocumentCreatedBeforeList", parameters, SMappedDocument.class, queryOptions);
    }
}

