/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import org.bonitasoft.engine.commons.JavaMethodInvoker;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SOperation;

public class JavaMethodOperationExecutorStrategy
implements OperationExecutorStrategy {
    public static final String TYPE_JAVA_METHOD = "JAVA_METHOD";

    @Override
    public Object computeNewValueForLeftOperand(SOperation operation, Object valueToSetObjectWith, SExpressionContext expressionContext, boolean shouldPersistValue) throws SOperationExecutionException {
        Object objectToInvokeJavaMethodOn = this.extractObjectToInvokeFromContext(operation, expressionContext);
        String methodName = this.extractMethodName(operation);
        String operatorType = this.extractParameterType(operation);
        try {
            return new JavaMethodInvoker().invokeJavaMethod(operation.getRightOperand().getReturnType(), valueToSetObjectWith, objectToInvokeJavaMethodOn, methodName, operatorType);
        }
        catch (Exception e) {
            throw new SOperationExecutionException("Unable to evaluate operation " + operation, e);
        }
    }

    protected String extractParameterType(SOperation operation) {
        String[] split = operation.getOperator().split(":", 2);
        if (split.length > 1) {
            return split[1];
        }
        return null;
    }

    protected String extractMethodName(SOperation operation) {
        String[] split = operation.getOperator().split(":", 2);
        return split[0];
    }

    protected Object extractObjectToInvokeFromContext(SOperation operation, SExpressionContext expressionContext) throws SOperationExecutionException {
        String dataToSet = operation.getLeftOperand().getName();
        Object objectToInvokeJavaMethodOn = expressionContext.getInputValues().get(dataToSet);
        if (objectToInvokeJavaMethodOn == null) {
            throw new SOperationExecutionException("data " + dataToSet + " does not exist");
        }
        return objectToInvokeJavaMethodOn;
    }

    @Override
    public String getOperationType() {
        return TYPE_JAVA_METHOD;
    }
}

