/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.LeftOperandHandler;
import org.bonitasoft.engine.core.operation.LeftOperandHandlerProvider;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategyProvider;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.impl.LeftOperandUpdateStatus;
import org.bonitasoft.engine.core.operation.impl.PersistRightOperandResolver;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.SBonitaReadException;

public class OperationServiceImpl
implements OperationService {
    private final Map<String, LeftOperandHandler> leftOperandHandlersMap;
    private final ExpressionResolverService expressionResolverService;
    private final PersistRightOperandResolver persistRightOperandResolver;
    private final TechnicalLoggerService logger;
    private final OperationExecutorStrategyProvider operationExecutorStrategyProvider;

    public OperationServiceImpl(OperationExecutorStrategyProvider operationExecutorStrategyProvider, LeftOperandHandlerProvider leftOperandHandlerProvider, ExpressionResolverService expressionResolverService, PersistRightOperandResolver persistRightOperandResolver, TechnicalLoggerService logger) {
        this.operationExecutorStrategyProvider = operationExecutorStrategyProvider;
        this.expressionResolverService = expressionResolverService;
        this.persistRightOperandResolver = persistRightOperandResolver;
        this.logger = logger;
        List<LeftOperandHandler> leftOperandHandlers = leftOperandHandlerProvider.getLeftOperandHandlers();
        this.leftOperandHandlersMap = new HashMap<String, LeftOperandHandler>(leftOperandHandlers.size());
        for (LeftOperandHandler leftOperandHandler : leftOperandHandlers) {
            this.leftOperandHandlersMap.put(leftOperandHandler.getType(), leftOperandHandler);
        }
    }

    @Override
    public void execute(SOperation operation, long containerId, String containerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.execute(Arrays.asList(operation), containerId, containerType, expressionContext);
    }

    @Override
    public void execute(List<SOperation> operations, SExpressionContext expressionContext) throws SOperationExecutionException {
        this.execute(operations, (long)expressionContext.getContainerId(), expressionContext.getContainerType(), expressionContext);
    }

    @Override
    public void execute(List<SOperation> operations, long leftOperandContainerId, String leftOperandContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        if (operations.isEmpty()) {
            return;
        }
        this.retrieveLeftOperandsAndPutItInExpressionContextIfNotIn(operations, leftOperandContainerId, leftOperandContainerType, expressionContext);
        Map<SLeftOperand, LeftOperandUpdateStatus> leftOperandUpdates = this.executeOperators(operations, expressionContext);
        this.updateLeftOperands(leftOperandUpdates, leftOperandContainerId, leftOperandContainerType, expressionContext);
    }

    Map<SLeftOperand, LeftOperandUpdateStatus> executeOperators(List<SOperation> operations, SExpressionContext expressionContext) throws SOperationExecutionException {
        HashMap<SLeftOperand, LeftOperandUpdateStatus> leftOperandsToUpdate = new HashMap<SLeftOperand, LeftOperandUpdateStatus>();
        for (int i = 0; i < operations.size(); ++i) {
            SOperation currentOperation = operations.get(i);
            boolean shouldPersistValue = this.persistRightOperandResolver.shouldPersist(i, operations);
            LeftOperandUpdateStatus currentUpdateStatus = this.calculateRightOperandValue(currentOperation, expressionContext, shouldPersistValue);
            if (!this.shouldUpdateLeftOperandContext(leftOperandsToUpdate, currentOperation.getLeftOperand(), currentUpdateStatus)) continue;
            leftOperandsToUpdate.put(currentOperation.getLeftOperand(), currentUpdateStatus);
        }
        return leftOperandsToUpdate;
    }

    private LeftOperandUpdateStatus calculateRightOperandValue(SOperation operation, SExpressionContext expressionContext, boolean shouldPersistValue) throws SOperationExecutionException {
        SLeftOperand leftOperand = operation.getLeftOperand();
        LeftOperandUpdateStatus currentUpdateStatus = new LeftOperandUpdateStatus(operation.getType());
        if (currentUpdateStatus.shouldUpdate()) {
            OperationExecutorStrategy operationExecutorStrategy = this.operationExecutorStrategyProvider.getOperationExecutorStrategy(operation);
            Object rightOperandValue = this.evaluateRightOperandExpression(operation, expressionContext, operation.getRightOperand());
            Object value = operationExecutorStrategy.computeNewValueForLeftOperand(operation, rightOperandValue, expressionContext, shouldPersistValue);
            expressionContext.getInputValues().put(leftOperand.getName(), value);
            this.logOperation(TechnicalLogSeverity.DEBUG, operation, rightOperandValue, expressionContext);
        }
        return currentUpdateStatus;
    }

    boolean shouldUpdateLeftOperandContext(Map<SLeftOperand, LeftOperandUpdateStatus> updateLeftOperands, SLeftOperand leftOperand, LeftOperandUpdateStatus currentUpdateStatus) {
        LeftOperandUpdateStatus previousStatus = updateLeftOperands.get(leftOperand);
        return previousStatus == null || !previousStatus.shouldDelete() && currentUpdateStatus.shouldDelete();
    }

    void updateLeftOperands(Map<SLeftOperand, LeftOperandUpdateStatus> leftOperandUpdates, long leftOperandContainerId, String leftOperandContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        for (Map.Entry<SLeftOperand, LeftOperandUpdateStatus> update : leftOperandUpdates.entrySet()) {
            SLeftOperand leftOperand = update.getKey();
            LeftOperandHandler leftOperandHandler = this.getLeftOperandHandler(leftOperand.getType());
            if (update.getValue().shouldUpdate()) {
                leftOperandHandler.update(leftOperand, expressionContext.getInputValues(), expressionContext.getInputValues().get(leftOperand.getName()), leftOperandContainerId, leftOperandContainerType);
                continue;
            }
            leftOperandHandler.delete(leftOperand, leftOperandContainerId, leftOperandContainerType);
        }
    }

    private LeftOperandHandler getLeftOperandHandler(String type) throws SOperationExecutionException {
        LeftOperandHandler leftOperandHandler = this.leftOperandHandlersMap.get(type);
        if (leftOperandHandler == null) {
            throw new SOperationExecutionException("Left operand type not found: " + type);
        }
        return leftOperandHandler;
    }

    void retrieveLeftOperandsAndPutItInExpressionContextIfNotIn(List<SOperation> operations, long dataContainerId, String dataContainerType, SExpressionContext expressionContext) throws SOperationExecutionException {
        Map<String, Object> inputValues = expressionContext.getInputValues();
        String containerType = expressionContext.getContainerType();
        Long containerId = expressionContext.getContainerId();
        if (containerId == null || containerId != dataContainerId || containerType == null || !containerType.equals(dataContainerType)) {
            return;
        }
        HashMap leftOperandHashMap = new HashMap();
        for (SOperation sOperation : operations) {
            SLeftOperand leftOperand = sOperation.getLeftOperand();
            if (!leftOperandHashMap.containsKey(leftOperand.getType())) {
                leftOperandHashMap.put(leftOperand.getType(), new ArrayList());
            }
            ((List)leftOperandHashMap.get(leftOperand.getType())).add(leftOperand);
        }
        for (Map.Entry entry : leftOperandHashMap.entrySet()) {
            try {
                this.getLeftOperandHandler((String)entry.getKey()).loadLeftOperandInContext((List)entry.getValue(), expressionContext, inputValues);
            }
            catch (SBonitaReadException e) {
                throw new SOperationExecutionException("Unable to retrieve value for operation " + entry.getValue(), e);
            }
        }
    }

    protected Object evaluateRightOperandExpression(SOperation operation, SExpressionContext expressionContext, SExpression sExpression) throws SOperationExecutionException {
        if (sExpression == null) {
            return null;
        }
        try {
            return this.expressionResolverService.evaluate(sExpression, expressionContext);
        }
        catch (ClassCastException e) {
            throw new SOperationExecutionException("Unable to execute operation on " + operation.getLeftOperand().getName() + " with a new value which is not Serializable", e);
        }
        catch (SBonitaException e) {
            throw new SOperationExecutionException(e);
        }
    }

    private void logOperation(TechnicalLogSeverity severity, SOperation operation, Object operationValue, SExpressionContext expressionContext) {
        if (this.logger.isLoggable(this.getClass(), severity)) {
            String message = this.buildLogMessage(operation, operationValue, expressionContext);
            this.logger.log(this.getClass(), severity, message);
        }
    }

    private String buildLogMessage(SOperation operation, Object operationValue, SExpressionContext expressionContext) {
        StringBuilder stb = new StringBuilder();
        stb.append("Executed operation on container [id: '");
        stb.append(expressionContext.getContainerId());
        stb.append("', type: '");
        stb.append(expressionContext.getContainerType());
        stb.append("']. Operation: [left operand: '");
        stb.append(operation.getLeftOperand().getName());
        stb.append("', operator: '");
        stb.append(operation.getOperator());
        stb.append("', operation value: '");
        stb.append(operationValue);
        stb.append("']");
        return stb.toString();
    }
}

