/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import java.util.Iterator;
import java.util.List;
import org.bonitasoft.engine.core.operation.impl.LeftOperandIndexes;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.expression.ExpressionType;
import org.bonitasoft.engine.expression.model.SExpression;

public class OperationsAnalyzer {
    public int findBusinessDataDependencyIndex(String businessDataName, int fromIndex, List<SOperation> operations) {
        if (fromIndex >= operations.size()) {
            return -1;
        }
        for (int i = fromIndex; i < operations.size(); ++i) {
            SExpression rightOperand;
            SOperation operation = operations.get(i);
            if (!this.matches(businessDataName, operation, rightOperand = operation.getRightOperand())) continue;
            return i;
        }
        return -1;
    }

    private boolean matches(String businessDataName, SOperation operation, SExpression expression) {
        boolean matches;
        if (expression == null) {
            return false;
        }
        boolean bl = matches = "BUSINESS_DATA".equals(operation.getLeftOperand().getType()) && businessDataName.equals(expression.getContent()) && ExpressionType.TYPE_BUSINESS_DATA.name().equals(expression.getExpressionType());
        if (!matches && expression.hasDependencies()) {
            Iterator<SExpression> iterator = expression.getDependencies().iterator();
            while (iterator.hasNext() && !matches) {
                matches = this.matches(businessDataName, operation, iterator.next());
            }
        }
        return matches;
    }

    public LeftOperandIndexes calculateIndexes(int indexOfCurrentOperation, List<SOperation> operations) {
        LeftOperandIndexes indexes = new LeftOperandIndexes();
        indexes.setLastIndex(indexOfCurrentOperation);
        SOperation currentOperation = operations.get(indexOfCurrentOperation);
        for (int i = indexOfCurrentOperation + 1; i < operations.size(); ++i) {
            SOperation operation = operations.get(i);
            if (!operation.getLeftOperand().equals(currentOperation.getLeftOperand())) continue;
            indexes.setLastIndex(i);
            if (indexes.getNextIndex() != -1) continue;
            indexes.setNextIndex(i);
        }
        return indexes;
    }
}

