/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.operation.impl;

import java.util.List;
import org.bonitasoft.engine.core.operation.impl.LeftOperandIndexes;
import org.bonitasoft.engine.core.operation.impl.OperationsAnalyzer;
import org.bonitasoft.engine.core.operation.model.SOperation;

public class PersistRightOperandResolver {
    private OperationsAnalyzer operationsAnalyzer;

    public PersistRightOperandResolver(OperationsAnalyzer operationsAnalyzer) {
        this.operationsAnalyzer = operationsAnalyzer;
    }

    public boolean shouldPersist(int currentIndex, List<SOperation> operations) {
        SOperation currentOperation = operations.get(currentIndex);
        if (!"BUSINESS_DATA".equals(currentOperation.getLeftOperand().getType())) {
            return false;
        }
        LeftOperandIndexes leftOperandIndexes = this.operationsAnalyzer.calculateIndexes(currentIndex, operations);
        if (currentIndex == leftOperandIndexes.getLastIndex()) {
            return true;
        }
        int dependencyIndex = this.operationsAnalyzer.findBusinessDataDependencyIndex(currentOperation.getLeftOperand().getName(), currentIndex + 1, operations);
        return dependencyIndex != -1 && dependencyIndex < leftOperandIndexes.getNextIndex();
    }
}

