/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bonitasoft.engine.bpm.process.ActivationState;
import org.bonitasoft.engine.bpm.process.ConfigurationState;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfoCriterion;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.cache.CacheService;
import org.bonitasoft.engine.cache.SCacheException;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.exceptions.SReflectException;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SDeletingEnabledProcessException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDeletionException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDeploymentInfoUpdateException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDisablementException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessEnablementException;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionDeployInfoBuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionLogBuilder;
import org.bonitasoft.engine.core.process.definition.model.builder.SProcessDefinitionLogBuilderFactory;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyDeletionException;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.dependency.SDependencyNotFoundException;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.xml.ElementBindingsFactory;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.ParserFactory;
import org.bonitasoft.engine.xml.XMLWriter;

public class ProcessDefinitionServiceImpl
implements ProcessDefinitionService {
    private static final String SERVER_PROCESS_DEFINITION_XML = "server-process-definition.xml";
    private final CacheService cacheService;
    private final Recorder recorder;
    private final ReadPersistenceService persistenceService;
    private final EventService eventService;
    private final SessionService sessionService;
    private final ReadSessionAccessor sessionAccessor;
    private final Parser parser;
    private final XMLWriter xmlWriter;
    private final QueriableLoggerService queriableLoggerService;
    private final DependencyService dependencyService;

    public ProcessDefinitionServiceImpl(CacheService cacheService, Recorder recorder, ReadPersistenceService persistenceService, EventService eventService, SessionService sessionService, ReadSessionAccessor sessionAccessor, ParserFactory parserFactory, XMLWriter xmlWriter, QueriableLoggerService queriableLoggerService, DependencyService dependencyService) {
        this.cacheService = cacheService;
        this.recorder = recorder;
        this.persistenceService = persistenceService;
        this.eventService = eventService;
        this.sessionService = sessionService;
        this.sessionAccessor = sessionAccessor;
        this.xmlWriter = xmlWriter;
        this.queriableLoggerService = queriableLoggerService;
        this.dependencyService = dependencyService;
        ElementBindingsFactory bindings = BuilderFactory.get(SProcessDefinitionBuilderFactory.class).getElementsBindings();
        this.parser = parserFactory.createParser(bindings);
        InputStream schemaStream = BuilderFactory.get(SProcessDefinitionBuilderFactory.class).getModelSchema();
        try {
            this.parser.setSchema(schemaStream);
        }
        catch (Exception e) {
            throw new BonitaRuntimeException("Unable to configure process definition service", (Throwable)e);
        }
        finally {
            try {
                schemaStream.close();
            }
            catch (IOException e) {
                throw new BonitaRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void delete(long processId) throws SProcessDefinitionNotFoundException, SProcessDeletionException, SDeletingEnabledProcessException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "Deleting a Process definition");
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
            if (ActivationState.ENABLED.name().equals(processDefinitionDeployInfo.getActivationState())) {
                throw new SDeletingEnabledProcessException("Process is enabled.", processDefinitionDeployInfo);
            }
        }
        catch (SProcessDefinitionReadException e) {
            this.log(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processId);
        }
        try {
            this.cacheService.remove("_PROCESSDEF", processId);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("PROCESSDEFINITION", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("PROCESSDEFINITION").setObject(processDefinitionDeployInfo).done();
            }
            DeleteRecord deleteRecord = new DeleteRecord(processDefinitionDeployInfo);
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.log(processId, 1, logBuilder, "delete");
            this.dependencyService.deleteDependencies(processId, ScopeType.PROCESS);
        }
        catch (SCacheException e) {
            this.log(processId, 0, logBuilder, "delete");
            throw new SProcessDefinitionNotFoundException((Throwable)e, processDefinitionDeployInfo);
        }
        catch (SRecorderException e) {
            this.log(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processDefinitionDeployInfo);
        }
        catch (SDependencyNotFoundException e) {
            this.log(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processDefinitionDeployInfo);
        }
        catch (SDependencyDeletionException e) {
            this.log(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processDefinitionDeployInfo);
        }
        catch (SDependencyException e) {
            this.log(processId, 0, logBuilder, "delete");
            throw new SProcessDeletionException((Throwable)e, processDefinitionDeployInfo);
        }
    }

    @Override
    public void disableProcessDeploymentInfo(long processId) throws SProcessDefinitionNotFoundException, SProcessDisablementException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessDisablementException(e);
        }
        if (ActivationState.DISABLED.name().equals(processDefinitionDeployInfo.getActivationState())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Process ");
            stringBuilder.append(processDefinitionDeployInfo.getName());
            stringBuilder.append(" with version ");
            stringBuilder.append(processDefinitionDeployInfo.getVersion());
            stringBuilder.append(" is already disabled");
            throw new SProcessDisablementException(stringBuilder.toString());
        }
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).getActivationStateKey(), ActivationState.DISABLED.name());
        UpdateRecord updateRecord = this.getUpdateRecord(descriptor, processDefinitionDeployInfo);
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Disabling the process");
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROCESSDEFINITION_IS_DISABLED", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSDEFINITION_IS_DISABLED").setObject(processDefinitionDeployInfo).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.log(processDefinitionDeployInfo.getId(), 1, logBuilder, "disableProcess");
        }
        catch (SRecorderException e) {
            this.log(processDefinitionDeployInfo.getId(), 0, logBuilder, "disableProcess");
            throw new SProcessDisablementException(e);
        }
    }

    @Override
    public void enableProcessDeploymentInfo(long processId) throws SProcessDefinitionNotFoundException, SProcessEnablementException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessEnablementException(e);
        }
        if (ActivationState.ENABLED.name().equals(processDefinitionDeployInfo.getActivationState())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Process ");
            stringBuilder.append(processDefinitionDeployInfo.getName());
            stringBuilder.append(" with version ");
            stringBuilder.append(processDefinitionDeployInfo.getVersion());
            stringBuilder.append(" is already enabled");
            throw new SProcessEnablementException(stringBuilder.toString());
        }
        if (ConfigurationState.UNRESOLVED.name().equals(processDefinitionDeployInfo.getConfigurationState())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Process ");
            stringBuilder.append(processDefinitionDeployInfo.getName());
            stringBuilder.append(" with version ");
            stringBuilder.append(processDefinitionDeployInfo.getVersion());
            stringBuilder.append(" can't be enabled since all dependencies are not resolved yet");
            throw new SProcessEnablementException(stringBuilder.toString());
        }
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).getActivationStateKey(), ActivationState.ENABLED.name());
        UpdateRecord updateRecord = this.getUpdateRecord(descriptor, processDefinitionDeployInfo);
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Enabling the process");
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROCESSDEFINITION_IS_ENABLED", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSDEFINITION_IS_ENABLED").setObject(processDefinitionDeployInfo).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.log(processId, 1, logBuilder, "enableProcess");
        }
        catch (SRecorderException e) {
            this.log(processId, 0, logBuilder, "enableProcess");
            throw new SProcessEnablementException(e);
        }
    }

    private SProcessDefinitionLogBuilder getQueriableLog(ActionType actionType, String message) {
        SProcessDefinitionLogBuilder logBuilder = BuilderFactory.get(SProcessDefinitionLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfos(int fromIndex, int numberPerPage, String field, OrderByType order) throws SProcessDefinitionReadException {
        try {
            Map<String, Object> emptyMap = Collections.emptyMap();
            return this.persistenceService.selectList(new SelectListDescriptor("", emptyMap, SProcessDefinitionDeployInfo.class, new QueryOptions(fromIndex, numberPerPage, SProcessDefinitionDeployInfo.class, field, order)));
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfos() throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.emptyMap();
        SelectOneDescriptor selectDescriptor = new SelectOneDescriptor("getNumberOfProcessDefinitions", parameters, SProcessDefinitionDeployInfo.class);
        try {
            return (Long)this.persistenceService.selectOne(selectDescriptor);
        }
        catch (SBonitaReadException bre) {
            throw new SProcessDefinitionReadException(bre);
        }
    }

    @Override
    public SProcessDefinition getProcessDefinition(long processId) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException {
        try {
            long tenantId = this.sessionAccessor.getTenantId();
            SProcessDefinition sProcessDefinition = (SProcessDefinition)this.cacheService.get("_PROCESSDEF", processId);
            if (sProcessDefinition == null) {
                this.getProcessDeploymentInfo(processId);
                String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
                File processFolder = new File(processesFolder, String.valueOf(processId));
                File xmlFile = new File(processFolder, SERVER_PROCESS_DEFINITION_XML);
                this.parser.validate(xmlFile);
                sProcessDefinition = (SProcessDefinition)this.parser.getObjectFromXML(xmlFile);
                this.storeProcessDefinition(processId, sProcessDefinition);
            }
            return sProcessDefinition;
        }
        catch (SCacheException e) {
            throw new SProcessDefinitionNotFoundException((Throwable)e, processId);
        }
        catch (SProcessDefinitionNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public SProcessDefinition getProcessDefinitionIfIsEnabled(long processDefinitionId) throws SProcessDefinitionReadException, SProcessDefinitionException {
        SProcessDefinitionDeployInfo deployInfo = this.getProcessDeploymentInfo(processDefinitionId);
        if (ActivationState.DISABLED.name().equals(deployInfo.getActivationState())) {
            throw new SProcessDefinitionException("The process definition is not enabled !!", deployInfo.getProcessId(), deployInfo.getName(), deployInfo.getVersion());
        }
        return this.getProcessDefinition(processDefinitionId);
    }

    private long setIdOnProcessDefinition(SProcessDefinition sProcessDefinition) throws SReflectException {
        long id = this.generateId();
        ClassReflector.invokeSetter(sProcessDefinition, "setId", Long.class, id);
        return id;
    }

    protected long generateId() {
        return Math.abs(UUID.randomUUID().getLeastSignificantBits());
    }

    private void storeProcessDefinition(Long id, SProcessDefinition sProcessDefinition) throws SCacheException {
        this.cacheService.store("_PROCESSDEF", id, sProcessDefinition);
    }

    @Override
    public SProcessDefinitionDeployInfo getProcessDeploymentInfo(long processId) throws SProcessDefinitionNotFoundException, SProcessDefinitionReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("processId", processId);
            SelectOneDescriptor descriptor = new SelectOneDescriptor("getDeployInfoByProcessDefId", parameters, SProcessDefinitionDeployInfo.class);
            SProcessDefinitionDeployInfo processDefinitionDeployInfo = (SProcessDefinitionDeployInfo)this.persistenceService.selectOne(descriptor);
            if (processDefinitionDeployInfo == null) {
                throw new SProcessDefinitionNotFoundException("Unable to find the process definition deployment info.", processId);
            }
            return processDefinitionDeployInfo;
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SProcessDefinition store(SProcessDefinition definition, String displayName, String displayDescription) throws SProcessDefinitionException {
        NullCheckingUtil.checkArgsNotNull(definition);
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Creating a new Process definition");
        try {
            long tenantId = this.sessionAccessor.getTenantId();
            long processId = this.setIdOnProcessDefinition(definition);
            String processesFolder = BonitaHomeServer.getInstance().getProcessesFolder(tenantId);
            File processFolder = new File(processesFolder, String.valueOf(processId));
            if (!processFolder.exists()) {
                processFolder.mkdirs();
                processFolder.mkdir();
            }
            FileOutputStream outputStream = new FileOutputStream(new File(processFolder, SERVER_PROCESS_DEFINITION_XML));
            try {
                this.xmlWriter.write(BuilderFactory.get(SProcessDefinitionBuilderFactory.class).getXMLProcessDefinition(definition), outputStream);
            }
            finally {
                outputStream.close();
            }
            if (displayName == null || displayName.isEmpty()) {
                displayName = definition.getName();
            }
            if (displayDescription == null || displayDescription.isEmpty()) {
                displayDescription = definition.getDescription();
            }
            SProcessDefinitionDeployInfo definitionDeployInfo = BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).createNewInstance(definition.getName(), definition.getVersion()).setProcessId(processId).setDescription(definition.getDescription()).setDeployedBy(this.getUserId()).setDeploymentDate(System.currentTimeMillis()).setActivationState(ActivationState.DISABLED.name()).setConfigurationState(ConfigurationState.UNRESOLVED.name()).setDisplayName(displayName).setDisplayDescription(displayDescription).done();
            InsertRecord record = new InsertRecord(definitionDeployInfo);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("PROCESSDEFINITION", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("PROCESSDEFINITION").setObject(definitionDeployInfo).done();
            }
            this.recorder.recordInsert(record, insertEvent);
            this.log(definition.getId(), 1, logBuilder, "store");
        }
        catch (SRecorderException e) {
            this.log(definition.getId(), 0, logBuilder, "store");
            throw new SProcessDefinitionException(e);
        }
        catch (Exception e) {
            this.log(definition.getId(), 0, logBuilder, "store");
            throw new SProcessDefinitionException(e);
        }
        return definition;
    }

    private long getUserId() {
        return this.sessionService.getLoggedUserFromSession(this.sessionAccessor);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public void resolveProcess(long processId) throws SProcessDefinitionNotFoundException, SProcessDisablementException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessDisablementException(e);
        }
        if (!ConfigurationState.UNRESOLVED.name().equals(processDefinitionDeployInfo.getConfigurationState())) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Process ");
            stringBuilder.append(processDefinitionDeployInfo.getName());
            stringBuilder.append(" with version");
            stringBuilder.append(processDefinitionDeployInfo.getVersion());
            stringBuilder.append(" is not unresolved");
            throw new SProcessDisablementException(stringBuilder.toString());
        }
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).getConfigurationStateKey(), ConfigurationState.RESOLVED.name());
        UpdateRecord updateRecord = this.getUpdateRecord(descriptor, processDefinitionDeployInfo);
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Resolved the process");
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROCESSDEFINITION_IS_RESOLVED", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSDEFINITION_IS_RESOLVED").setObject(processDefinitionDeployInfo).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.log(processDefinitionDeployInfo.getId(), 1, logBuilder, "resolveProcess");
        }
        catch (SRecorderException e) {
            this.log(processDefinitionDeployInfo.getId(), 0, logBuilder, "resolveProcess");
            throw new SProcessDisablementException(e);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosByActivationState(ActivationState activationState) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("activationState", activationState.name());
        SelectOneDescriptor selectDescriptor = new SelectOneDescriptor("getNumberOfProcessDefinitionsInActivationState", parameters, SProcessDefinitionDeployInfo.class);
        try {
            return (Long)this.persistenceService.selectOne(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<Long> getProcessDefinitionIds(ActivationState activationState, int fromIndex, int numberOfResults) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("activationState", activationState.name());
        List<OrderByOption> orderByOptions = Arrays.asList(new OrderByOption(SProcessDefinitionDeployInfo.class, "id", OrderByType.ASC));
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessDefinitionsIdsInActivationState", parameters, SProcessDefinitionDeployInfo.class, new QueryOptions(fromIndex, numberOfResults, orderByOptions));
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<Long> getProcessDefinitionIds(int fromIndex, int numberOfResults) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.emptyMap();
        List<OrderByOption> orderByOptions = Arrays.asList(new OrderByOption(SProcessDefinitionDeployInfo.class, "id", OrderByType.ASC));
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessDefinitionsIds", parameters, SProcessDefinitionDeployInfo.class, new QueryOptions(fromIndex, numberOfResults, orderByOptions));
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public SFlowNodeDefinition getNextFlowNode(SProcessDefinition definition, String source) {
        SFlowElementContainerDefinition processContainer = definition.getProcessContainer();
        STransitionDefinition sourceNode = processContainer.getTransition(source);
        long targetId = sourceNode.getTarget();
        return processContainer.getFlowNode(targetId);
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfos(List<Long> processIds, int fromIndex, int numberOfProcesses, String field, OrderByType order) throws SProcessDefinitionReadException {
        if (processIds == null || processIds.size() == 0) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> emptyMap = Collections.singletonMap("processIds", processIds);
            QueryOptions queryOptions = new QueryOptions(fromIndex, numberOfProcesses, SProcessDefinitionDeployInfo.class, field, order);
            List<SProcessDefinitionDeployInfo> results = this.persistenceService.selectList(new SelectListDescriptor("getSubSetOfProcessDefinitionDeployInfos", emptyMap, SProcessDefinitionDeployInfo.class, queryOptions));
            return results;
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfos(List<Long> processIds) throws SProcessDefinitionReadException {
        if (processIds == null || processIds.size() == 0) {
            return Collections.emptyList();
        }
        try {
            QueryOptions queryOptions = new QueryOptions(0, processIds.size(), SProcessDefinitionDeployInfo.class, "name", OrderByType.ASC);
            Map<String, Object> emptyMap = Collections.singletonMap("processIds", processIds);
            return this.persistenceService.selectList(new SelectListDescriptor("getSubSetOfProcessDefinitionDeployInfos", emptyMap, SProcessDefinitionDeployInfo.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public long getLatestProcessDefinitionId(String processName) throws SProcessDefinitionReadException, SProcessDefinitionNotFoundException {
        List<SProcessDefinitionDeployInfo> sProcessDefinitionDeployInfos = this.getProcessDeploymentInfosOrderByTimeDesc(processName, 0, 1);
        if (sProcessDefinitionDeployInfos.isEmpty()) {
            throw new SProcessDefinitionNotFoundException(processName);
        }
        return sProcessDefinitionDeployInfos.get(0).getProcessId();
    }

    private List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosOrderByTimeDesc(String processName, int startIndex, int maxResults) throws SProcessDefinitionReadException {
        QueryOptions queryOptions = new QueryOptions(startIndex, maxResults, SProcessDefinitionDeployInfo.class, "deploymentDate", OrderByType.DESC);
        Map<String, Object> parameters = Collections.singletonMap("name", processName);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessDefinitionDeployInfosByName", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public long getProcessDefinitionId(String name, String version) throws SProcessDefinitionReadException, SProcessDefinitionNotFoundException {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("name", name);
            parameters.put("version", version);
            Long processDefId = this.persistenceService.selectOne(new SelectOneDescriptor<Long>("getProcessDefinitionIdByNameAndVersion", parameters, SProcessDefinitionDeployInfo.class, Long.class));
            if (processDefId == null) {
                SProcessDefinitionNotFoundException exception = new SProcessDefinitionNotFoundException("Process definition id not found.");
                exception.setProcessDefinitionNameOnContext(name);
                exception.setProcessDefinitionVersionOnContext(version);
                throw exception;
            }
            return processDefId;
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public SProcessDefinitionDeployInfo updateProcessDefinitionDeployInfo(long processId, EntityUpdateDescriptor descriptor) throws SProcessDefinitionNotFoundException, SProcessDeploymentInfoUpdateException {
        SProcessDefinitionDeployInfo processDefinitionDeployInfo;
        try {
            processDefinitionDeployInfo = this.getProcessDeploymentInfo(processId);
        }
        catch (SProcessDefinitionReadException e) {
            throw new SProcessDefinitionNotFoundException((Throwable)e, processId);
        }
        SProcessDefinitionLogBuilder logBuilder = this.getQueriableLog(ActionType.UPDATED, "Updating a processDefinitionDeployInfo");
        UpdateRecord updateRecord = this.getUpdateRecord(descriptor, processDefinitionDeployInfo);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROCESSDEFINITION_DEPLOY_INFO", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSDEFINITION_DEPLOY_INFO").setObject(processDefinitionDeployInfo).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.log(processId, 1, logBuilder, "updateProcessDeploymentInfo");
        }
        catch (SRecorderException e) {
            this.log(processId, 0, logBuilder, "updateProcessDeploymentInfo");
            throw new SProcessDeploymentInfoUpdateException(e);
        }
        return processDefinitionDeployInfo;
    }

    private UpdateRecord getUpdateRecord(EntityUpdateDescriptor descriptor, SProcessDefinitionDeployInfo processDefinitionDeployInfo) {
        long now = System.currentTimeMillis();
        descriptor.addField(BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class).getLastUpdateDateKey(), now);
        return UpdateRecord.buildSetFields((PersistentObject)processDefinitionDeployInfo, descriptor);
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosStartedBy(long startedBy, QueryOptions searchOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("startedBy", startedBy);
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "StartedBy", searchOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosStartedBy(long startedBy, QueryOptions countOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("startedBy", startedBy);
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "StartedBy", countOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfos(QueryOptions searchOptions) throws SBonitaReadException {
        return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, searchOptions, null);
    }

    @Override
    public long getNumberOfProcessDeploymentInfos(QueryOptions countOptions) throws SBonitaReadException {
        return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, countOptions, null);
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosCanBeStartedBy(long userId, QueryOptions searchOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "UserCanStart", searchOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosCanBeStartedBy(long userId, QueryOptions countOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "UserCanStart", countOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosCanBeStartedByUsersManagedBy(long managerUserId, QueryOptions searchOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "UsersManagedByCanStart", searchOptions, Collections.singletonMap("managerUserId", managerUserId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosCanBeStartedByUsersManagedBy(long managerUserId, QueryOptions countOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "UsersManagedByCanStart", countOptions, Collections.singletonMap("managerUserId", managerUserId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfos(long userId, QueryOptions searchOptions, String querySuffix) throws SBonitaReadException {
        return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, querySuffix, searchOptions, Collections.singletonMap("userId", userId));
    }

    @Override
    public long getNumberOfProcessDeploymentInfos(long userId, QueryOptions countOptions, String querySuffix) throws SBonitaReadException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, querySuffix, countOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfUncategorizedProcessDeploymentInfos(QueryOptions countOptions) throws SBonitaReadException {
        return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "Uncategorized", countOptions, null);
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchUncategorizedProcessDeploymentInfos(QueryOptions searchOptions) throws SBonitaReadException {
        return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "Uncategorized", searchOptions, null);
    }

    @Override
    public long getNumberOfUncategorizedProcessDeploymentInfosSupervisedBy(long userId, QueryOptions countOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "UncategorizedAndWithSupervisor", countOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchUncategorizedProcessDeploymentInfosSupervisedBy(long userId, QueryOptions searchOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "UncategorizedAndWithSupervisor", searchOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchUncategorizedProcessDeploymentInfosCanBeStartedBy(long userId, QueryOptions searchOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "UncategorizedUserCanStart", searchOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfUncategorizedProcessDeploymentInfosCanBeStartedBy(long userId, QueryOptions countOptions) throws SBonitaReadException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "UncategorizedUserCanStart", countOptions, Collections.singletonMap("userId", userId));
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public Map<Long, SProcessDefinitionDeployInfo> getProcessDeploymentInfosFromProcessInstanceIds(List<Long> processInstanceIds) throws SBonitaReadException {
        if (processInstanceIds == null || processInstanceIds.size() == 0) {
            return Collections.emptyMap();
        }
        try {
            QueryOptions queryOptions = new QueryOptions(0, processInstanceIds.size(), SProcessDefinitionDeployInfo.class, "name", OrderByType.ASC);
            Map<String, Object> parameters = Collections.singletonMap("processInstanceIds", processInstanceIds);
            List<Map<String, Object>> result = this.persistenceService.selectList(new SelectListDescriptor("getProcessDeploymentInfoFromProcessInstanceIds", parameters, SProcessDefinitionDeployInfo.class, queryOptions));
            if (result != null && result.size() > 0) {
                return this.getProcessDeploymentInfosFromMap(result);
            }
        }
        catch (SBonitaReadException e) {
            throw new SBonitaReadException(e);
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<Long, SProcessDefinitionDeployInfo> getProcessDeploymentInfosFromArchivedProcessInstanceIds(List<Long> archivedProcessInstantsIds) throws SProcessDefinitionReadException {
        if (archivedProcessInstantsIds == null || archivedProcessInstantsIds.size() == 0) {
            return Collections.emptyMap();
        }
        try {
            QueryOptions queryOptions = new QueryOptions(0, archivedProcessInstantsIds.size(), SProcessDefinitionDeployInfo.class, "name", OrderByType.ASC);
            Map<String, Object> parameters = Collections.singletonMap("archivedProcessInstanceIds", archivedProcessInstantsIds);
            List<Map<String, Object>> result = this.persistenceService.selectList(new SelectListDescriptor("getProcessDeploymentInfoFromArchivedProcessInstanceIds", parameters, SProcessDefinitionDeployInfo.class, queryOptions));
            if (result != null && result.size() > 0) {
                return this.getProcessDeploymentInfosFromMap(result);
            }
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
        return Collections.emptyMap();
    }

    private Map<Long, SProcessDefinitionDeployInfo> getProcessDeploymentInfosFromMap(List<Map<String, Object>> sProcessDeploymentInfos) {
        HashMap<Long, SProcessDefinitionDeployInfo> mProcessDeploymentInfos = new HashMap<Long, SProcessDefinitionDeployInfo>();
        for (Map<String, Object> sProcessDeploymentInfo : sProcessDeploymentInfos) {
            Long archivedProcessInstanceId = (Long)sProcessDeploymentInfo.get("archivedProcessInstanceId");
            Long processInstanceId = (Long)sProcessDeploymentInfo.get("processInstanceId");
            SProcessDefinitionDeployInfo sProcessDefinitionDeployInfo = this.buildSProcessDefinitionDeployInfo(sProcessDeploymentInfo);
            mProcessDeploymentInfos.put(processInstanceId != null ? processInstanceId : archivedProcessInstanceId, sProcessDefinitionDeployInfo);
        }
        return mProcessDeploymentInfos;
    }

    private SProcessDefinitionDeployInfo buildSProcessDefinitionDeployInfo(Map<String, Object> sProcessDeploymentInfo) {
        SProcessDefinitionDeployInfoBuilderFactory builder = BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class);
        Long id = (Long)sProcessDeploymentInfo.get(builder.getIdKey());
        Long processId = (Long)sProcessDeploymentInfo.get(builder.getProcessIdKey());
        String name = (String)sProcessDeploymentInfo.get(builder.getNameKey());
        String version = (String)sProcessDeploymentInfo.get(builder.getVersionKey());
        String description = (String)sProcessDeploymentInfo.get(builder.getVersionKey());
        Long deploymentDate = (Long)sProcessDeploymentInfo.get(builder.getDeploymentDateKey());
        Long deployedBy = (Long)sProcessDeploymentInfo.get(builder.getDeployedByKey());
        String activationState = (String)sProcessDeploymentInfo.get(builder.getActivationStateKey());
        String configurationState = (String)sProcessDeploymentInfo.get(builder.getConfigurationStateKey());
        String displayName = (String)sProcessDeploymentInfo.get(builder.getDisplayNameKey());
        Long lastUpdateDate = (Long)sProcessDeploymentInfo.get(builder.getLastUpdateDateKey());
        String iconPath = (String)sProcessDeploymentInfo.get(builder.getIconPathKey());
        String displayDescription = (String)sProcessDeploymentInfo.get(builder.getDisplayDescriptionKey());
        return builder.createNewInstance(name, version).setId(id).setDescription(description).setDisplayDescription(displayDescription).setActivationState(activationState).setConfigurationState(configurationState).setDeployedBy(deployedBy).setProcessId(processId).setLastUpdateDate(lastUpdateDate).setDisplayName(displayName).setDeploymentDate(deploymentDate).setIconPath(iconPath).done();
    }

    private void log(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosUnrelatedToCategory(long categoryId, int pageIndex, int numberPerPage, ProcessDeploymentInfoCriterion pagingCriterion) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("categoryId", categoryId);
        QueryOptions queryOptions = this.createQueryOptions(pageIndex, numberPerPage, pagingCriterion);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("searchSProcessDefinitionDeployInfoUnrelatedToCategory", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public Long getNumberOfProcessDeploymentInfosUnrelatedToCategory(long categoryId) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("categoryId", categoryId);
        SelectOneDescriptor selectDescriptor = new SelectOneDescriptor("getNumberOfSProcessDefinitionDeployInfoUnrelatedToCategory", parameters, SProcessDefinitionDeployInfo.class);
        try {
            return (Long)this.persistenceService.selectOne(selectDescriptor);
        }
        catch (SBonitaReadException bre) {
            throw new SProcessDefinitionReadException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosOfCategory(long categoryId, QueryOptions queryOptions) throws SBonitaReadException {
        Map<String, Object> parameters = Collections.singletonMap("categoryId", categoryId);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("searchSProcessDeploymentInfosOfCategory", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        return this.persistenceService.selectList(selectDescriptor);
    }

    private QueryOptions createQueryOptions(int pageIndex, int numberPerPage, ProcessDeploymentInfoCriterion pagingCriterion) {
        String field = null;
        OrderByType order = null;
        SProcessDefinitionDeployInfoBuilderFactory fact = BuilderFactory.get(SProcessDefinitionDeployInfoBuilderFactory.class);
        switch (pagingCriterion) {
            case LABEL_ASC: {
                field = pagingCriterion.getField();
                order = OrderByType.ASC;
                break;
            }
            case LABEL_DESC: {
                field = pagingCriterion.getField();
                order = OrderByType.DESC;
                break;
            }
            case NAME_ASC: {
                field = fact.getNameKey();
                order = OrderByType.ASC;
                break;
            }
            case NAME_DESC: {
                field = fact.getNameKey();
                order = OrderByType.DESC;
                break;
            }
            case ACTIVATION_STATE_ASC: {
                field = fact.getActivationStateKey();
                order = OrderByType.ASC;
                break;
            }
            case ACTIVATION_STATE_DESC: {
                field = fact.getActivationStateKey();
                order = OrderByType.DESC;
                break;
            }
            case CONFIGURATION_STATE_ASC: {
                field = fact.getConfigurationStateKey();
                order = OrderByType.ASC;
                break;
            }
            case CONFIGURATION_STATE_DESC: {
                field = fact.getConfigurationStateKey();
                order = OrderByType.DESC;
                break;
            }
            case VERSION_ASC: {
                field = fact.getVersionKey();
                order = OrderByType.ASC;
                break;
            }
            case VERSION_DESC: {
                field = fact.getVersionKey();
                order = OrderByType.DESC;
                break;
            }
            default: {
                field = pagingCriterion.getField();
                order = OrderByType.valueOf(pagingCriterion.getOrder().name());
            }
        }
        return new QueryOptions(pageIndex, numberPerPage, SProcessDefinitionDeployInfo.class, field, order);
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfos(QueryOptions queryOptions) throws SProcessDefinitionReadException {
        try {
            return this.persistenceService.selectList(new SelectListDescriptor("getProcessDefinitionDeployInfos", Collections.<String, Object>emptyMap(), SProcessDefinitionDeployInfo.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForGroup(long groupId, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("groupId", groupId);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForGroup", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForGroups(List<Long> groupIds, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("groupIds", groupIds);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForGroups", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForRole(long roleId, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("roleId", roleId);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForRole", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForRoles(List<Long> roleIds, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("roleIds", roleIds);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForRoles", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForUser(long userId, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("userId", userId);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForUser", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> getProcessDeploymentInfosWithActorOnlyForUsers(List<Long> userIds, QueryOptions queryOptions) throws SProcessDefinitionReadException {
        Map<String, Object> parameters = Collections.singletonMap("userIds", userIds);
        SelectListDescriptor selectDescriptor = new SelectListDescriptor("getProcessesWithActorOnlyForUsers", parameters, SProcessDefinitionDeployInfo.class, queryOptions);
        try {
            return this.persistenceService.selectList(selectDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessDefinitionReadException(e);
        }
    }

    @Override
    public long getNumberOfUsersWhoCanStartProcessDeploymentInfo(long processDefinitionId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("processId", processDefinitionId);
            return this.persistenceService.getNumberOfEntities(SUser.class, "WhoCanStartProcess", queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SUser> searchUsersWhoCanStartProcessDeploymentInfo(long processDefinitionId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("processId", processDefinitionId);
            return this.persistenceService.searchEntity(SUser.class, "WhoCanStartProcess", queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "WithAssignedOrPendingHumanTasksFor", queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksFor(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "WithAssignedOrPendingHumanTasksFor", queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "WithAssignedOrPendingHumanTasksSupervisedBy", queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasksSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap("userId", userId);
            return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "WithAssignedOrPendingHumanTasksSupervisedBy", queryOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDeploymentInfosWithAssignedOrPendingHumanTasks(QueryOptions queryOptions) throws SBonitaReadException {
        return this.persistenceService.getNumberOfEntities(SProcessDefinitionDeployInfo.class, "WithAssignedOrPendingHumanTasks", queryOptions, null);
    }

    @Override
    public List<SProcessDefinitionDeployInfo> searchProcessDeploymentInfosWithAssignedOrPendingHumanTasks(QueryOptions queryOptions) throws SBonitaReadException {
        return this.persistenceService.searchEntity(SProcessDefinitionDeployInfo.class, "WithAssignedOrPendingHumanTasks", queryOptions, null);
    }
}

