/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.GatewayInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SGatewayReadException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.SGatewayInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.impl.SGatewayInstanceImpl;
import org.bonitasoft.engine.core.process.instance.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;

public class GatewayInstanceServiceImpl
implements GatewayInstanceService {
    public static final Class<GatewayInstanceServiceImpl> TAG = GatewayInstanceServiceImpl.class;
    private final Recorder recorder;
    private final EventService eventService;
    private final ReadPersistenceService persistenceRead;
    private final SGatewayInstanceBuilderFactory sGatewayInstanceBuilderFactory;
    private FlowNodeInstanceService flowNodeInstanceService;
    private final TechnicalLoggerService logger;

    public GatewayInstanceServiceImpl(Recorder recorder, EventService eventService, ReadPersistenceService persistenceRead, TechnicalLoggerService logger, FlowNodeInstanceService flowNodeInstanceService) {
        this.recorder = recorder;
        this.eventService = eventService;
        this.persistenceRead = persistenceRead;
        this.logger = logger;
        this.flowNodeInstanceService = flowNodeInstanceService;
        this.sGatewayInstanceBuilderFactory = BuilderFactory.get(SGatewayInstanceBuilderFactory.class);
    }

    @Override
    public void createGatewayInstance(SGatewayInstance gatewayInstance) throws SGatewayCreationException {
        InsertRecord insertRecord = new InsertRecord(gatewayInstance);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("GATEWAYINSTANCE", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("GATEWAYINSTANCE").setObject(gatewayInstance).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
        }
        catch (SRecorderException e) {
            throw new SGatewayCreationException(e);
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            StringBuilder stb = new StringBuilder();
            stb.append("Created gateway instance [name = <" + gatewayInstance.getName());
            stb.append(">, id = <" + gatewayInstance.getId());
            stb.append(">, parent process instance id = <" + gatewayInstance.getParentProcessInstanceId());
            stb.append(">, root process instance id = <" + gatewayInstance.getRootProcessInstanceId());
            stb.append(">, process definition id = <" + gatewayInstance.getRootProcessInstanceId());
            stb.append(">]");
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, stb.toString());
        }
    }

    @Override
    public SGatewayInstance getGatewayInstance(long gatewayInstanceId) throws SGatewayNotFoundException, SGatewayReadException {
        SGatewayInstance selectOne;
        try {
            selectOne = this.persistenceRead.selectById(SelectDescriptorBuilder.getElementById(SGatewayInstance.class, "SGatewayInstance", gatewayInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SGatewayReadException(e);
        }
        if (selectOne == null) {
            throw new SGatewayNotFoundException(gatewayInstanceId);
        }
        return selectOne;
    }

    @Override
    public boolean checkMergingCondition(SProcessDefinition sDefinition, SGatewayInstance gatewayInstance) throws SBonitaException {
        switch (gatewayInstance.getGatewayType()) {
            case EXCLUSIVE: {
                return true;
            }
            case INCLUSIVE: {
                return this.isInclusiveGatewayActivated(sDefinition, gatewayInstance);
            }
            case PARALLEL: {
                return this.isParallelGatewayActivated(sDefinition, gatewayInstance);
            }
        }
        return false;
    }

    boolean isInclusiveGatewayActivated(SProcessDefinition sDefinition, SGatewayInstance gatewayInstance) throws SBonitaReadException {
        this.logger.log(TAG, TechnicalLogSeverity.DEBUG, "Evaluate if gateway " + gatewayInstance.getName() + " of instance " + gatewayInstance.getRootProcessInstanceId() + " of definition " + sDefinition.getName() + " must be activated ");
        SFlowElementContainerDefinition processContainer = sDefinition.getProcessContainer();
        SFlowNodeDefinition gatewayDefinition = processContainer.getFlowNode(gatewayInstance.getFlowNodeDefinitionId());
        long processInstanceId = gatewayInstance.getParentContainerId();
        List<String> hitByTransitionList = this.getHitByTransitionList(gatewayInstance);
        List<STransitionDefinition> incomingTransitions = gatewayDefinition.getIncomingTransitions();
        ArrayList<STransitionDefinition> incomingWithTokens = new ArrayList<STransitionDefinition>();
        ArrayList<STransitionDefinition> incomingWithoutTokens = new ArrayList<STransitionDefinition>();
        this.logger.log(TAG, TechnicalLogSeverity.DEBUG, "HitBys = " + gatewayInstance.getHitBys());
        for (int i = 0; i < incomingTransitions.size(); ++i) {
            STransitionDefinition currentTransition = incomingTransitions.get(i);
            if (hitByTransitionList.contains(String.valueOf(i + 1))) {
                incomingWithTokens.add(currentTransition);
                continue;
            }
            incomingWithoutTokens.add(currentTransition);
        }
        ArrayList<STransitionDefinition> finishWithAToken = new ArrayList<STransitionDefinition>();
        ArrayList<STransitionDefinition> doesNotFinishWithAToken = new ArrayList<STransitionDefinition>();
        this.addBackwardReachableTransitions(processContainer, gatewayDefinition, incomingWithTokens, finishWithAToken, Collections.<STransitionDefinition>emptyList());
        this.addBackwardReachableTransitions(processContainer, gatewayDefinition, incomingWithoutTokens, doesNotFinishWithAToken, finishWithAToken);
        return !this.transitionsContainsAToken(doesNotFinishWithAToken, gatewayDefinition, processInstanceId, processContainer);
    }

    boolean transitionsContainsAToken(List<STransitionDefinition> transitions, SFlowNodeDefinition gatewayDefinition, long processInstanceId, SFlowElementContainerDefinition processContainer) throws SBonitaReadException {
        ArrayList<SFlowNodeDefinition> sourceElements = new ArrayList<SFlowNodeDefinition>();
        ArrayList<SFlowNodeDefinition> targetElements = new ArrayList<SFlowNodeDefinition>();
        this.logger.log(TAG, TechnicalLogSeverity.DEBUG, "Check if there is a token on " + transitions);
        for (STransitionDefinition sTransitionDefinition : transitions) {
            SFlowNodeDefinition target;
            SFlowNodeDefinition source = processContainer.getFlowNode(sTransitionDefinition.getSource());
            if (!source.equals(gatewayDefinition) && !sourceElements.contains(source)) {
                sourceElements.add(source);
            }
            if ((target = processContainer.getFlowNode(sTransitionDefinition.getTarget())).equals(gatewayDefinition) || targetElements.contains(target)) continue;
            targetElements.add(target);
        }
        List<SFlowNodeDefinition> sourceAndTarget = this.extractElementThatAreSourceAndTarget(sourceElements, targetElements);
        if (this.containsToken(processInstanceId, sourceAndTarget, null)) {
            return true;
        }
        if (this.containsToken(processInstanceId, sourceElements, true)) {
            return true;
        }
        if (this.containsToken(processInstanceId, targetElements, false)) {
            return true;
        }
        this.logger.log(TAG, TechnicalLogSeverity.DEBUG, "No token to wait, gateway will fire");
        return false;
    }

    List<SFlowNodeDefinition> extractElementThatAreSourceAndTarget(List<SFlowNodeDefinition> sourceElements, List<SFlowNodeDefinition> targetElements) {
        ArrayList<SFlowNodeDefinition> sourceAndTarget = new ArrayList<SFlowNodeDefinition>();
        Iterator<SFlowNodeDefinition> iterator = sourceElements.iterator();
        while (iterator.hasNext()) {
            SFlowNodeDefinition sourceElement = iterator.next();
            if (!targetElements.contains(sourceElement) && !sourceElement.getIncomingTransitions().isEmpty()) continue;
            iterator.remove();
            targetElements.remove(sourceElement);
            sourceAndTarget.add(sourceElement);
        }
        return sourceAndTarget;
    }

    boolean containsToken(long processInstanceId, List<SFlowNodeDefinition> elements, Boolean shouldBeTerminal) throws SBonitaReadException {
        for (SFlowNodeDefinition element : elements) {
            List<SFlowNodeInstance> sFlowNodeInstances = this.getFlowNodes(processInstanceId, element);
            for (SFlowNodeInstance sFlowNodeInstance : sFlowNodeInstances) {
                if (shouldBeTerminal != null && !(shouldBeTerminal ^ !sFlowNodeInstance.isTerminal())) continue;
                this.logger.log(TAG, TechnicalLogSeverity.DEBUG, "flow node " + sFlowNodeInstance.getName() + " contain a token, gateway not merged");
                return true;
            }
        }
        return false;
    }

    private List<SFlowNodeInstance> getFlowNodes(long processInstanceId, SFlowNodeDefinition sourceElement) throws SBonitaReadException {
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>();
        filters.add(new FilterOption(SFlowNodeInstance.class, "name", sourceElement.getName()));
        filters.add(new FilterOption(SFlowNodeInstance.class, "parentContainerId", processInstanceId));
        QueryOptions searchOptions = new QueryOptions(0, 20, Collections.<OrderByOption>emptyList(), filters, null);
        return this.flowNodeInstanceService.searchFlowNodeInstances(SFlowNodeInstance.class, searchOptions);
    }

    void addBackwardReachableTransitions(SFlowElementContainerDefinition processContainer, SFlowNodeDefinition gatewayDefinition, List<STransitionDefinition> transitions, List<STransitionDefinition> backwardReachable, List<STransitionDefinition> notIn) {
        for (STransitionDefinition sTransitionDefinition : transitions) {
            if (backwardReachable.contains(sTransitionDefinition) || notIn.contains(sTransitionDefinition)) continue;
            backwardReachable.add(sTransitionDefinition);
            SFlowNodeDefinition flowNode = processContainer.getFlowNode(sTransitionDefinition.getSource());
            if (flowNode.equals(gatewayDefinition)) continue;
            this.addBackwardReachableTransitions(processContainer, gatewayDefinition, flowNode.getIncomingTransitions(), backwardReachable, notIn);
        }
    }

    boolean isParallelGatewayActivated(SProcessDefinition sDefinition, SGatewayInstance gatewayInstance) {
        List<String> hitsBy = this.getHitByTransitionList(gatewayInstance);
        List<STransitionDefinition> trans = this.getTransitionDefinitions(gatewayInstance, sDefinition);
        boolean go = true;
        for (int i = 1; go && i <= trans.size(); ++i) {
            go = hitsBy.contains(String.valueOf(i));
        }
        return go;
    }

    private List<String> getHitByTransitionList(SGatewayInstance gatewayInstance) {
        return Arrays.asList(gatewayInstance.getHitBys().split(","));
    }

    protected List<STransitionDefinition> getTransitionDefinitions(SGatewayInstance gatewayInstance, SProcessDefinition processDefinition) {
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        SFlowNodeDefinition gatewayDefinition = processContainer.getFlowNode(gatewayInstance.getFlowNodeDefinitionId());
        return gatewayDefinition.getIncomingTransitions();
    }

    @Override
    public void setState(SGatewayInstance gatewayInstance, int stateId) throws SGatewayModificationException {
        this.updateOneColum(gatewayInstance, this.sGatewayInstanceBuilderFactory.getStateIdKey(), Integer.valueOf(stateId), "GATEWAYINSTANCE_STATE");
    }

    @Override
    public void hitTransition(SGatewayInstance gatewayInstance, long transitionIndex) throws SGatewayModificationException {
        this.logger.log(TAG, TechnicalLogSeverity.DEBUG, "Hit gateway " + gatewayInstance.getName() + " of instance " + gatewayInstance.getRootProcessInstanceId() + " with transition index " + transitionIndex);
        String hitBys = gatewayInstance.getHitBys();
        String columnValue = hitBys == null || hitBys.isEmpty() ? String.valueOf(transitionIndex) : hitBys + "," + transitionIndex;
        this.updateOneColum(gatewayInstance, this.sGatewayInstanceBuilderFactory.getHitBysKey(), (Serializable)((Object)columnValue), "GATEWAYINSTANCE_HITBYS");
    }

    private void updateOneColum(SGatewayInstance gatewayInstance, String columnName, Serializable columnValue, String event) throws SGatewayModificationException {
        EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
        entityUpdateDescriptor.addField(columnName, columnValue);
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)gatewayInstance, entityUpdateDescriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers(event, EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(event).setObject(gatewayInstance).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SGatewayModificationException(e);
        }
    }

    @Override
    public SGatewayInstance getActiveGatewayInstanceOfTheProcess(long parentProcessInstanceId, String name) throws SGatewayNotFoundException, SGatewayReadException {
        SGatewayInstance selectOne;
        try {
            selectOne = this.persistenceRead.selectOne(SelectDescriptorBuilder.getActiveGatewayInstanceOfProcess(parentProcessInstanceId, name));
        }
        catch (SBonitaReadException e) {
            throw new SGatewayReadException(e);
        }
        if (selectOne == null) {
            throw new SGatewayNotFoundException(parentProcessInstanceId, name);
        }
        return selectOne;
    }

    @Override
    public List<SGatewayInstance> setFinishAndCreateNewGatewayForRemainingToken(SProcessDefinition processDefinition, SGatewayInstance gatewayInstance) throws SBonitaException {
        List<String> hitBys = this.getHitByTransitionList(gatewayInstance);
        List<String> merged = this.getMergedTokens(gatewayInstance, hitBys);
        this.setFinished(gatewayInstance, merged.size());
        ArrayList<String> remaining = this.getRemainingTokens(hitBys, merged);
        this.logger.log(TAG, TechnicalLogSeverity.DEBUG, "There is " + remaining + " remaining token to merge on gateway " + gatewayInstance.getName() + " will create a new if there is");
        if (remaining.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SGatewayInstance> toFire = new ArrayList<SGatewayInstance>();
        SGatewayInstance newGatewayInstance = this.createGatewayWithRemainingTokens(gatewayInstance, remaining);
        if (this.checkMergingCondition(processDefinition, newGatewayInstance)) {
            toFire.add(newGatewayInstance);
            toFire.addAll(this.setFinishAndCreateNewGatewayForRemainingToken(processDefinition, newGatewayInstance));
        }
        return toFire;
    }

    List<String> getMergedTokens(SGatewayInstance gatewayInstance, List<String> hitBys) {
        List<String> merged = null;
        switch (gatewayInstance.getGatewayType()) {
            case PARALLEL: {
                merged = this.unique(hitBys);
                break;
            }
            case INCLUSIVE: {
                merged = this.unique(hitBys);
                break;
            }
            case EXCLUSIVE: {
                merged = Collections.singletonList(hitBys.get(0));
            }
        }
        return merged;
    }

    private ArrayList<String> unique(List<String> hitBys) {
        ArrayList<String> merged = new ArrayList<String>();
        for (String hitBy : hitBys) {
            if (merged.contains(hitBy)) continue;
            merged.add(hitBy);
        }
        return merged;
    }

    ArrayList<String> getRemainingTokens(List<String> hitBys, List<String> merged) {
        ArrayList<String> remaining = new ArrayList<String>(hitBys);
        for (String mergedToken : merged) {
            remaining.remove(mergedToken);
        }
        return remaining;
    }

    private SGatewayInstance createGatewayWithRemainingTokens(SGatewayInstance gatewayInstance, List<String> remaining) throws SGatewayCreationException {
        SGatewayInstanceImpl sGatewayInstance = new SGatewayInstanceImpl(gatewayInstance);
        String remainingTokenAsString = "";
        for (String token : remaining) {
            remainingTokenAsString = remainingTokenAsString + token + ",";
        }
        sGatewayInstance.setHitBys(remainingTokenAsString.substring(0, remainingTokenAsString.length() - 1));
        this.createGatewayInstance(sGatewayInstance);
        return sGatewayInstance;
    }

    void setFinished(SGatewayInstance gatewayInstance, int numberOfTokenToMerge) throws SGatewayModificationException {
        String columnValue = "FINISH:" + numberOfTokenToMerge;
        this.logger.log(TAG, TechnicalLogSeverity.TRACE, "set finish on gateway " + gatewayInstance.getName() + " " + columnValue);
        this.updateOneColum(gatewayInstance, this.sGatewayInstanceBuilderFactory.getHitBysKey(), (Serializable)((Object)columnValue), "GATEWAYINSTANCE_HITBYS");
    }

    @Override
    public List<SGatewayInstance> getInclusiveGatewaysOfProcessInstanceThatShouldFire(SProcessDefinition processDefinition, long processInstanceId) throws SBonitaReadException {
        List<SGatewayInstance> sGatewayInstances = this.getInclusiveGatewayInstanceOfProcessInstance(processInstanceId);
        ArrayList<SGatewayInstance> shouldFire = new ArrayList<SGatewayInstance>();
        for (SGatewayInstance sGatewayInstance : sGatewayInstances) {
            if (!this.isInclusiveGatewayActivated(processDefinition, sGatewayInstance)) continue;
            shouldFire.add(sGatewayInstance);
        }
        return shouldFire;
    }

    private List<SGatewayInstance> getInclusiveGatewayInstanceOfProcessInstance(long processInstanceId) throws SBonitaReadException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        hashMap.put("processInstanceId", processInstanceId);
        SelectListDescriptor getGatewayMergingToken = new SelectListDescriptor("getInclusiveGatewayInstanceOfProcessInstance", hashMap, SGatewayInstance.class, new QueryOptions(0, Integer.MAX_VALUE));
        return this.persistenceRead.selectList(getGatewayMergingToken);
    }
}

