/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceDeletionException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceReadException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.model.archive.builder.SACommentBuilderFactory;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.ProcessInstanceService;
import org.bonitasoft.engine.core.process.instance.api.TransitionService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SAProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceHierarchicalDeletionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceReadException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.core.process.instance.recorder.SelectDescriptorBuilder;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;

public class ProcessInstanceServiceImpl
implements ProcessInstanceService {
    private static final String MANAGER_USER_ID = "managerUserId";
    private static final String USER_ID = "userId";
    private static final String SUPERVISED_BY = "SupervisedBy";
    private static final String INVOLVING_USER = "InvolvingUser";
    private static final String FAILED = "Failed";
    private static final String MANAGED_BY = "ManagedBy";
    private static final int BATCH_SIZE = 100;
    private final Recorder recorder;
    private final ReadPersistenceService persistenceRead;
    private final EventService eventService;
    private final ActivityInstanceService activityService;
    private final SProcessInstanceBuilderFactory processInstanceKeyProvider;
    private final EventInstanceService bpmEventInstanceService;
    private final DataInstanceService dataInstanceService;
    private final ArchiveService archiveService;
    private final TechnicalLoggerService logger;
    private final TransitionService transitionService;
    private final ProcessDefinitionService processDefinitionService;
    private final ConnectorInstanceService connectorInstanceService;
    private final ClassLoaderService classLoaderService;
    private final DocumentService documentService;
    private final SCommentService commentService;

    public ProcessInstanceServiceImpl(Recorder recorder, ReadPersistenceService persistenceRead, EventService eventService, ActivityInstanceService activityService, TechnicalLoggerService logger, EventInstanceService bpmEventInstanceService, DataInstanceService dataInstanceService, ArchiveService archiveService, TransitionService transitionService, ProcessDefinitionService processDefinitionService, ConnectorInstanceService connectorInstanceService, ClassLoaderService classLoaderService, DocumentService documentService, SCommentService commentService) {
        this.recorder = recorder;
        this.persistenceRead = persistenceRead;
        this.eventService = eventService;
        this.activityService = activityService;
        this.transitionService = transitionService;
        this.processDefinitionService = processDefinitionService;
        this.connectorInstanceService = connectorInstanceService;
        this.classLoaderService = classLoaderService;
        this.documentService = documentService;
        this.commentService = commentService;
        this.processInstanceKeyProvider = BuilderFactory.get(SProcessInstanceBuilderFactory.class);
        this.bpmEventInstanceService = bpmEventInstanceService;
        this.dataInstanceService = dataInstanceService;
        this.archiveService = archiveService;
        this.logger = logger;
    }

    @Override
    public void createProcessInstance(SProcessInstance processInstance) throws SProcessInstanceCreationException {
        InsertRecord insertRecord = new InsertRecord(processInstance);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("PROCESSINSTANCE", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("PROCESSINSTANCE").setObject(processInstance).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.setProcessState(processInstance, ProcessInstanceState.INITIALIZING);
        }
        catch (SRecorderException sre) {
            throw new SProcessInstanceCreationException(sre);
        }
        catch (SProcessInstanceModificationException spicme) {
            throw new SProcessInstanceCreationException(spicme);
        }
    }

    @Override
    public SProcessInstance getProcessInstance(long processInstanceId) throws SProcessInstanceReadException, SProcessInstanceNotFoundException {
        SProcessInstance instance;
        try {
            instance = this.persistenceRead.selectById(SelectDescriptorBuilder.getElementById(SProcessInstance.class, "ProcessInstance", processInstanceId));
        }
        catch (SBonitaReadException sbre) {
            throw new SProcessInstanceReadException(sbre);
        }
        if (instance == null) {
            throw new SProcessInstanceNotFoundException(processInstanceId);
        }
        return instance;
    }

    @Override
    public void deleteProcessInstance(long processInstanceId) throws SProcessInstanceModificationException, SProcessInstanceReadException, SProcessInstanceNotFoundException {
        SProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        this.deleteProcessInstance(processInstance);
    }

    @Override
    public long deleteParentProcessInstanceAndElements(List<SProcessInstance> sProcessInstances) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException {
        long nbDeleted = 0L;
        for (SProcessInstance sProcessInstance : sProcessInstances) {
            this.deleteParentProcessInstanceAndElements(sProcessInstance);
            ++nbDeleted;
        }
        return nbDeleted;
    }

    @Override
    public void deleteParentProcessInstanceAndElements(long processInstanceId) throws SProcessInstanceReadException, SProcessInstanceNotFoundException, SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException {
        SProcessInstance sProcessInstance = this.getProcessInstance(processInstanceId);
        this.deleteParentProcessInstanceAndElements(sProcessInstance);
    }

    @Override
    public void deleteParentProcessInstanceAndElements(SProcessInstance sProcessInstance) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException {
        this.checkIfCallerIsNotActive(sProcessInstance.getCallerId());
        try {
            this.deleteProcessInstance(sProcessInstance);
            this.deleteArchivedProcessInstanceElements(sProcessInstance.getId(), sProcessInstance.getProcessDefinitionId());
        }
        catch (SProcessInstanceModificationException e) {
            this.getProcessInstanceAndLogException(sProcessInstance, e);
        }
    }

    private void getProcessInstanceAndLogException(SProcessInstance sProcessInstance, SProcessInstanceModificationException e) throws SProcessInstanceModificationException {
        try {
            this.getProcessInstance(sProcessInstance.getId());
            throw e;
        }
        catch (SProcessInstanceReadException e1) {
            this.logProcessInstanceNotFound(e);
        }
        catch (SProcessInstanceNotFoundException e1) {
            this.logProcessInstanceNotFound(e);
        }
    }

    protected void logProcessInstanceNotFound(SProcessInstanceModificationException e) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e.getMessage() + ". It has probably completed.");
        }
    }

    protected void logArchivedProcessInstanceNotFound(SBonitaException e) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, e.getMessage());
        }
    }

    @Override
    public long deleteArchivedParentProcessInstancesAndElements(List<SAProcessInstance> saProcessInstances) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException {
        long nbDeleted = 0L;
        for (SAProcessInstance saProcessInstance : saProcessInstances) {
            this.deleteArchivedParentProcessInstanceAndElements(saProcessInstance);
            ++nbDeleted;
        }
        return nbDeleted;
    }

    @Override
    public void deleteArchivedParentProcessInstanceAndElements(SAProcessInstance saProcessInstance) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException, SProcessInstanceModificationException {
        this.checkIfCallerIsNotActive(saProcessInstance.getCallerId());
        try {
            this.deleteArchivedProcessInstanceElements(saProcessInstance.getSourceObjectId(), saProcessInstance.getProcessDefinitionId());
            this.deleteArchivedProcessInstance(saProcessInstance);
        }
        catch (SProcessInstanceModificationException e) {
            this.getArchivedProcessInstanceAndLogWhenNotFound(saProcessInstance, e);
        }
    }

    private void getArchivedProcessInstanceAndLogWhenNotFound(SAProcessInstance saProcessInstance, SProcessInstanceModificationException e) throws SProcessInstanceModificationException {
        try {
            SAProcessInstance saProcessInstance2 = this.getArchivedProcessInstance(saProcessInstance.getId());
            if (saProcessInstance2 != null) {
                throw e;
            }
            this.logArchivedProcessInstanceNotFound(new SAProcessInstanceNotFoundException(saProcessInstance.getId()));
        }
        catch (SProcessInstanceModificationException e1) {
            throw e;
        }
        catch (SProcessInstanceReadException e1) {
            this.logArchivedProcessInstanceNotFound(e);
        }
    }

    @Override
    public void deleteArchivedProcessInstance(SAProcessInstance archivedProcessInstance) throws SProcessInstanceModificationException {
        DeleteRecord deleteRecord = new DeleteRecord(archivedProcessInstance);
        SDeleteEvent deleteEvent = this.buildDeleteEvent(archivedProcessInstance);
        try {
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SRecorderException e) {
            throw new SProcessInstanceModificationException(e);
        }
    }

    private SDeleteEvent buildDeleteEvent(SAProcessInstance archivedProcessInstance) {
        if (this.eventService.hasHandlers("PROCESSINSTANCE", EventActionType.DELETED)) {
            return (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("PROCESSINSTANCE").setObject(archivedProcessInstance).done();
        }
        return null;
    }

    @Override
    public void deleteArchivedProcessInstanceElements(long processInstanceId, long processDefinitionId) throws SProcessInstanceModificationException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader localClassLoader = this.classLoaderService.getLocalClassLoader("PROCESS", processDefinitionId);
            Thread.currentThread().setContextClassLoader(localClassLoader);
            this.activityService.deleteArchivedFlowNodeInstances(processInstanceId);
            this.dataInstanceService.deleteLocalArchivedDataInstances(processInstanceId, DataInstanceContainer.PROCESS_INSTANCE.toString());
            this.documentService.deleteArchivedDocuments(processInstanceId);
            this.connectorInstanceService.deleteArchivedConnectorInstances(processInstanceId, "process");
            this.transitionService.deleteArchivedTransitionsOfProcessInstance(processInstanceId);
            this.commentService.deleteArchivedComments(processInstanceId);
            this.deleteArchivedChidrenProcessInstanceAndElements(processInstanceId, processDefinitionId);
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceModificationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private void deleteArchivedChidrenProcessInstanceAndElements(long processInstanceId, long processDefinitionId) throws SBonitaException {
        List<Long> childrenProcessInstanceIds = null;
        do {
            childrenProcessInstanceIds = this.getArchivedChildrenSourceObjectIdsFromRootProcessInstance(processInstanceId, 0, 100, OrderByType.ASC);
            this.deleteArchivedChildrenProcessInstancesAndElements(processDefinitionId, childrenProcessInstanceIds);
        } while (!childrenProcessInstanceIds.isEmpty());
    }

    private void deleteArchivedChildrenProcessInstancesAndElements(long processDefinitionId, List<Long> childrenProcessInstanceIds) throws SProcessInstanceModificationException, SBonitaException {
        for (Long childProcessInstanceId : childrenProcessInstanceIds) {
            this.deleteArchivedProcessInstanceElements(childProcessInstanceId, processDefinitionId);
            this.deleteArchivedProcessInstancesOfProcessInstance(childProcessInstanceId);
        }
    }

    @Override
    public List<Long> getSourceProcesInstanceIdsOfArchProcessInstancesFromDefinition(long processDefinitionId, int fromIndex, int maxResults, OrderByType sortingOrder) throws SProcessInstanceReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        String saCommentSourceObjectId = BuilderFactory.get(SACommentBuilderFactory.class).getSourceObjectId();
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults, SAProcessInstance.class, saCommentSourceObjectId, sortingOrder);
        try {
            return persistenceService.selectList(SelectDescriptorBuilder.getSourceProcesInstanceIdsOfArchProcessInstancesFromDefinition(processDefinitionId, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new SProcessInstanceReadException(e);
        }
    }

    @Override
    public void deleteProcessInstance(SProcessInstance sProcessInstance) throws SProcessInstanceModificationException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            long processDefinitionId = sProcessInstance.getProcessDefinitionId();
            ClassLoader localClassLoader = this.classLoaderService.getLocalClassLoader("PROCESS", processDefinitionId);
            Thread.currentThread().setContextClassLoader(localClassLoader);
            this.deleteProcessInstanceElements(sProcessInstance);
            DeleteRecord deleteRecord = new DeleteRecord(sProcessInstance);
            SDeleteEvent deleteEvent = this.buildDeleteEvent(sProcessInstance);
            this.recorder.recordDelete(deleteRecord, deleteEvent);
        }
        catch (SBonitaException e) {
            throw new SProcessInstanceModificationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private SDeleteEvent buildDeleteEvent(SProcessInstance sProcessInstance) {
        if (this.eventService.hasHandlers("PROCESSINSTANCE", EventActionType.DELETED)) {
            return (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("PROCESSINSTANCE").setObject(sProcessInstance).done();
        }
        return null;
    }

    protected void checkIfCallerIsNotActive(long callerId) throws SFlowNodeReadException, SProcessInstanceHierarchicalDeletionException {
        try {
            if (callerId > 0L) {
                SFlowNodeInstance flowNodeInstance = this.activityService.getFlowNodeInstance(callerId);
                SProcessInstanceHierarchicalDeletionException exception = new SProcessInstanceHierarchicalDeletionException("Unable to delete the process instance, because the parent (call activity) is still active.", flowNodeInstance.getRootProcessInstanceId());
                this.setExceptionContext(flowNodeInstance, exception);
                throw exception;
            }
        }
        catch (SFlowNodeNotFoundException sFlowNodeNotFoundException) {
            // empty catch block
        }
    }

    protected void deleteProcessInstanceElements(SProcessInstance processInstance) throws SBonitaException {
        SProcessDefinition processDefinition = null;
        try {
            processDefinition = this.processDefinitionService.getProcessDefinition(processInstance.getProcessDefinitionId());
        }
        catch (SProcessDefinitionNotFoundException sProcessDefinitionNotFoundException) {
            // empty catch block
        }
        this.deleteFlowNodeInstances(processInstance.getId(), processDefinition);
        this.deleteDataInstancesIfNecessary(processInstance, processDefinition);
        this.documentService.deleteDocumentsFromProcessInstance(processInstance.getId());
        this.deleteConnectorInstancesIfNecessary(processInstance, processDefinition);
        this.commentService.deleteComments(processInstance.getId());
    }

    private void deleteConnectorInstancesIfNecessary(SProcessInstance processInstance, SProcessDefinition processDefinition) throws SConnectorInstanceReadException, SConnectorInstanceDeletionException {
        if (processDefinition != null && processDefinition.hasConnectors()) {
            this.connectorInstanceService.deleteConnectors(processInstance.getId(), "process");
        }
    }

    protected void deleteConnectorInstancesIfNecessary(SFlowNodeInstance flowNodeInstance, SProcessDefinition processDefinition) throws SConnectorInstanceReadException, SConnectorInstanceDeletionException {
        if (this.hasConnectors(flowNodeInstance, processDefinition)) {
            this.connectorInstanceService.deleteConnectors(flowNodeInstance.getId(), "flowNode");
        }
    }

    private boolean hasConnectors(SFlowNodeInstance flowNodeInstance, SProcessDefinition processDefinition) {
        SActivityDefinition activityDefinition;
        if (processDefinition != null && (activityDefinition = (SActivityDefinition)this.getFlowNode(flowNodeInstance, processDefinition)) != null) {
            return activityDefinition.hasConnectors();
        }
        return false;
    }

    private void deleteDataInstancesIfNecessary(SProcessInstance processInstance, SProcessDefinition processDefinition) throws SDataInstanceException {
        boolean dataPresent = true;
        if (processDefinition != null) {
            dataPresent = processDefinition.getProcessContainer().getDataDefinitions().size() > 0;
        }
        this.dataInstanceService.deleteLocalDataInstances(processInstance.getId(), DataInstanceContainer.PROCESS_INSTANCE.toString(), dataPresent);
    }

    private void deleteFlowNodeInstances(long processInstanceId, SProcessDefinition processDefinition) throws SFlowNodeReadException, SProcessInstanceModificationException {
        List<SFlowNodeInstance> activityInstances;
        do {
            activityInstances = this.activityService.getFlowNodeInstances(processInstanceId, 0, 100);
            for (SFlowNodeInstance activityInstance : activityInstances) {
                this.deleteFlowNodeInstance(activityInstance, processDefinition);
            }
        } while (activityInstances.size() == 100);
    }

    @Override
    public void deleteArchivedProcessInstancesOfProcessInstance(long processInstanceId) throws SBonitaException {
        SAProcessInstanceBuilderFactory processInstanceBuilderFact = BuilderFactory.get(SAProcessInstanceBuilderFactory.class);
        FilterOption filterOption = new FilterOption(SAProcessInstance.class, processInstanceBuilderFact.getSourceObjectIdKey(), processInstanceId);
        OrderByOption orderBy = new OrderByOption(SAProcessInstance.class, processInstanceBuilderFact.getIdKey(), OrderByType.ASC);
        QueryOptions queryOptions = new QueryOptions(0, 100, Collections.singletonList(orderBy), Collections.singletonList(filterOption), null);
        List<SAProcessInstance> archProcInstances = null;
        do {
            archProcInstances = this.searchArchivedProcessInstances(queryOptions);
            this.deleteArchivedProcessInstances(archProcInstances);
        } while (!archProcInstances.isEmpty());
    }

    private void deleteArchivedProcessInstances(List<SAProcessInstance> archProcInstances) throws SProcessInstanceModificationException {
        for (SAProcessInstance archProcInstance : archProcInstances) {
            this.deleteArchivedProcessInstance(archProcInstance);
        }
    }

    @Override
    public void deleteFlowNodeInstance(SFlowNodeInstance flowNodeInstance, SProcessDefinition processDefinition) throws SProcessInstanceModificationException {
        try {
            this.deleteFlowNodeInstanceElements(flowNodeInstance, processDefinition);
            this.activityService.deleteFlowNodeInstance(flowNodeInstance);
        }
        catch (SBonitaException e) {
            this.setExceptionContext(processDefinition, flowNodeInstance, e);
            throw new SProcessInstanceModificationException(e);
        }
    }

    void deleteFlowNodeInstanceElements(SFlowNodeInstance flowNodeInstance, SProcessDefinition processDefinition) throws SBonitaException {
        SFlowNodeType type = flowNodeInstance.getType();
        if (type.equals((Object)SFlowNodeType.INTERMEDIATE_CATCH_EVENT) || type.equals((Object)SFlowNodeType.BOUNDARY_EVENT) || type.equals((Object)SFlowNodeType.RECEIVE_TASK) || type.equals((Object)SFlowNodeType.START_EVENT)) {
            this.bpmEventInstanceService.deleteWaitingEvents(flowNodeInstance);
        }
        if (flowNodeInstance instanceof SEventInstance) {
            this.bpmEventInstanceService.deleteEventTriggerInstances(flowNodeInstance.getId());
        } else if (flowNodeInstance instanceof SActivityInstance) {
            this.deleteActivityInstanceElements((SActivityInstance)flowNodeInstance, processDefinition);
        }
    }

    private void deleteActivityInstanceElements(SActivityInstance sActivityInstance, SProcessDefinition processDefinition) throws SBonitaException {
        this.deleteDataInstancesIfNecessary(sActivityInstance, processDefinition);
        this.deleteConnectorInstancesIfNecessary(sActivityInstance, processDefinition);
        if (SFlowNodeType.USER_TASK.equals((Object)sActivityInstance.getType()) || SFlowNodeType.MANUAL_TASK.equals((Object)sActivityInstance.getType())) {
            this.activityService.deletePendingMappings(sActivityInstance.getId());
        } else if (SFlowNodeType.CALL_ACTIVITY.equals((Object)sActivityInstance.getType()) || SFlowNodeType.SUB_PROCESS.equals((Object)sActivityInstance.getType())) {
            this.deleteSubProcess(sActivityInstance, processDefinition);
        }
    }

    void deleteSubProcess(SFlowNodeInstance flowNodeInstance, SProcessDefinition processDefinition) throws SBonitaException {
        block2: {
            try {
                this.deleteProcessInstance(this.getChildOfActivity(flowNodeInstance.getId()));
            }
            catch (SProcessInstanceNotFoundException e) {
                this.setExceptionContext(processDefinition, flowNodeInstance, e);
                if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) break block2;
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "Can't find the process instance called by the activity. This process may be already finished.");
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, e);
            }
        }
    }

    private void setExceptionContext(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, SBonitaException e) {
        if (processDefinition != null) {
            e.setProcessDefinitionIdOnContext(processDefinition.getId());
            e.setProcessDefinitionNameOnContext(processDefinition.getName());
            e.setProcessDefinitionVersionOnContext(processDefinition.getVersion());
        }
        this.setExceptionContext(flowNodeInstance, e);
    }

    private void setExceptionContext(SFlowNodeInstance flowNodeInstance, SBonitaException e) {
        e.setProcessInstanceIdOnContext(flowNodeInstance.getParentProcessInstanceId());
        e.setRootProcessInstanceIdOnContext(flowNodeInstance.getRootProcessInstanceId());
        e.setFlowNodeDefinitionIdOnContext(flowNodeInstance.getFlowNodeDefinitionId());
        e.setFlowNodeInstanceIdOnContext(flowNodeInstance.getId());
        e.setFlowNodeNameOnContext(flowNodeInstance.getName());
    }

    void deleteDataInstancesIfNecessary(SFlowNodeInstance flowNodeInstance, SProcessDefinition processDefinition) throws SDataInstanceException {
        SActivityDefinition activityDefinition;
        boolean hasData = true;
        if (processDefinition != null && (activityDefinition = (SActivityDefinition)this.getFlowNode(flowNodeInstance, processDefinition)) != null) {
            hasData = activityDefinition.getSDataDefinitions().size() > 0;
        }
        this.dataInstanceService.deleteLocalDataInstances(flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.toString(), hasData);
    }

    private SFlowNodeDefinition getFlowNode(SFlowNodeInstance flowNodeInstance, SProcessDefinition processDefinition) {
        return processDefinition.getProcessContainer().getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
    }

    @Override
    public void setState(SProcessInstance processInstance, ProcessInstanceState state) throws SProcessInstanceModificationException {
        this.archiveProcessInstance(processInstance);
        int previousStateId = processInstance.getStateId();
        this.setProcessState(processInstance, state);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, MessageFormat.format("[{0} with id {1}]{2}->{3}(new={4})", processInstance.getClass().getSimpleName(), processInstance.getId(), previousStateId, state.getId(), state.name()));
        }
    }

    @Override
    public void setMigrationPlanId(SProcessInstance processInstance, long migrationPlanId) throws SProcessInstanceModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.processInstanceKeyProvider.getMigrationPlanIdKey(), migrationPlanId);
        long now = System.currentTimeMillis();
        descriptor.addField(this.processInstanceKeyProvider.getLastUpdateKey(), now);
        this.updateProcessInstance(processInstance, descriptor, "MIGRATION_PLAN");
    }

    private void setProcessState(SProcessInstance processInstance, ProcessInstanceState state) throws SProcessInstanceModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.processInstanceKeyProvider.getStateIdKey(), state.getId());
        long now = System.currentTimeMillis();
        switch (state) {
            case COMPLETED: {
                descriptor.addField(this.processInstanceKeyProvider.getEndDateKey(), now);
                break;
            }
            case ABORTED: {
                descriptor.addField(this.processInstanceKeyProvider.getEndDateKey(), now);
                break;
            }
            case CANCELLED: {
                descriptor.addField(this.processInstanceKeyProvider.getEndDateKey(), now);
                break;
            }
            case STARTED: {
                descriptor.addField(this.processInstanceKeyProvider.getStartDateKey(), now);
                break;
            }
        }
        descriptor.addField(this.processInstanceKeyProvider.getLastUpdateKey(), now);
        this.updateProcessInstance(processInstance, descriptor, "PROCESSINSTANCE_STATE");
    }

    private void updateProcessInstance(SProcessInstance processInstance, EntityUpdateDescriptor descriptor, String eventType) throws SProcessInstanceModificationException {
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)processInstance, descriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers(eventType, EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent(eventType).setObject(processInstance).done();
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SProcessInstanceModificationException(e);
        }
    }

    private void archiveProcessInstance(SProcessInstance processInstance) throws SProcessInstanceModificationException {
        SAProcessInstance saProcessInstance = BuilderFactory.get(SAProcessInstanceBuilderFactory.class).createNewInstance(processInstance).done();
        ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saProcessInstance);
        try {
            this.archiveService.recordInsert(System.currentTimeMillis(), insertRecord);
        }
        catch (SRecorderException e) {
            throw new SProcessInstanceModificationException(e);
        }
    }

    @Override
    public void setStateCategory(SProcessInstance processInstance, SStateCategory stateCatetory) throws SProcessInstanceModificationException {
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(this.processInstanceKeyProvider.getStateCategoryKey(), (Object)stateCatetory);
        this.updateProcessInstance(processInstance, descriptor, "PROCESS_INSTANCE_CATEGORY_STATE");
    }

    @Override
    public List<Long> getChildInstanceIdsOfProcessInstance(long processInstanceId, int fromIndex, int maxResults, String sortingField, OrderByType sortingOrder) throws SProcessInstanceReadException {
        try {
            QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults, SProcessInstance.class, sortingField, sortingOrder);
            SelectListDescriptor<Long> elements = SelectDescriptorBuilder.getChildInstanceIdsOfProcessInstance(SProcessInstance.class, processInstanceId, queryOptions);
            return this.persistenceRead.selectList(elements);
        }
        catch (SBonitaReadException e) {
            throw new SProcessInstanceReadException(e);
        }
    }

    @Override
    public SProcessInstance getChildOfActivity(long activityInstId) throws SProcessInstanceNotFoundException, SBonitaReadException {
        try {
            SProcessInstanceBuilderFactory processInstanceBuilderFact = BuilderFactory.get(SProcessInstanceBuilderFactory.class);
            FilterOption filterOption = new FilterOption(SProcessInstance.class, processInstanceBuilderFact.getCallerIdKey(), activityInstId);
            QueryOptions queryOptions = new QueryOptions(0, Integer.MAX_VALUE, null, Collections.singletonList(filterOption), null);
            return this.searchProcessInstances(queryOptions).get(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new SProcessInstanceNotFoundException("No process instance was found as child of the activity with id = <" + activityInstId + ">");
        }
    }

    @Override
    public long getNumberOfChildInstancesOfProcessInstance(long processInstanceId) throws SProcessInstanceReadException {
        try {
            return this.persistenceRead.selectOne(SelectDescriptorBuilder.getNumberOfChildInstancesOfProcessInstance(processInstanceId));
        }
        catch (SBonitaReadException e) {
            throw new SProcessInstanceReadException(e);
        }
    }

    @Override
    public long getNumberOfProcessInstances(QueryOptions queryOptions) throws SBonitaReadException {
        return this.persistenceRead.getNumberOfEntities(SProcessInstance.class, queryOptions, Collections.<String, Object>emptyMap());
    }

    @Override
    public List<SProcessInstance> searchProcessInstances(QueryOptions queryOptions) throws SBonitaReadException {
        return this.persistenceRead.searchEntity(SProcessInstance.class, queryOptions, Collections.<String, Object>emptyMap());
    }

    @Override
    public long getNumberOfOpenProcessInstancesSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap(USER_ID, userId);
            return this.persistenceRead.getNumberOfEntities(SProcessInstance.class, SUPERVISED_BY, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaReadException(e);
        }
    }

    @Override
    public List<SProcessInstance> searchOpenProcessInstancesSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            Map<String, Object> parameters = Collections.singletonMap(USER_ID, userId);
            return this.persistenceRead.searchEntity(SProcessInstance.class, SUPERVISED_BY, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaReadException(e);
        }
    }

    @Override
    public long getNumberOfOpenProcessInstancesInvolvingUser(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            parameters.put(USER_ID, userId);
            return this.persistenceRead.getNumberOfEntities(SProcessInstance.class, INVOLVING_USER, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaReadException(e);
        }
    }

    @Override
    public List<SProcessInstance> searchOpenProcessInstancesInvolvingUser(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put(USER_ID, userId);
        return this.persistenceRead.searchEntity(SProcessInstance.class, INVOLVING_USER, queryOptions, parameters);
    }

    @Override
    public long getNumberOfOpenProcessInstancesInvolvingUsersManagedBy(long managerUserId, QueryOptions queryOptions) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put(MANAGER_USER_ID, managerUserId);
        return this.persistenceRead.getNumberOfEntities(SProcessInstance.class, "InvolvingUsersManagedBy", queryOptions, parameters);
    }

    @Override
    public List<SProcessInstance> searchOpenProcessInstancesInvolvingUsersManagedBy(long managerUserId, QueryOptions queryOptions) throws SBonitaReadException {
        HashMap<String, Object> parameters = new HashMap<String, Object>(1);
        parameters.put(MANAGER_USER_ID, managerUserId);
        return this.persistenceRead.searchEntity(SProcessInstance.class, "InvolvingUsersManagedBy", queryOptions, parameters);
    }

    @Override
    public long getNumberOfArchivedProcessInstancesWithoutSubProcess(QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        return persistenceService.getNumberOfEntities(SAProcessInstance.class, "WithoutSubProcess", queryOptions, null);
    }

    @Override
    public List<SAProcessInstance> searchArchivedProcessInstancesWithoutSubProcess(QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        return persistenceService.searchEntity(SAProcessInstance.class, "WithoutSubProcess", queryOptions, null);
    }

    @Override
    public List<SAProcessInstance> searchArchivedProcessInstancesSupervisedBy(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        Map<String, Object> parameters = Collections.singletonMap(USER_ID, userId);
        return persistenceService.searchEntity(SAProcessInstance.class, SUPERVISED_BY, queryOptions, parameters);
    }

    @Override
    public long getNumberOfArchivedProcessInstancesSupervisedBy(long userId, QueryOptions countOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        Map<String, Object> parameters = Collections.singletonMap(USER_ID, userId);
        return persistenceService.getNumberOfEntities(SAProcessInstance.class, SUPERVISED_BY, countOptions, parameters);
    }

    @Override
    public long getNumberOfArchivedProcessInstancesInvolvingUser(long userId, QueryOptions countOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(2);
            parameters.put(USER_ID, userId);
            return persistenceService.getNumberOfEntities(SAProcessInstance.class, INVOLVING_USER, countOptions, parameters);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaReadException(bre);
        }
    }

    @Override
    public long getNumberOfArchivedProcessInstances(QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        return persistenceService.getNumberOfEntities(SAProcessInstance.class, queryOptions, null);
    }

    @Override
    public List<SAProcessInstance> searchArchivedProcessInstances(QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        return persistenceService.searchEntity(SAProcessInstance.class, queryOptions, null);
    }

    @Override
    public List<SAProcessInstance> searchArchivedProcessInstancesInvolvingUser(long userId, QueryOptions queryOptions) throws SBonitaReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>(1);
            parameters.put(USER_ID, userId);
            return persistenceService.searchEntity(SAProcessInstance.class, INVOLVING_USER, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaReadException(e);
        }
    }

    @Override
    public void updateProcess(SProcessInstance processInstance, EntityUpdateDescriptor descriptor) throws SProcessInstanceModificationException {
        try {
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)processInstance, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("PROCESSINSTANCE", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROCESSINSTANCE").setObject(processInstance).done();
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
        }
        catch (SRecorderException e) {
            throw new SProcessInstanceModificationException(e);
        }
    }

    @Override
    public SAProcessInstance getArchivedProcessInstance(long archivedProcessInstanceId) throws SProcessInstanceReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            Map<String, Object> parameters = Collections.singletonMap("id", archivedProcessInstanceId);
            return (SAProcessInstance)persistenceService.selectOne(new SelectOneDescriptor("getArchivedProcessInstance", parameters, SAProcessInstance.class));
        }
        catch (SBonitaReadException e) {
            throw new SProcessInstanceReadException(e);
        }
    }

    @Override
    public List<SAProcessInstance> getArchivedProcessInstancesInAllStates(List<Long> processInstanceIds) throws SProcessInstanceReadException {
        ReadPersistenceService persistenceService = this.archiveService.getDefinitiveArchiveReadPersistenceService();
        try {
            Map<String, Object> parameters = Collections.singletonMap("sourceObjectIds", processInstanceIds);
            SelectListDescriptor saProcessInstances = new SelectListDescriptor("getArchivedProcessInstancesInAllStates", parameters, SAProcessInstance.class, QueryOptions.countQueryOptions());
            return persistenceService.selectList(saProcessInstances);
        }
        catch (SBonitaReadException e) {
            throw new SProcessInstanceReadException(e);
        }
    }

    @Override
    public List<SProcessInstance> getProcessInstancesInStates(QueryOptions queryOptions, ProcessInstanceState ... states) throws SProcessInstanceReadException {
        Set<Integer> stateIds = this.getStateIdsFromStates(states);
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(1);
        inputParameters.put("stateIds", stateIds);
        SelectListDescriptor selectProcessInstancesInStates = new SelectListDescriptor("getProcessInstancesInStates", inputParameters, SProcessInstance.class, queryOptions);
        try {
            return this.persistenceRead.selectList(selectProcessInstancesInStates);
        }
        catch (SBonitaReadException e) {
            throw new SProcessInstanceReadException(e);
        }
    }

    protected Set<Integer> getStateIdsFromStates(ProcessInstanceState ... states) {
        if (states.length < 1) {
            throw new IllegalArgumentException("ProcessInstanceServiceImpl.getProcessInstancesInStates() must have at least one state as parameter");
        }
        HashSet<Integer> stateIds = new HashSet<Integer>(states.length);
        for (int i = 0; i < states.length; ++i) {
            stateIds.add(states[i].getId());
        }
        return stateIds;
    }

    @Override
    public List<SProcessInstance> getProcessInstancesInState(QueryOptions queryOptions, ProcessInstanceState state) throws SProcessInstanceReadException {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(1);
        inputParameters.put("state", state.getId());
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getProcessInstancesInState", inputParameters, SProcessInstance.class, queryOptions);
        try {
            return this.persistenceRead.selectList(selectListDescriptor);
        }
        catch (SBonitaReadException e) {
            throw new SProcessInstanceReadException(e);
        }
    }

    @Override
    public List<Long> getArchivedChildrenSourceObjectIdsFromRootProcessInstance(long rootProcessIntanceId, int fromIndex, int maxResults, OrderByType sortingOrder) throws SBonitaReadException {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>(1);
        inputParameters.put("rootProcessInstanceId", rootProcessIntanceId);
        QueryOptions queryOptions = new QueryOptions(fromIndex, maxResults, SAProcessInstance.class, "sourceObjectId", sortingOrder);
        SelectListDescriptor selectListDescriptor = new SelectListDescriptor("getChildrenSourceProcessInstanceIdsFromRootProcessInstance", inputParameters, SAProcessInstance.class, queryOptions);
        return this.persistenceRead.selectList(selectListDescriptor);
    }

    @Override
    public SAProcessInstance getLastArchivedProcessInstance(long processInstanceId) throws SBonitaReadException {
        SAProcessInstanceBuilderFactory processInstanceBuilderFact = BuilderFactory.get(SAProcessInstanceBuilderFactory.class);
        FilterOption filterOption = new FilterOption(SAProcessInstance.class, processInstanceBuilderFact.getSourceObjectIdKey(), processInstanceId);
        ArrayList<OrderByOption> orderByOptions = new ArrayList<OrderByOption>();
        orderByOptions.add(new OrderByOption(SAProcessInstance.class, processInstanceBuilderFact.getArchiveDateKey(), OrderByType.DESC));
        orderByOptions.add(new OrderByOption(SAProcessInstance.class, processInstanceBuilderFact.getEndDateKey(), OrderByType.DESC));
        QueryOptions queryOptions = new QueryOptions(0, 1, orderByOptions, Collections.singletonList(filterOption), null);
        List<SAProcessInstance> processInstances = this.searchArchivedProcessInstances(queryOptions);
        if (!processInstances.isEmpty()) {
            return processInstances.get(0);
        }
        return null;
    }

    @Override
    public long getNumberOfFailedProcessInstances(QueryOptions queryOptions) throws SBonitaReadException {
        return this.persistenceRead.getNumberOfEntities(SProcessInstance.class, FAILED, queryOptions, null);
    }

    @Override
    public List<SProcessInstance> searchFailedProcessInstances(QueryOptions queryOptions) throws SBonitaReadException {
        return this.persistenceRead.searchEntity(SProcessInstance.class, FAILED, queryOptions, null);
    }

    @Override
    public long getNumberOfProcessInstances(long processDefinitionId) throws SBonitaReadException {
        HashMap<String, Object> inputParameters = new HashMap<String, Object>();
        inputParameters.put("processDefinitionId", processDefinitionId);
        SelectOneDescriptor countDescriptor = new SelectOneDescriptor("countProcessInstancesOfProcessDefinition", inputParameters, SProcessInstance.class);
        return (Long)this.persistenceRead.selectOne(countDescriptor);
    }
}

