/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.impl;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.TransitionState;
import org.bonitasoft.engine.core.process.instance.api.TransitionService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STransitionCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.STransitionDeletionException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SATransitionInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SATransitionInstanceBuilderFactory;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;

public class TransitionServiceImpl
implements TransitionService {
    private final ReadPersistenceService persistenceRead;
    private final ArchiveService archiveService;

    public TransitionServiceImpl(ReadPersistenceService persistenceRead, ArchiveService archiveService) {
        this.persistenceRead = persistenceRead;
        this.archiveService = archiveService;
    }

    @Override
    public long getNumberOfArchivedTransitionInstances(QueryOptions countOptions) throws SBonitaReadException {
        return this.persistenceRead.getNumberOfEntities(SATransitionInstance.class, countOptions, null);
    }

    @Override
    public List<SATransitionInstance> searchArchivedTransitionInstances(QueryOptions queryOptions) throws SBonitaReadException {
        return this.persistenceRead.searchEntity(SATransitionInstance.class, queryOptions, null);
    }

    @Override
    public void archive(STransitionDefinition sTransitionDefinition, SFlowNodeInstance sFlowNodeInstance, TransitionState transitionState) throws STransitionCreationException {
        SATransitionInstance saTransitionInstance = BuilderFactory.get(SATransitionInstanceBuilderFactory.class).createNewTransitionInstance(sTransitionDefinition, sFlowNodeInstance, transitionState).done();
        long archiveDate = System.currentTimeMillis();
        try {
            this.archiveTransitionInstanceInsertRecord(saTransitionInstance, archiveDate);
        }
        catch (SRecorderException e) {
            throw new STransitionCreationException(e);
        }
    }

    private void archiveTransitionInstanceInsertRecord(SATransitionInstance saTransitionInstance, long archiveDate) throws SRecorderException {
        ArchiveInsertRecord insertRecord = new ArchiveInsertRecord(saTransitionInstance);
        this.archiveService.recordInsert(archiveDate, insertRecord);
    }

    @Override
    public void delete(SATransitionInstance saTransitionInstance) throws STransitionDeletionException {
        DeleteRecord deleteRecord = new DeleteRecord(saTransitionInstance);
        try {
            this.archiveService.recordDelete(deleteRecord);
        }
        catch (SRecorderException e) {
            throw new STransitionDeletionException(e);
        }
    }

    @Override
    public void deleteArchivedTransitionsOfProcessInstance(long processInstanceId) throws STransitionDeletionException, SBonitaReadException {
        List<SATransitionInstance> transitionInstances;
        SATransitionInstanceBuilderFactory saTransitionInstanceBuilder = BuilderFactory.get(SATransitionInstanceBuilderFactory.class);
        String rootContainerIdKey = saTransitionInstanceBuilder.getRootContainerIdKey();
        String idKey = saTransitionInstanceBuilder.getIdKey();
        do {
            List<FilterOption> filters = Collections.singletonList(new FilterOption(SATransitionInstance.class, rootContainerIdKey, processInstanceId));
            List<OrderByOption> orderByOptions = Collections.singletonList(new OrderByOption(SATransitionInstance.class, idKey, OrderByType.ASC));
            QueryOptions queryOptions = new QueryOptions(0, 10, orderByOptions, filters, null);
            transitionInstances = this.searchArchivedTransitionInstances(queryOptions);
            for (SATransitionInstance saTransitionInstance : transitionInstances) {
                this.delete(saTransitionInstance);
            }
        } while (!transitionInstances.isEmpty());
    }
}

