/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.instance.model.builder.impl;

import java.util.Date;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilder;
import org.bonitasoft.engine.core.process.instance.model.builder.SProcessInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.impl.SProcessInstanceBuilderImpl;
import org.bonitasoft.engine.core.process.instance.model.impl.SProcessInstanceImpl;

public class SProcessInstanceBuilderFactoryImpl
implements SProcessInstanceBuilderFactory {
    private static final String ID_KEY = "id";
    private static final String NAME_KEY = "name";
    private static final String PROCESSDEF_ID_KEY = "processDefinitionId";
    private static final String STATE_ID_KEY = "stateId";
    private static final String STATE_CATEGORY_KEY = "stateCategory";
    private static final String CONTAINER_ID_KEY = "containerId";
    private static final String MIGRATION_PLAN_ID = "migrationPlanId";
    private static final String END_DATE_KEY = "endDate";
    private static final String STARTED_BY_KEY = "startedBy";
    private static final String STARTED_BY_SUBSTITUTE_KEY = "startedBySubstitute";
    private static final String START_DATE_KEY = "startDate";
    private static final String CALLER_ID = "callerId";
    static final String LAST_UPDATE_KEY = "lastUpdate";
    static final String INTERRUPTING_EVENT_ID_KEY = "interruptingEventId";

    @Override
    public SProcessInstanceBuilder createNewInstance(String name, long processDefinitionId) {
        NullCheckingUtil.checkArgsNotNull(name, processDefinitionId);
        SProcessInstanceImpl entity = new SProcessInstanceImpl(name, processDefinitionId);
        entity.setStateCategory(SStateCategory.NORMAL);
        entity.setStartDate(new Date().getTime());
        return new SProcessInstanceBuilderImpl(entity);
    }

    @Override
    public SProcessInstanceBuilder createNewInstance(String name, long processDefinitionId, String description) {
        SProcessInstanceBuilder builder = this.createNewInstance(name, processDefinitionId);
        builder.setDescription(description);
        return builder;
    }

    @Override
    public SProcessInstanceBuilder createNewInstance(SProcessDefinition definition) {
        return this.createNewInstance(definition.getName(), definition.getId(), definition.getDescription());
    }

    @Override
    public String getIdKey() {
        return ID_KEY;
    }

    @Override
    public String getNameKey() {
        return NAME_KEY;
    }

    @Override
    public String getProcessDefinitionIdKey() {
        return PROCESSDEF_ID_KEY;
    }

    @Override
    public String getStateIdKey() {
        return STATE_ID_KEY;
    }

    @Override
    public String getStateCategoryKey() {
        return STATE_CATEGORY_KEY;
    }

    @Override
    public String getStartDateKey() {
        return START_DATE_KEY;
    }

    @Override
    public String getStartedByKey() {
        return STARTED_BY_KEY;
    }

    @Override
    public String getStartedBySubstituteKey() {
        return STARTED_BY_SUBSTITUTE_KEY;
    }

    @Override
    public String getEndDateKey() {
        return END_DATE_KEY;
    }

    @Override
    public String getLastUpdateKey() {
        return LAST_UPDATE_KEY;
    }

    @Override
    public String getContainerIdKey() {
        return CONTAINER_ID_KEY;
    }

    @Override
    public String getInterruptingEventIdKey() {
        return INTERRUPTING_EVENT_ID_KEY;
    }

    @Override
    public String getMigrationPlanIdKey() {
        return MIGRATION_PLAN_ID;
    }

    @Override
    public String getCallerIdKey() {
        return CALLER_ID;
    }
}

