/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.actor.mapping.SActorNotFoundException;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.bpm.bar.xml.XMLProcessDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorEvent;
import org.bonitasoft.engine.bpm.connector.ConnectorState;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.SClassLoaderException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.connector.ConnectorInstanceService;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceModificationException;
import org.bonitasoft.engine.core.connector.exception.SConnectorInstanceReadException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.filter.FilterResult;
import org.bonitasoft.engine.core.filter.UserFilterService;
import org.bonitasoft.engine.core.filter.exception.SUserFilterExecutionException;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.comment.api.SCommentAddException;
import org.bonitasoft.engine.core.process.comment.api.SCommentService;
import org.bonitasoft.engine.core.process.comment.api.SystemCommentType;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SCallActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SHumanTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SMultiInstanceLoopCharacteristics;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SReceiveTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSendTaskDefinition;
import org.bonitasoft.engine.core.process.definition.model.SUserFilterDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SBoundaryEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SIntermediateCatchEventDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SThrowEventDefinition;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityCreationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SProcessInstanceCreationException;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SCallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SPendingActivityMapping;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.archive.builder.SAAutomaticTaskInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SMultiInstanceActivityInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.SPendingActivityMappingBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.SBoundaryEventInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SIntermediateCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SThrowEventInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.api.ParentContainerResolver;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilderFactory;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.execution.WaitingEventsInterrupter;
import org.bonitasoft.engine.execution.event.EventsHandler;
import org.bonitasoft.engine.execution.event.OperationsWithContext;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.work.SWorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class StateBehaviors {
    public static final int BEFORE_ON_ENTER = 1;
    public static final int DURING_ON_ENTER = 2;
    public static final int BEFORE_ON_FINISH = 4;
    public static final int DURING_ON_FINISH = 8;
    public static final int AFTER_ON_FINISH = 16;
    private static final int BATCH_SIZE = 20;
    private static final int MAX_NUMBER_OF_RESULTS = 100;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final EventsHandler eventsHandler;
    private final ActivityInstanceService activityInstanceService;
    private final UserFilterService userFilterService;
    private final ClassLoaderService classLoaderService;
    private final ActorMappingService actorMappingService;
    private final ExpressionResolverService expressionResolverService;
    private final ProcessDefinitionService processDefinitionService;
    private final DataInstanceService dataInstanceService;
    private final OperationService operationService;
    private final WorkService workService;
    private final ContainerRegistry containerRegistry;
    private final EventInstanceService eventInstanceService;
    private final ConnectorInstanceService connectorInstanceService;
    private ProcessExecutor processExecutor;
    private final SCommentService commentService;
    private final IdentityService identityService;
    protected final ParentContainerResolver parentContainerResolver;
    private final WaitingEventsInterrupter waitingEventsInterrupter;

    public StateBehaviors(BPMInstancesCreator bpmInstancesCreator, EventsHandler eventsHandler, ActivityInstanceService activityInstanceService, UserFilterService userFilterService, ClassLoaderService classLoaderService, ActorMappingService actorMappingService, ConnectorInstanceService connectorInstanceService, ExpressionResolverService expressionResolverService, ProcessDefinitionService processDefinitionService, DataInstanceService dataInstanceService, OperationService operationService, WorkService workService, ContainerRegistry containerRegistry, EventInstanceService eventInstanceService, SCommentService commentService, IdentityService identityService, ParentContainerResolver parentContainerResolver, WaitingEventsInterrupter waitingEventsInterrupter) {
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.eventsHandler = eventsHandler;
        this.activityInstanceService = activityInstanceService;
        this.userFilterService = userFilterService;
        this.classLoaderService = classLoaderService;
        this.actorMappingService = actorMappingService;
        this.connectorInstanceService = connectorInstanceService;
        this.expressionResolverService = expressionResolverService;
        this.processDefinitionService = processDefinitionService;
        this.dataInstanceService = dataInstanceService;
        this.operationService = operationService;
        this.workService = workService;
        this.containerRegistry = containerRegistry;
        this.eventInstanceService = eventInstanceService;
        this.commentService = commentService;
        this.identityService = identityService;
        this.parentContainerResolver = parentContainerResolver;
        this.waitingEventsInterrupter = waitingEventsInterrupter;
    }

    public void setProcessExecutor(ProcessExecutor processExecutor) {
        this.processExecutor = processExecutor;
    }

    public DataInstanceContainer getParentContainerType(SFlowNodeInstance flowNodeInstance) {
        DataInstanceContainer parentContainerType = flowNodeInstance.getLogicalGroup(2) <= 0L ? DataInstanceContainer.PROCESS_INSTANCE : DataInstanceContainer.ACTIVITY_INSTANCE;
        return parentContainerType;
    }

    public DataInstanceService getDataInstanceService() {
        return this.dataInstanceService;
    }

    public void mapDataOutputOfMultiInstance(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        SFlowElementContainerDefinition processContainer;
        SActivityDefinition activityDefinition;
        if (flowNodeInstance instanceof SActivityInstance && !SFlowNodeType.MULTI_INSTANCE_ACTIVITY.equals((Object)flowNodeInstance.getType()) && (activityDefinition = (SActivityDefinition)(processContainer = processDefinition.getProcessContainer()).getFlowNode(flowNodeInstance.getFlowNodeDefinitionId())) != null) {
            try {
                SLoopCharacteristics loopCharacteristics = activityDefinition.getLoopCharacteristics();
                if (loopCharacteristics instanceof SMultiInstanceLoopCharacteristics && ((SMultiInstanceLoopCharacteristics)loopCharacteristics).getDataOutputItemRef() != null) {
                    this.mapDataOutputOfMultiInstance(flowNodeInstance, (SMultiInstanceLoopCharacteristics)loopCharacteristics);
                }
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException(e);
            }
        }
    }

    public void mapDataOutputOfMultiInstance(SFlowNodeInstance flowNodeInstance, SMultiInstanceLoopCharacteristics miLoop) throws SActivityExecutionException, SBonitaException {
        SDataInstance outputData = this.dataInstanceService.getDataInstance(miLoop.getDataOutputItemRef(), flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), this.parentContainerResolver);
        SDataInstance loopData = this.dataInstanceService.getDataInstance(miLoop.getLoopDataOutputRef(), flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), this.parentContainerResolver);
        if (outputData != null && loopData != null) {
            Serializable value = loopData.getValue();
            int index = flowNodeInstance.getLoopCounter();
            if (!(value instanceof List)) {
                throw new SActivityExecutionException("unable to map the ouput of the multi instanciated activity " + flowNodeInstance.getName() + " the output loop data named " + loopData.getName() + " is not a list but " + loopData.getClassName());
            }
            ((List)((Object)value)).set(index, outputData.getValue());
            EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
            entityUpdateDescriptor.addField("value", value);
            this.dataInstanceService.updateDataInstance(loopData, entityUpdateDescriptor);
        }
    }

    public void mapActors(SFlowNodeInstance flowNodeInstance, SFlowElementContainerDefinition processContainer) throws SActivityStateExecutionException {
        if (SFlowNodeType.USER_TASK.equals((Object)flowNodeInstance.getType()) || SFlowNodeType.MANUAL_TASK.equals((Object)flowNodeInstance.getType())) {
            try {
                SHumanTaskDefinition humanTaskDefinition = (SHumanTaskDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
                if (humanTaskDefinition != null) {
                    String actorName = humanTaskDefinition.getActorName();
                    long processDefinitionId = flowNodeInstance.getLogicalGroup(0);
                    SUserFilterDefinition sUserFilterDefinition = humanTaskDefinition.getSUserFilterDefinition();
                    if (sUserFilterDefinition != null) {
                        this.mapUsingUserFilters(flowNodeInstance, humanTaskDefinition, actorName, processDefinitionId, sUserFilterDefinition);
                    } else {
                        this.mapUsingActors(flowNodeInstance, actorName, processDefinitionId);
                    }
                }
            }
            catch (SActivityStateExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SActivityStateExecutionException(e);
            }
        }
    }

    private void mapUsingActors(SFlowNodeInstance flowNodeInstance, String actorName, long processDefinitionId) throws SActorNotFoundException, SActivityCreationException {
        SActor actor = this.actorMappingService.getActor(actorName, processDefinitionId);
        SPendingActivityMapping mapping = BuilderFactory.get(SPendingActivityMappingBuilderFactory.class).createNewInstanceForActor(flowNodeInstance.getId(), actor.getId()).done();
        this.activityInstanceService.addPendingActivityMappings(mapping);
    }

    void mapUsingUserFilters(SFlowNodeInstance flowNodeInstance, SHumanTaskDefinition humanTaskDefinition, String actorName, long processDefinitionId, SUserFilterDefinition sUserFilterDefinition) throws SClassLoaderException, SUserFilterExecutionException, SActivityStateExecutionException, SActivityCreationException, SFlowNodeNotFoundException, SFlowNodeReadException, SActivityModificationException {
        ClassLoader processClassloader = this.classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionId);
        SExpressionContext expressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), flowNodeInstance.getLogicalGroup(0));
        FilterResult result = this.userFilterService.executeFilter(processDefinitionId, sUserFilterDefinition, sUserFilterDefinition.getInputs(), processClassloader, expressionContext, actorName);
        List<Long> userIds = result.getResult();
        if (userIds == null || userIds.isEmpty() || userIds.contains(0L) || userIds.contains(-1L)) {
            throw new SActivityStateExecutionException("no user id returned by the user filter " + sUserFilterDefinition + " on activity " + humanTaskDefinition.getName());
        }
        for (Long userId : new TreeSet<Long>(userIds)) {
            SPendingActivityMapping mapping = BuilderFactory.get(SPendingActivityMappingBuilderFactory.class).createNewInstanceForUser(flowNodeInstance.getId(), userId).done();
            this.activityInstanceService.addPendingActivityMappings(mapping);
        }
        if (userIds.size() == 1 && result.shouldAutoAssignTaskIfSingleResult()) {
            Long userId = userIds.get(0);
            this.activityInstanceService.assignHumanTask(flowNodeInstance.getId(), userId);
        }
    }

    public void handleCatchEvents(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        if (flowNodeInstance instanceof SIntermediateCatchEventInstance) {
            SCatchEventInstance intermediateCatchEventInstance = (SCatchEventInstance)flowNodeInstance;
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SIntermediateCatchEventDefinition intermediateCatchEventDefinition = (SIntermediateCatchEventDefinition)processContainer.getFlowNode(intermediateCatchEventInstance.getFlowNodeDefinitionId());
            try {
                this.eventsHandler.handleCatchEvent(processDefinition, intermediateCatchEventDefinition, intermediateCatchEventInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("unable to handle catch event " + flowNodeInstance, e);
            }
        }
        if (flowNodeInstance instanceof SReceiveTaskInstance) {
            SReceiveTaskInstance receiveTaskInstance = (SReceiveTaskInstance)flowNodeInstance;
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SReceiveTaskDefinition receiveTaskIDefinition = (SReceiveTaskDefinition)processContainer.getFlowNode(receiveTaskInstance.getFlowNodeDefinitionId());
            try {
                this.eventsHandler.handleCatchMessage(processDefinition, receiveTaskIDefinition, receiveTaskInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("unable to handle catch event " + flowNodeInstance, e);
            }
        }
    }

    public void handleBoundaryEvent(SProcessDefinition processDefinition, SBoundaryEventInstance boundaryInstance) throws SActivityStateExecutionException {
        long activityInstanceId = boundaryInstance.getActivityInstanceId();
        try {
            SActivityInstance activityInstance = this.activityInstanceService.getActivityInstance(activityInstanceId);
            SActivityDefinition activityDefinition = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(activityInstance.getFlowNodeDefinitionId());
            SBoundaryEventDefinition boundaryEventDefinition = activityDefinition.getBoundaryEventDefinition(boundaryInstance.getName());
            this.eventsHandler.handleCatchEvent(processDefinition, boundaryEventDefinition, boundaryInstance);
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException("unable to handle catch event " + boundaryInstance, e);
        }
    }

    public XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> getConnectorToExecuteAndFlag(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, boolean executeConnectorsOnEnter, boolean executeConnectorsOnFinish) throws SActivityStateExecutionException {
        try {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SFlowNodeDefinition flowNodeDefinition = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            if (flowNodeDefinition != null) {
                XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> connectorToExecuteOnFinish;
                boolean onEnterExecuted = false;
                List<SConnectorDefinition> connectorsOnEnter = flowNodeDefinition.getConnectors(ConnectorEvent.ON_ENTER);
                if (connectorsOnEnter.size() > 0 && executeConnectorsOnEnter) {
                    XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> connectorToExecuteOnEnter = this.getConnectorToExecuteOnEnter(flowNodeInstance, connectorsOnEnter);
                    if (connectorToExecuteOnEnter != null) {
                        return connectorToExecuteOnEnter;
                    }
                    onEnterExecuted = true;
                }
                if ((connectorToExecuteOnFinish = this.getConnectorToExecuteOnFinish(flowNodeDefinition, flowNodeInstance, executeConnectorsOnFinish, onEnterExecuted)) != null) {
                    return connectorToExecuteOnFinish;
                }
                if (flowNodeInstance.isStateExecuting()) {
                    return this.getConnectorWithFlag(null, null, 20);
                }
            }
            return this.getConnectorWithFlag(null, null, 21);
        }
        catch (SConnectorInstanceReadException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    private XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> getConnectorToExecuteOnFinish(SFlowNodeDefinition flowNodeDefinition, SFlowNodeInstance flowNodeInstance, boolean executeConnectorsOnFinish, boolean onEnterExecuted) throws SConnectorInstanceReadException, SActivityStateExecutionException {
        List<SConnectorDefinition> connectorsOnFinish = flowNodeDefinition.getConnectors(ConnectorEvent.ON_FINISH);
        if (connectorsOnFinish.size() > 0 && executeConnectorsOnFinish) {
            SConnectorInstance nextConnectorInstanceToExecute = this.getNextConnectorInstance(flowNodeInstance, ConnectorEvent.ON_FINISH);
            if (nextConnectorInstanceToExecute != null) {
                if (nextConnectorInstanceToExecute.getState().equals(ConnectorState.TO_BE_EXECUTED.name()) && connectorsOnFinish.get(0).getName().equals(nextConnectorInstanceToExecute.getName())) {
                    SConnectorDefinition connectorDefinition = connectorsOnFinish.get(0);
                    if (onEnterExecuted) {
                        return this.getConnectorWithFlag(nextConnectorInstanceToExecute, connectorDefinition, 12);
                    }
                    return this.getConnectorWithFlag(nextConnectorInstanceToExecute, connectorDefinition, 13);
                }
                return this.getConnectorWithFlagIfIsNextToExecute(flowNodeInstance, connectorsOnFinish, nextConnectorInstanceToExecute, 8);
            }
            return this.getConnectorWithFlag(null, null, 16);
        }
        return null;
    }

    private XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> getConnectorToExecuteOnEnter(SFlowNodeInstance flowNodeInstance, List<SConnectorDefinition> connectorsOnEnter) throws SConnectorInstanceReadException, SActivityStateExecutionException {
        SConnectorInstance nextConnectorInstanceToExecute = this.getNextConnectorInstance(flowNodeInstance, ConnectorEvent.ON_ENTER);
        if (nextConnectorInstanceToExecute != null) {
            if (nextConnectorInstanceToExecute.getState().equals(ConnectorState.TO_BE_EXECUTED.name()) && connectorsOnEnter.get(0).getName().equals(nextConnectorInstanceToExecute.getName())) {
                return this.getConnectorWithFlag(nextConnectorInstanceToExecute, connectorsOnEnter.get(0), 3);
            }
            return this.getConnectorWithFlagIfIsNextToExecute(flowNodeInstance, connectorsOnEnter, nextConnectorInstanceToExecute, 2);
        }
        return null;
    }

    private XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> getConnectorWithFlagIfIsNextToExecute(SFlowNodeInstance flowNodeInstance, List<SConnectorDefinition> sConnectorDefinitions, SConnectorInstance nextConnectorInstanceToExecute, int flag) throws SActivityStateExecutionException {
        for (SConnectorDefinition sConnectorDefinition : sConnectorDefinitions) {
            if (!sConnectorDefinition.getName().equals(nextConnectorInstanceToExecute.getName())) continue;
            return this.getConnectorWithFlag(nextConnectorInstanceToExecute, sConnectorDefinition, flag);
        }
        throw new SActivityStateExecutionException("Connector definition of " + nextConnectorInstanceToExecute + " not found on " + flowNodeInstance);
    }

    private XMLProcessDefinition.BEntry<Integer, XMLProcessDefinition.BEntry<SConnectorInstance, SConnectorDefinition>> getConnectorWithFlag(SConnectorInstance nextConnectorInstance, SConnectorDefinition connectorDefinition, int flag) {
        return new XMLProcessDefinition.BEntry((Object)flag, (Object)new XMLProcessDefinition.BEntry((Object)nextConnectorInstance, (Object)connectorDefinition));
    }

    private SConnectorInstance getNextConnectorInstance(SFlowNodeInstance flowNodeInstance, ConnectorEvent event) throws SConnectorInstanceReadException {
        return this.connectorInstanceService.getNextExecutableConnectorInstance(flowNodeInstance.getId(), "flowNode", event);
    }

    public void createData(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        if (flowNodeInstance instanceof SActivityInstance) {
            String containerType = this.getParentContainerType(flowNodeInstance).name();
            SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getParentContainerId(), containerType, processDefinition.getId());
            this.bpmInstancesCreator.createDataInstances(processDefinition, flowNodeInstance, sExpressionContext);
        }
    }

    public void handleCallActivity(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        if (this.isCallActivity(flowNodeInstance)) {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            try {
                SCallActivityDefinition callActivity = (SCallActivityDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
                if (callActivity == null) {
                    StringBuilder stb = new StringBuilder("unable to find call activity definition with name '");
                    stb.append(flowNodeInstance.getName());
                    stb.append("' in procecess definition '");
                    stb.append(processDefinition.getId());
                    stb.append("'");
                    throw new SActivityStateExecutionException(stb.toString());
                }
                SExpressionContext expressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId());
                String callableElement = (String)this.expressionResolverService.evaluate(callActivity.getCallableElement(), expressionContext);
                String callableElementVersion = null;
                if (callActivity.getCallableElementVersion() != null) {
                    callableElementVersion = (String)this.expressionResolverService.evaluate(callActivity.getCallableElementVersion(), expressionContext);
                }
                long targetProcessDefinitionId = this.getTargetProcessDefinitionId(callableElement, callableElementVersion);
                this.instantiateProcess(processDefinition, callActivity, flowNodeInstance, targetProcessDefinitionId);
                SCallActivityInstance callActivityInstance = (SCallActivityInstance)flowNodeInstance;
                this.activityInstanceService.setTokenCount(callActivityInstance, callActivityInstance.getTokenCount() + 1);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException(e);
            }
        }
    }

    private long getTargetProcessDefinitionId(String callableElement, String callableElementVersion) throws SProcessDefinitionReadException, SProcessDefinitionNotFoundException {
        if (callableElementVersion != null) {
            return this.processDefinitionService.getProcessDefinitionId(callableElement, callableElementVersion);
        }
        return this.processDefinitionService.getLatestProcessDefinitionId(callableElement);
    }

    private boolean isCallActivity(SFlowNodeInstance flowNodeInstance) {
        return SFlowNodeType.CALL_ACTIVITY.equals((Object)flowNodeInstance.getType());
    }

    private void instantiateProcess(SProcessDefinition callerProcessDefinition, SCallActivityDefinition callActivityDefinition, SFlowNodeInstance callActivityInstance, long targetProcessDefinitionId) throws SProcessInstanceCreationException {
        long callerProcessDefinitionId = callerProcessDefinition.getId();
        long callerId = callActivityInstance.getId();
        List<SOperation> operationList = callActivityDefinition.getDataInputOperations();
        SExpressionContext context = new SExpressionContext((Long)callerId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), callerProcessDefinitionId);
        OperationsWithContext operations = new OperationsWithContext(context, operationList);
        this.processExecutor.start(targetProcessDefinitionId, -1L, 0L, 0L, operations.getContext(), operations.getOperations(), null, null, callerId, -1L);
    }

    public void updateDisplayNameAndDescription(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        try {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SFlowNodeDefinition flowNode = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            if (flowNode != null) {
                SExpression displayNameExpression = flowNode.getDisplayName();
                SExpression displayDescriptionExpression = flowNode.getDisplayDescription();
                SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId());
                String displayName = displayNameExpression != null ? (String)this.expressionResolverService.evaluate(displayNameExpression, sExpressionContext) : flowNode.getName();
                String displayDescription = displayDescriptionExpression != null ? (String)this.expressionResolverService.evaluate(displayDescriptionExpression, sExpressionContext) : flowNode.getDescription();
                this.activityInstanceService.updateDisplayName(flowNodeInstance, displayName);
                this.activityInstanceService.updateDisplayDescription(flowNodeInstance, displayDescription);
            }
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
    }

    public void updateDisplayDescriptionAfterCompletion(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        try {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SFlowNodeDefinition flowNode = processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            if (flowNode != null) {
                SExpression displayDescriptionAfterCompletionExpression = flowNode.getDisplayDescriptionAfterCompletion();
                SExpressionContext sExpressionContext = new SExpressionContext((Long)flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId());
                if (displayDescriptionAfterCompletionExpression != null) {
                    String displayDescriptionAfterCompletion = (String)this.expressionResolverService.evaluate(displayDescriptionAfterCompletionExpression, sExpressionContext);
                    this.activityInstanceService.updateDisplayDescription(flowNodeInstance, displayDescriptionAfterCompletion);
                }
            }
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException("error while updating display name and description", e);
        }
    }

    public void executeOperations(SProcessDefinition processDefinition, SActivityInstance activityInstance) throws SActivityStateExecutionException {
        try {
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SFlowNodeDefinition flowNode = processContainer.getFlowNode(activityInstance.getFlowNodeDefinitionId());
            if (flowNode instanceof SActivityDefinition) {
                SActivityDefinition activityDefinition = (SActivityDefinition)flowNode;
                List<SOperation> sOperations = activityDefinition.getSOperations();
                SExpressionContext sExpressionContext = new SExpressionContext((Long)activityInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), processDefinition.getId());
                this.operationService.execute(sOperations, sExpressionContext);
            }
        }
        catch (SOperationExecutionException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    public void handleThrowEvent(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        if (flowNodeInstance instanceof SThrowEventInstance) {
            SThrowEventInstance throwEventInstance = (SThrowEventInstance)flowNodeInstance;
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SThrowEventDefinition eventDefinition = (SThrowEventDefinition)processContainer.getFlowNode(throwEventInstance.getFlowNodeDefinitionId());
            try {
                this.eventsHandler.handleThrowEvent(processDefinition, eventDefinition, throwEventInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("unable to handle throw event " + flowNodeInstance, e);
            }
        }
        if (SFlowNodeType.SEND_TASK.equals((Object)flowNodeInstance.getType())) {
            SSendTaskInstance sendTaskInstance = (SSendTaskInstance)flowNodeInstance;
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SSendTaskDefinition sendTaskDefinition = (SSendTaskDefinition)processContainer.getFlowNode(sendTaskInstance.getFlowNodeDefinitionId());
            try {
                this.eventsHandler.handleThrowMessage(processDefinition, sendTaskDefinition, sendTaskInstance);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("unable to handle throw message " + flowNodeInstance, e);
            }
        }
    }

    public void executeChildrenActivities(SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        try {
            List<SActivityInstance> childrenOfAnActivity;
            int i = 0;
            do {
                childrenOfAnActivity = this.activityInstanceService.getChildrenOfAnActivity(flowNodeInstance.getId(), i, 20);
                for (SActivityInstance sActivityInstance : childrenOfAnActivity) {
                    this.containerRegistry.executeFlowNode(flowNodeInstance.getProcessDefinitionId(), sActivityInstance.getLogicalGroup(BuilderFactory.get(SAAutomaticTaskInstanceBuilderFactory.class).getParentProcessInstanceIndex()), sActivityInstance.getId(), null, null);
                }
                i += 20;
            } while (childrenOfAnActivity.size() == 20);
        }
        catch (SBonitaException e) {
            throw new SActivityExecutionException(e);
        }
    }

    public void interruptSubActivities(long parentActivityInstanceId, SStateCategory stateCategory) throws SBonitaException {
        List<SActivityInstance> childrenToEnd;
        QueryOptions queryOptions = this.activityInstanceService.buildQueryOptionsForSubActivitiesInNormalStateAndNotTerminal(parentActivityInstanceId, 100);
        do {
            childrenToEnd = this.activityInstanceService.searchActivityInstances(SActivityInstance.class, queryOptions);
            for (SActivityInstance child : childrenToEnd) {
                this.activityInstanceService.setStateCategory(child, stateCategory);
                if (!child.isStable()) continue;
                this.containerRegistry.executeFlowNode(child.getProcessDefinitionId(), child.getLogicalGroup(BuilderFactory.get(SAAutomaticTaskInstanceBuilderFactory.class).getParentProcessInstanceIndex()), child.getId(), null, null);
            }
            queryOptions = QueryOptions.getNextPage(queryOptions);
        } while (!childrenToEnd.isEmpty());
    }

    public void executeConnectorInWork(Long processDefinitionId, long processInstanceId, long flowNodeDefinitionId, long flowNodeInstanceId, SConnectorInstance connector, SConnectorDefinition sConnectorDefinition) throws SActivityStateExecutionException {
        long connectorInstanceId = connector.getId();
        String connectorDefinitionName = sConnectorDefinition.getName();
        try {
            this.connectorInstanceService.setState(connector, ConnectorState.EXECUTING.name());
            this.workService.registerWork(WorkFactory.createExecuteConnectorOfActivity(processDefinitionId, processInstanceId, flowNodeDefinitionId, flowNodeInstanceId, connectorInstanceId, connectorDefinitionName));
        }
        catch (SConnectorInstanceModificationException e) {
            throw new SActivityStateExecutionException("Unable to set ConnectorState to EXECUTING", e);
        }
        catch (SWorkRegisterException e) {
            throw new SActivityStateExecutionException("Unable to register the work that execute the connector " + connector + " on " + flowNodeInstanceId, e);
        }
    }

    public void createAttachedBoundaryEvents(SProcessDefinition processDefinition, SActivityInstance activityInstance) throws SActivityStateExecutionException {
        SActivityDefinition activityDefinition = (SActivityDefinition)processDefinition.getProcessContainer().getFlowNode(activityInstance.getFlowNodeDefinitionId());
        if (this.mustAddBoundaryEvents(activityInstance, activityDefinition)) {
            this.createAttachedBoundaryEvents(processDefinition, activityInstance, activityDefinition);
        }
    }

    private void createAttachedBoundaryEvents(SProcessDefinition processDefinition, SActivityInstance activityInstance, SActivityDefinition activityDefinition) throws SActivityStateExecutionException {
        List<SBoundaryEventDefinition> boundaryEventDefinitions = activityDefinition.getBoundaryEventDefinitions();
        try {
            SBoundaryEventInstanceBuilderFactory boundaryEventInstanceBuilder = BuilderFactory.get(SBoundaryEventInstanceBuilderFactory.class);
            long rootProcessInstanceId = activityInstance.getLogicalGroup(boundaryEventInstanceBuilder.getRootProcessInstanceIndex());
            long parentProcessInstanceId = activityInstance.getLogicalGroup(boundaryEventInstanceBuilder.getParentProcessInstanceIndex());
            SFlowElementsContainerType containerType = this.getContainerType(activityInstance, boundaryEventInstanceBuilder);
            for (SBoundaryEventDefinition boundaryEventDefinition : boundaryEventDefinitions) {
                this.createBoundaryEvent(processDefinition, activityInstance, rootProcessInstanceId, parentProcessInstanceId, containerType, boundaryEventDefinition);
            }
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException("Unable to create boundary events attached to activity " + activityInstance.getName(), e);
        }
    }

    private void createBoundaryEvent(SProcessDefinition processDefinition, SActivityInstance activityInstance, long rootProcessInstanceId, long parentProcessInstanceId, SFlowElementsContainerType containerType, SBoundaryEventDefinition boundaryEventDefinition) throws SBonitaException {
        SBoundaryEventInstance boundaryEventInstance = (SBoundaryEventInstance)this.bpmInstancesCreator.createFlowNodeInstance(processDefinition.getId(), rootProcessInstanceId, activityInstance.getParentContainerId(), containerType, boundaryEventDefinition, rootProcessInstanceId, parentProcessInstanceId, false, -1, SStateCategory.NORMAL, activityInstance.getId());
        this.containerRegistry.executeFlowNodeInSameThread(parentProcessInstanceId, boundaryEventInstance.getId(), null, null, containerType.name());
    }

    private SFlowElementsContainerType getContainerType(SActivityInstance activityInstance, SBoundaryEventInstanceBuilderFactory boundaryEventInstanceBuilder) {
        SFlowElementsContainerType containerType = SFlowElementsContainerType.PROCESS;
        long parentActivityInstanceId = activityInstance.getLogicalGroup(boundaryEventInstanceBuilder.getParentActivityInstanceIndex());
        if (parentActivityInstanceId > 0L) {
            containerType = SFlowElementsContainerType.FLOWNODE;
        }
        return containerType;
    }

    private boolean mustAddBoundaryEvents(SActivityInstance activityInstance, SActivityDefinition activityDefinition) {
        return activityDefinition != null && !activityDefinition.getBoundaryEventDefinitions().isEmpty() && !this.isChildOfLoopOrMultiInstance(activityInstance, activityDefinition);
    }

    private boolean isChildOfLoopOrMultiInstance(SActivityInstance activityInstance, SActivityDefinition activityDefinition) {
        return activityDefinition.getLoopCharacteristics() != null && !SFlowNodeType.MULTI_INSTANCE_ACTIVITY.equals((Object)activityInstance.getType()) && !SFlowNodeType.LOOP_ACTIVITY.equals((Object)activityInstance.getType());
    }

    public void interruptAttachedBoundaryEvent(SProcessDefinition processDefinition, SActivityInstance activityInstance, SStateCategory categoryState) throws SActivityStateExecutionException {
        SBoundaryEventInstanceBuilderFactory keyProvider = BuilderFactory.get(SBoundaryEventInstanceBuilderFactory.class);
        try {
            List<SBoundaryEventInstance> boundaryEventInstances = this.eventInstanceService.getActivityBoundaryEventInstances(activityInstance.getId(), 0, Integer.MAX_VALUE);
            for (SBoundaryEventInstance boundaryEventInstance : boundaryEventInstances) {
                if (activityInstance.getAbortedByBoundary() == boundaryEventInstance.getId()) continue;
                boolean stable = boundaryEventInstance.isStable();
                SBoundaryEventDefinition catchEventDef = processDefinition.getProcessContainer().getBoundaryEvent(boundaryEventInstance.getName());
                this.waitingEventsInterrupter.interruptWaitingEvents(processDefinition, boundaryEventInstance, catchEventDef);
                this.activityInstanceService.setStateCategory(boundaryEventInstance, categoryState);
                if (!stable) continue;
                this.containerRegistry.executeFlowNode(processDefinition.getId(), boundaryEventInstance.getLogicalGroup(keyProvider.getParentProcessInstanceIndex()), boundaryEventInstance.getId(), null, null);
            }
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException("Unable cancel boundary events attached to activity " + activityInstance.getName(), e);
        }
    }

    public void addAssignmentSystemCommentIfTaskWasAutoAssign(SFlowNodeInstance flowNodeInstance) throws SActivityStateExecutionException {
        long userId;
        if ((SFlowNodeType.USER_TASK.equals((Object)flowNodeInstance.getType()) || SFlowNodeType.MANUAL_TASK.equals((Object)flowNodeInstance.getType())) && (userId = ((SHumanTaskInstance)flowNodeInstance).getAssigneeId()) > 0L) {
            try {
                this.addAssignmentSystemComment(flowNodeInstance, userId);
            }
            catch (SBonitaException e) {
                throw new SActivityStateExecutionException("error while updating display name and description", e);
            }
        }
    }

    public void addAssignmentSystemComment(SFlowNodeInstance flowNodeInstance, long userId) throws SUserNotFoundException, SCommentAddException {
        SUser user = this.identityService.getUser(userId);
        if (this.commentService.isCommentEnabled(SystemCommentType.STATE_CHANGE)) {
            this.commentService.addSystemComment(flowNodeInstance.getRootContainerId(), "The task \"" + flowNodeInstance.getDisplayName() + "\" is now assigned to " + user.getUserName());
        }
    }

    public List<SFlowNodeInstance> createInnerInstances(long processDefinitionId, SActivityDefinition activity, SMultiInstanceActivityInstance flowNodeInstance, int numberOfInstanceToCreate) throws SBonitaException {
        SMultiInstanceActivityInstanceBuilderFactory keyProvider = BuilderFactory.get(SMultiInstanceActivityInstanceBuilderFactory.class);
        long rootProcessInstanceId = flowNodeInstance.getLogicalGroup(keyProvider.getRootProcessInstanceIndex());
        long parentProcessInstanceId = flowNodeInstance.getLogicalGroup(keyProvider.getParentProcessInstanceIndex());
        int nbOfcreatedInstances = 0;
        int nbOfInstances = flowNodeInstance.getNumberOfInstances();
        ArrayList<SFlowNodeInstance> createdInstances = new ArrayList<SFlowNodeInstance>();
        for (int i = nbOfInstances; i < nbOfInstances + numberOfInstanceToCreate; ++i) {
            createdInstances.add(this.bpmInstancesCreator.createFlowNodeInstance(processDefinitionId, flowNodeInstance.getRootContainerId(), flowNodeInstance.getId(), SFlowElementsContainerType.FLOWNODE, activity, rootProcessInstanceId, parentProcessInstanceId, true, i, SStateCategory.NORMAL, -1L));
            ++nbOfcreatedInstances;
        }
        this.activityInstanceService.addMultiInstanceNumberOfActiveActivities(flowNodeInstance, nbOfcreatedInstances);
        int tokenCount = flowNodeInstance.getTokenCount() + nbOfcreatedInstances;
        this.activityInstanceService.setTokenCount(flowNodeInstance, tokenCount);
        return createdInstances;
    }

    public int getNumberOfInstancesToCreateFromInputRef(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, SMultiInstanceLoopCharacteristics miLoop, int numberOfInstanceMax) throws SDataInstanceException, SActivityStateExecutionException {
        SDataInstance loopDataInput = this.dataInstanceService.getDataInstance(miLoop.getLoopDataInputRef(), flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), this.parentContainerResolver);
        if (loopDataInput != null) {
            Serializable value = loopDataInput.getValue();
            if (value instanceof List) {
                List loopDataInputCollection = (List)((Object)value);
                return loopDataInputCollection.size();
            }
            throw new SActivityStateExecutionException("The multi instance on activity " + flowNodeInstance.getName() + " of process " + processDefinition.getName() + " " + processDefinition.getVersion() + " have a loop data input which is not a java.util.List");
        }
        return numberOfInstanceMax;
    }

    public boolean shouldCreateANewInstance(SMultiInstanceLoopCharacteristics loopCharacteristics, int numberOfInstances, SMultiInstanceActivityInstance miActivityInstance) throws SDataInstanceException {
        if (loopCharacteristics.getLoopCardinality() != null) {
            return miActivityInstance.getLoopCardinality() > numberOfInstances;
        }
        SDataInstance dataInstance = this.dataInstanceService.getDataInstance(loopCharacteristics.getLoopDataInputRef(), miActivityInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), this.parentContainerResolver);
        if (dataInstance != null) {
            List loopDataInputCollection = (List)((Object)dataInstance.getValue());
            return numberOfInstances < loopDataInputCollection.size();
        }
        return false;
    }

    public void updateOutputData(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, SMultiInstanceLoopCharacteristics miLoop, int numberOfInstanceMax) throws SDataInstanceException, SActivityStateExecutionException {
        SDataInstance loopDataOutput;
        String loopDataOutputRef = miLoop.getLoopDataOutputRef();
        if (loopDataOutputRef != null && (loopDataOutput = this.dataInstanceService.getDataInstance(loopDataOutputRef, flowNodeInstance.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), this.parentContainerResolver)) != null) {
            Serializable outValue = loopDataOutput.getValue();
            if (outValue instanceof List) {
                List loopDataOutputCollection = (List)((Object)outValue);
                if (loopDataOutputCollection.size() < numberOfInstanceMax) {
                    ArrayList<Object> newOutputList = new ArrayList<Object>(numberOfInstanceMax);
                    newOutputList.addAll(loopDataOutputCollection);
                    for (int i = loopDataOutputCollection.size(); i < numberOfInstanceMax; ++i) {
                        newOutputList.add(null);
                    }
                    this.updateLoopDataOutputDataInstance(loopDataOutput, newOutputList);
                }
            } else if (outValue == null) {
                ArrayList<Object> newOutputList = new ArrayList<Object>(numberOfInstanceMax);
                for (int i = 0; i < numberOfInstanceMax; ++i) {
                    newOutputList.add(null);
                }
                this.updateLoopDataOutputDataInstance(loopDataOutput, newOutputList);
            } else {
                throw new SActivityStateExecutionException("The multi instance on activity " + flowNodeInstance.getName() + " of process " + processDefinition.getName() + " " + processDefinition.getVersion() + " have a loop data output which is not a java.util.List");
            }
        }
    }

    private void updateLoopDataOutputDataInstance(SDataInstance loopDataOutput, ArrayList<Object> newOutputList) throws SDataInstanceException {
        EntityUpdateDescriptor updateDescriptor = new EntityUpdateDescriptor();
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        updateDescriptor.addField(fact.getValueKey(), newOutputList);
        this.dataInstanceService.updateDataInstance(loopDataOutput, updateDescriptor);
    }
}

