/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SCatchEventDefinition;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingEventKeyProviderBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SIntermediateCatchEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.execution.job.JobNameBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.scheduler.SchedulerService;
import org.bonitasoft.engine.scheduler.exception.SSchedulerException;

public class WaitingEventsInterrupter {
    private final EventInstanceService eventInstanceService;
    private final SchedulerService schedulerService;
    private final TechnicalLoggerService logger;
    private static final int MAX_NUMBER_OF_RESULTS = 100;

    public WaitingEventsInterrupter(EventInstanceService eventInstanceService, SchedulerService schedulerService, TechnicalLoggerService logger) {
        this.eventInstanceService = eventInstanceService;
        this.schedulerService = schedulerService;
        this.logger = logger;
    }

    public void interruptWaitingEvents(SProcessDefinition processDefinition, SCatchEventInstance catchEventInstance, SCatchEventDefinition catchEventDef) throws SBonitaException {
        this.interruptTimerEvent(processDefinition, catchEventInstance, catchEventDef);
        this.interruptWaitingEvents(catchEventInstance.getId(), catchEventDef);
    }

    private void interruptWaitingEvents(long instanceId, SCatchEventDefinition catchEventDef) throws SBonitaReadException, SWaitingEventModificationException {
        if (!catchEventDef.getEventTriggers().isEmpty()) {
            this.interruptWaitingEvents(instanceId, SWaitingEvent.class);
        }
    }

    public void interruptWaitingEvents(SFlowNodeInstance flowNodeInstance) throws SBonitaException {
        if (flowNodeInstance instanceof SReceiveTaskInstance || flowNodeInstance instanceof SIntermediateCatchEventInstance || flowNodeInstance instanceof SBoundaryEventInstance) {
            this.interruptWaitingEvents(flowNodeInstance.getId(), SWaitingEvent.class);
        }
    }

    private <T extends SWaitingEvent> void interruptWaitingEvents(long instanceId, Class<T> waitingEventClass) throws SBonitaReadException, SWaitingEventModificationException {
        List<T> waitingEvents;
        QueryOptions queryOptions = this.getWaitingEventsQueryOptions(instanceId, waitingEventClass);
        QueryOptions countOptions = this.getWaitingEventsCountOptions(instanceId, waitingEventClass);
        long count = 0L;
        do {
            waitingEvents = this.eventInstanceService.searchWaitingEvents(waitingEventClass, queryOptions);
            count = this.eventInstanceService.getNumberOfWaitingEvents(waitingEventClass, countOptions);
            this.deleteWaitingEvents(waitingEvents);
        } while (count > (long)waitingEvents.size());
    }

    private void deleteWaitingEvents(List<? extends SWaitingEvent> waitingEvents) throws SWaitingEventModificationException {
        for (SWaitingEvent sWaitingEvent : waitingEvents) {
            this.eventInstanceService.deleteWaitingEvent(sWaitingEvent);
        }
    }

    private QueryOptions getWaitingEventsCountOptions(long instanceId, Class<? extends SWaitingEvent> waitingEventClass) {
        List<FilterOption> filters = this.getFilterForWaitingEventsToInterrupt(instanceId, waitingEventClass);
        return new QueryOptions(filters, null);
    }

    private QueryOptions getWaitingEventsQueryOptions(long instanceId, Class<? extends SWaitingEvent> waitingEventClass) {
        OrderByOption orderByOption = new OrderByOption(waitingEventClass, BuilderFactory.get(SWaitingEventKeyProviderBuilderFactory.class).getIdKey(), OrderByType.ASC);
        List<FilterOption> filters = this.getFilterForWaitingEventsToInterrupt(instanceId, waitingEventClass);
        return new QueryOptions(0, 100, Collections.singletonList(orderByOption), filters, null);
    }

    private List<FilterOption> getFilterForWaitingEventsToInterrupt(long instanceId, Class<? extends SWaitingEvent> waitingEventClass) {
        SWaitingEventKeyProviderBuilderFactory waitingEventKeyProvider = BuilderFactory.get(SWaitingEventKeyProviderBuilderFactory.class);
        ArrayList<FilterOption> filters = new ArrayList<FilterOption>(2);
        filters.add(new FilterOption(waitingEventClass, waitingEventKeyProvider.getFlowNodeInstanceIdKey(), instanceId));
        filters.add(new FilterOption(waitingEventClass, waitingEventKeyProvider.getActiveKey(), true));
        return filters;
    }

    private void interruptTimerEvent(SProcessDefinition processDefinition, SCatchEventInstance catchEventInstance, SCatchEventDefinition catchEventDef) throws SSchedulerException {
        String jobName;
        boolean delete;
        if (!catchEventDef.getTimerEventTriggerDefinitions().isEmpty() && !(delete = this.schedulerService.delete(jobName = JobNameBuilder.getTimerEventJobName(processDefinition.getId(), catchEventDef, catchEventInstance))) && this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "No job found with name '" + jobName + "' when interrupting timer catch event named '" + catchEventDef.getName() + "' and id '" + catchEventInstance.getId() + "'. It was probably already triggered.");
        }
    }
}

