/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.state;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.model.impl.BPMInstancesCreator;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.model.SActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SStandardLoopCharacteristics;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityStateExecutionException;
import org.bonitasoft.engine.core.process.instance.api.states.FlowNodeState;
import org.bonitasoft.engine.core.process.instance.api.states.StateCode;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SFlowElementsContainerType;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SLoopActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SStateCategory;
import org.bonitasoft.engine.core.process.instance.model.builder.SLoopActivityInstanceBuilderFactory;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.execution.ContainerRegistry;
import org.bonitasoft.engine.expression.ExpressionConstants;

public class ExecutingLoopActivityStateImpl
implements FlowNodeState {
    private final ExpressionResolverService expressionResolverService;
    private final BPMInstancesCreator bpmInstancesCreator;
    private final ContainerRegistry containerRegistry;
    private final ActivityInstanceService activityInstanceService;

    public ExecutingLoopActivityStateImpl(ExpressionResolverService expressionResolverService, BPMInstancesCreator bpmInstancesCreator, ContainerRegistry containerRegistry, ActivityInstanceService activityInstanceService) {
        this.expressionResolverService = expressionResolverService;
        this.bpmInstancesCreator = bpmInstancesCreator;
        this.containerRegistry = containerRegistry;
        this.activityInstanceService = activityInstanceService;
    }

    @Override
    public StateCode execute(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) {
        return StateCode.DONE;
    }

    @Override
    public int getId() {
        return 24;
    }

    @Override
    public boolean isInterrupting() {
        return false;
    }

    @Override
    public boolean isStable() {
        return true;
    }

    @Override
    public boolean isTerminal() {
        return false;
    }

    @Override
    public String getName() {
        return "executing";
    }

    @Override
    public boolean hit(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance, SFlowNodeInstance childInstance) throws SActivityStateExecutionException {
        try {
            SLoopActivityInstance loopActivity = (SLoopActivityInstance)this.activityInstanceService.getFlowNodeInstance(flowNodeInstance.getId());
            if (loopActivity.getStateCategory() != SStateCategory.NORMAL) {
                return true;
            }
            SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
            SActivityDefinition activity = (SActivityDefinition)processContainer.getFlowNode(flowNodeInstance.getFlowNodeDefinitionId());
            SStandardLoopCharacteristics loopCharacteristics = (SStandardLoopCharacteristics)activity.getLoopCharacteristics();
            boolean loop = false;
            int loopCounter = loopActivity.getLoopCounter();
            if (loopActivity.getLoopMax() > 0 && loopCounter >= loopActivity.getLoopMax()) {
                return true;
            }
            SStandardLoopCharacteristics standardLoop = loopCharacteristics;
            HashMap<String, Serializable> input = new HashMap<String, Serializable>(1);
            input.put(ExpressionConstants.LOOP_COUNTER.getEngineConstantName(), Integer.valueOf(loopActivity.getLoopCounter()));
            SExpressionContext sExpressionContext = new SExpressionContext((Long)loopActivity.getId(), DataInstanceContainer.ACTIVITY_INSTANCE.name(), (Map<String, Serializable>)input);
            sExpressionContext.setProcessDefinitionId(loopActivity.getProcessDefinitionId());
            loop = (Boolean)this.expressionResolverService.evaluate(standardLoop.getLoopCondition(), sExpressionContext);
            if (loop) {
                SLoopActivityInstanceBuilderFactory keyProvider = BuilderFactory.get(SLoopActivityInstanceBuilderFactory.class);
                long rootProcessInstanceId = flowNodeInstance.getLogicalGroup(keyProvider.getRootProcessInstanceIndex());
                long parentProcessInstanceId = flowNodeInstance.getLogicalGroup(keyProvider.getParentProcessInstanceIndex());
                SFlowNodeInstance child = this.bpmInstancesCreator.createFlowNodeInstance(processDefinition.getId(), flowNodeInstance.getRootContainerId(), flowNodeInstance.getId(), SFlowElementsContainerType.FLOWNODE, activity, rootProcessInstanceId, parentProcessInstanceId, true, loopCounter + 1, SStateCategory.NORMAL, -1L);
                this.activityInstanceService.incrementLoopCounter(loopActivity);
                this.activityInstanceService.setTokenCount(loopActivity, loopActivity.getTokenCount() + 1);
                this.containerRegistry.executeFlowNode(processDefinition.getId(), parentProcessInstanceId, child.getId(), null, null);
            }
            return !loop;
        }
        catch (SBonitaException e) {
            throw new SActivityStateExecutionException(e);
        }
    }

    @Override
    public boolean shouldExecuteState(SProcessDefinition processDefinition, SFlowNodeInstance flowNodeInstance) throws SActivityExecutionException {
        try {
            List<SActivityInstance> childrenOfAnActivity = this.activityInstanceService.getChildrenOfAnActivity(flowNodeInstance.getId(), 0, 1);
            if (!childrenOfAnActivity.isEmpty()) {
                this.containerRegistry.executeFlowNode(processDefinition.getId(), flowNodeInstance.getLogicalGroup(3), childrenOfAnActivity.get(0).getId(), null, null);
            }
            return !childrenOfAnActivity.isEmpty();
        }
        catch (SBonitaException e) {
            throw new SActivityExecutionException(e);
        }
    }

    @Override
    public SStateCategory getStateCategory() {
        return SStateCategory.NORMAL;
    }

    @Override
    public boolean mustAddSystemComment(SFlowNodeInstance flowNodeInstance) {
        return false;
    }

    @Override
    public String getSystemComment(SFlowNodeInstance flowNodeInstance) {
        return "";
    }
}

