/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.execution.WaitingEventsInterrupter;
import org.bonitasoft.engine.execution.work.FailedStateSetter;
import org.bonitasoft.engine.execution.work.SetInFailCallable;
import org.bonitasoft.engine.execution.work.TenantAwareBonitaWork;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.transaction.UserTransactionService;

public class ExecuteFlowNodeWork
extends TenantAwareBonitaWork {
    private static final long serialVersionUID = -5873526992671300038L;
    private final long flowNodeInstanceId;
    private final List<SOperation> operations;
    private final SExpressionContext contextDependency;
    private final long processInstanceId;

    ExecuteFlowNodeWork(long flowNodeInstanceId, List<SOperation> operations, SExpressionContext contextDependency, long processInstanceId) {
        this.flowNodeInstanceId = flowNodeInstanceId;
        this.operations = operations;
        this.contextDependency = contextDependency;
        this.processInstanceId = processInstanceId;
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + ": processInstanceId:" + this.processInstanceId + ", flowNodeInstanceId: " + this.flowNodeInstanceId;
    }

    @Override
    public String getRecoveryProcedure() {
        return "call processApi.executeFlowNode(" + this.flowNodeInstanceId + ")";
    }

    @Override
    public void work(Map<String, Object> context) throws Exception {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        tenantAccessor.getFlowNodeExecutor().executeFlowNode(this.flowNodeInstanceId, this.contextDependency, this.operations, this.processInstanceId, null, null);
    }

    @Override
    public void handleFailure(Exception e, Map<String, Object> context) throws Exception {
        TenantServiceAccessor tenantAccessor = this.getTenantAccessor(context);
        UserTransactionService userTransactionService = tenantAccessor.getUserTransactionService();
        TechnicalLoggerService loggerService = tenantAccessor.getTechnicalLoggerService();
        WaitingEventsInterrupter waitingEventsInterrupter = new WaitingEventsInterrupter(tenantAccessor.getEventInstanceService(), tenantAccessor.getSchedulerService(), loggerService);
        FailedStateSetter failedStateSetter = new FailedStateSetter(waitingEventsInterrupter, tenantAccessor.getActivityInstanceService(), tenantAccessor.getFlowNodeStateManager(), loggerService);
        userTransactionService.executeInTransaction(new SetInFailCallable(failedStateSetter, this.flowNodeInstanceId));
    }

    public String toString() {
        return "Work[" + this.getDescription() + "]";
    }

    public static enum Type {
        PROCESS,
        FLOWNODE;

    }
}

