/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.expression.ContainerState;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategyProvider;
import org.bonitasoft.engine.expression.ExpressionService;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.impl.ReturnTypeChecker;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.tracking.TimeTracker;

public class ExpressionServiceImpl
implements ExpressionService {
    private final Map<ExpressionKind, ExpressionExecutorStrategy> expressionExecutorsMap;
    private final TechnicalLoggerService logger;
    private boolean checkExpressionReturnType = false;
    private final TimeTracker timeTracker;

    public ExpressionServiceImpl(ExpressionExecutorStrategyProvider expressionExecutorStrategyProvider, TechnicalLoggerService logger, boolean checkExpressionReturnType, TimeTracker timeTracker) {
        List<ExpressionExecutorStrategy> expressionExecutors = expressionExecutorStrategyProvider.getExpressionExecutors();
        this.expressionExecutorsMap = new HashMap<ExpressionKind, ExpressionExecutorStrategy>(expressionExecutors.size());
        this.checkExpressionReturnType = checkExpressionReturnType;
        for (ExpressionExecutorStrategy expressionExecutorStrategy : expressionExecutors) {
            this.expressionExecutorsMap.put(expressionExecutorStrategy.getExpressionKind(), expressionExecutorStrategy);
        }
        this.logger = logger;
        this.timeTracker = timeTracker;
    }

    @Override
    public Object evaluate(SExpression expression, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        return this.evaluate(expression, new HashMap<String, Object>(1), resolvedExpressions, containerState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        boolean isTraceEnable = this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "evaluate"));
        }
        ExpressionExecutorStrategy expressionExecutorStrategy = this.getStrategy(expression.getExpressionKind());
        this.validateExpression(expressionExecutorStrategy, expression);
        Object expressionResult = null;
        long startTime = System.currentTimeMillis();
        try {
            expressionResult = expressionExecutorStrategy.evaluate(expression, dependencyValues, resolvedExpressions, containerState);
        }
        finally {
            if (this.timeTracker.isTrackable("EVALUATE_EXPRESSION")) {
                long endTime = System.currentTimeMillis();
                StringBuilder desc = new StringBuilder();
                desc.append("Expression: ");
                desc.append(expression);
                desc.append(" - ");
                desc.append("dependencyValues: ");
                desc.append(dependencyValues);
                desc.append(" - ");
                desc.append("strategy: ");
                desc.append(expressionExecutorStrategy);
                this.timeTracker.track("EVALUATE_EXPRESSION", desc.toString(), endTime - startTime);
            }
        }
        if (this.mustCheckExpressionReturnType()) {
            new ReturnTypeChecker().checkReturnType(expression, expressionResult, dependencyValues);
        }
        if (isTraceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "evaluate"));
        }
        return expressionResult;
    }

    private void validateExpression(ExpressionExecutorStrategy expressionExecutorStrategy, SExpression expression) throws SInvalidExpressionException {
        try {
            expressionExecutorStrategy.validate(expression);
        }
        catch (SInvalidExpressionException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "evaluate", "Invalid Expression : " + expression.getContent()));
            }
            throw e;
        }
    }

    private ExpressionExecutorStrategy getStrategy(ExpressionKind expressionKind) throws SExpressionTypeUnknownException {
        ExpressionExecutorStrategy expressionExecutorStrategy = this.expressionExecutorsMap.get(expressionKind);
        if (expressionExecutorStrategy == null) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "evaluate", "Unable to find an executor for expression type " + expressionKind));
            }
            throw new SExpressionTypeUnknownException("Unable to find an executor for expression type " + expressionKind);
        }
        return expressionExecutorStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Object> evaluate(ExpressionKind expressionKind, List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions, ContainerState containerState) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "evaluate"));
        }
        ExpressionExecutorStrategy expressionExecutorStrategy = this.getStrategy(expressionKind);
        List<Object> list = null;
        long startTime = System.currentTimeMillis();
        try {
            list = expressionExecutorStrategy.evaluate(expressions, dependencyValues, resolvedExpressions, containerState);
        }
        finally {
            if (this.timeTracker.isTrackable("EVALUATE_EXPRESSIONS")) {
                long endTime = System.currentTimeMillis();
                StringBuilder desc = new StringBuilder();
                desc.append("Expressions: ");
                desc.append(expressions);
                desc.append(" - ");
                desc.append("dependencyValues: ");
                desc.append(dependencyValues);
                desc.append(" - ");
                desc.append("strategy: ");
                desc.append(expressionExecutorStrategy);
                this.timeTracker.track("EVALUATE_EXPRESSIONS", desc.toString(), endTime - startTime);
            }
        }
        if (list == null || list.size() != expressions.size()) {
            String exceptionMessage = "Result list size " + (list == null ? 0 : list.size()) + " is different from expression list size " + expressions.size();
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "evaluate", exceptionMessage));
            }
            throw new SExpressionEvaluationException(exceptionMessage, null);
        }
        if (this.mustCheckExpressionReturnType()) {
            for (int i = 0; i < list.size(); ++i) {
                new ReturnTypeChecker().checkReturnType(expressions.get(i), list.get(i), dependencyValues);
            }
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "evaluate"));
        }
        return list;
    }

    @Override
    public boolean mustCheckExpressionReturnType() {
        return this.checkExpressionReturnType;
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext(ExpressionKind expressionKind) {
        return this.expressionExecutorsMap.get(expressionKind).mustPutEvaluatedExpressionInContext();
    }
}

