/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression.impl.condition;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.expression.impl.condition.BinaryComparator;
import org.bonitasoft.engine.expression.impl.condition.DifferentComparator;
import org.bonitasoft.engine.expression.impl.condition.EqualityComparator;
import org.bonitasoft.engine.expression.impl.condition.EqualsComparator;
import org.bonitasoft.engine.expression.impl.condition.GreaterThanComparator;
import org.bonitasoft.engine.expression.impl.condition.GreaterThanOrEqualsComparator;
import org.bonitasoft.engine.expression.impl.condition.InequalityComparator;
import org.bonitasoft.engine.expression.impl.condition.LessThanComparator;
import org.bonitasoft.engine.expression.impl.condition.LessThanOrEqualsComparator;

public class BinaryComparatorMapper {
    private Map<String, BinaryComparator> evaluators = new HashMap<String, BinaryComparator>();

    public BinaryComparatorMapper(EqualityComparator equalityComparator, InequalityComparator inequalityComparator) {
        this.evaluators.put("==", new EqualsComparator(equalityComparator));
        this.evaluators.put("!=", new DifferentComparator(equalityComparator));
        this.evaluators.put(">", new GreaterThanComparator(inequalityComparator));
        this.evaluators.put(">=", new GreaterThanOrEqualsComparator(inequalityComparator));
        this.evaluators.put("<", new LessThanComparator(inequalityComparator));
        this.evaluators.put("<=", new LessThanOrEqualsComparator(inequalityComparator));
    }

    public BinaryComparator getEvaluator(String operator) {
        return this.evaluators.get(operator);
    }
}

