/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.permission;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.actor.mapping.ActorMappingService;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.system.CommandWithParameters;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.service.TenantServiceAccessor;

public class CanStartProcessDefinition
extends CommandWithParameters {
    private static final String USER_ID_KEY = "USER_ID_KEY";
    private static final String PROCESS_DEFINITION_ID_KEY = "PROCESS_DEFINITION_ID_KEY";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        ActorMappingService actorMappingService = serviceAccessor.getActorMappingService();
        long userId = this.getLongMandadoryParameter(parameters, USER_ID_KEY);
        long processDefinitionId = this.getLongMandadoryParameter(parameters, PROCESS_DEFINITION_ID_KEY);
        try {
            return Boolean.valueOf(actorMappingService.canUserStartProcessDefinition(userId, processDefinitionId));
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException("Error executing command 'Boolean CanStartProcessDefinition(long userId, long processInstanceId)'", e);
        }
    }
}

