/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.log;

import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.session.model.SSession;

public class LogMessageBuilder {
    public static String buildFlowNodeContextMessage(SFlowNodeInstance flowNodeInstance) {
        StringBuilder stb = new StringBuilder();
        stb.append(" [name = <");
        stb.append(flowNodeInstance.getName());
        stb.append(">, display name = <");
        stb.append(flowNodeInstance.getDisplayName());
        stb.append(">, id = <");
        stb.append(flowNodeInstance.getId());
        if (flowNodeInstance.getParentActivityInstanceId() > 0L) {
            stb.append(">, parent activity instance = <");
            stb.append(flowNodeInstance.getParentActivityInstanceId());
        }
        stb.append(">, parent process instance = <");
        stb.append(flowNodeInstance.getParentProcessInstanceId());
        stb.append(">, root process instance = <");
        stb.append(flowNodeInstance.getRootProcessInstanceId());
        stb.append(">, process definition = <");
        stb.append(flowNodeInstance.getProcessDefinitionId());
        stb.append(">]");
        return stb.toString();
    }

    public static String buildExecuteTaskContextMessage(SFlowNodeInstance flowNodeInstance, String username, long executerUserId, long executerSubstituteId) {
        StringBuilder stb = new StringBuilder();
        stb.append("The user <" + username + "> ");
        if (executerUserId != executerSubstituteId) {
            stb.append("acting as delegate of the user with id = <" + executerUserId + "> ");
        }
        stb.append("has executed the task");
        stb.append(LogMessageBuilder.buildFlowNodeContextMessage(flowNodeInstance));
        return stb.toString();
    }

    public static String builUserActionPrefix(SSession session, long starterId) {
        StringBuilder stb = new StringBuilder();
        stb.append("The user <");
        stb.append(session.getUserName());
        stb.append("> ");
        if (starterId != session.getUserId()) {
            stb.append("acting as delegate of the user with id = <");
            stb.append(starterId);
            stb.append("> ");
        }
        return stb.toString();
    }
}

