/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.operation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.LeftOperandHandler;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.data.instance.api.DataInstanceService;
import org.bonitasoft.engine.data.instance.api.ParentContainerResolver;
import org.bonitasoft.engine.data.instance.exception.SDataInstanceException;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.builder.SDataInstanceBuilderFactory;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;

public class DataLeftOperandHandler
implements LeftOperandHandler {
    private static final String DATA_INSTANCE = "%DATA_INSTANCE%_";
    private final DataInstanceService dataInstanceService;
    private final ParentContainerResolver parentContainerResolver;

    public DataLeftOperandHandler(DataInstanceService dataInstanceService, ParentContainerResolver parentContainerResolver) {
        this.dataInstanceService = dataInstanceService;
        this.parentContainerResolver = parentContainerResolver;
    }

    @Override
    public String getType() {
        return "DATA";
    }

    @Override
    public Object update(SLeftOperand leftOperand, Map<String, Object> inputValues, Object newValue, long containerId, String containerType) throws SOperationExecutionException {
        this.updateDataInstance(leftOperand, containerId, containerType, inputValues, newValue);
        return newValue;
    }

    protected void update(SDataInstance sDataInstance, Object content) throws SDataInstanceException {
        EntityUpdateDescriptor updateDescriptor = new EntityUpdateDescriptor();
        SDataInstanceBuilderFactory fact = BuilderFactory.get(SDataInstanceBuilderFactory.class);
        updateDescriptor.addField(fact.getValueKey(), content);
        this.dataInstanceService.updateDataInstance(sDataInstance, updateDescriptor);
    }

    private void checkReturnType(Object value, SDataInstance sDataInstance) throws SOperationExecutionException {
        Class<?> evaluatedReturnedType;
        Class<?> dataEffectiveType;
        Serializable dataValue;
        if (value != null && (dataValue = sDataInstance.getValue()) != null && !(dataEffectiveType = dataValue.getClass()).isAssignableFrom(evaluatedReturnedType = value.getClass()) && !dataEffectiveType.equals(evaluatedReturnedType)) {
            throw new SOperationExecutionException("Incompatible assignment operation type: Left operand " + dataEffectiveType + " is not compatible with right operand " + evaluatedReturnedType + " for expression with name '" + sDataInstance.getName() + "'");
        }
    }

    private void updateDataInstance(SLeftOperand leftOperand, long containerId, String containerType, Map<String, Object> inputValues, Object expressionResult) throws SOperationExecutionException {
        String dataInstanceName = leftOperand.getName();
        try {
            SDataInstance dataInstance = (SDataInstance)inputValues.get(DATA_INSTANCE + dataInstanceName);
            if (dataInstance == null) {
                dataInstance = this.getDataInstance(dataInstanceName, containerId, containerType);
            }
            this.checkReturnType(expressionResult, dataInstance);
            this.update(dataInstance, expressionResult);
        }
        catch (SDataInstanceException e) {
            throw new SOperationExecutionException(e);
        }
    }

    @Override
    public void delete(SLeftOperand leftOperand, long containerId, String containerType) throws SOperationExecutionException {
        throw new SOperationExecutionException("Deleting a data is not supported");
    }

    @Override
    public void loadLeftOperandInContext(SLeftOperand sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) throws SBonitaReadException {
        try {
            this.putInContext(sLeftOperand, expressionContext, contextToSet);
        }
        catch (SDataInstanceException e) {
            throw new SBonitaReadException("Unable to retrieve the data", e);
        }
    }

    private void putInContext(SLeftOperand sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) throws SDataInstanceException {
        String name = sLeftOperand.getName();
        SDataInstance dataInstance = this.getDataInstance(name, expressionContext.getContainerId(), expressionContext.getContainerType());
        this.putDataInContext(contextToSet, dataInstance);
    }

    private void putDataInContext(Map<String, Object> contextToSet, SDataInstance dataInstance) {
        String name = dataInstance.getName();
        contextToSet.put(DATA_INSTANCE + name, dataInstance);
        if (!contextToSet.containsKey(name)) {
            contextToSet.put(name, dataInstance.getValue());
        }
    }

    @Override
    public void loadLeftOperandInContext(List<SLeftOperand> sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) throws SBonitaReadException {
        try {
            ArrayList<String> names = new ArrayList<String>(sLeftOperand.size());
            for (SLeftOperand leftOperand : sLeftOperand) {
                names.add(leftOperand.getName());
            }
            List<SDataInstance> dataInstances = this.dataInstanceService.getDataInstances(names, expressionContext.getContainerId(), expressionContext.getContainerType(), this.parentContainerResolver);
            for (SDataInstance dataInstance : dataInstances) {
                this.putDataInContext(contextToSet, dataInstance);
            }
        }
        catch (SDataInstanceException e) {
            throw new SBonitaReadException("Unable to retrieve the data", e);
        }
    }

    protected SDataInstance getDataInstance(String dataInstanceName, long containerId, String containerType) throws SDataInstanceException {
        return this.dataInstanceService.getDataInstance(dataInstanceName, containerId, containerType, this.parentContainerResolver);
    }
}

