/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.operation;

import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.document.api.DocumentService;
import org.bonitasoft.engine.core.document.api.impl.DocumentHelper;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.operation.AbstractDocumentLeftOperandHandler;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class DocumentLeftOperandHandler
extends AbstractDocumentLeftOperandHandler {
    private final DocumentHelper documentHelper;
    final DocumentService documentService;

    public DocumentLeftOperandHandler(DocumentService documentService, ActivityInstanceService activityInstanceService, SessionAccessor sessionAccessor, SessionService sessionService) {
        super(activityInstanceService, sessionAccessor, sessionService);
        this.documentService = documentService;
        this.documentHelper = new DocumentHelper(documentService, null, null);
    }

    @Override
    public Object update(SLeftOperand sLeftOperand, Map<String, Object> inputValues, Object newValue, long containerId, String containerType) throws SOperationExecutionException {
        DocumentValue documentValue = this.toCheckedDocumentValue(newValue);
        String documentName = sLeftOperand.getName();
        try {
            long processInstanceId = this.getProcessInstanceId(containerId, containerType);
            if (newValue == null) {
                this.documentHelper.deleteDocument(documentName, processInstanceId);
            } else {
                if (documentValue.getDocumentId() != null && !documentValue.hasChanged()) {
                    return newValue;
                }
                this.documentHelper.createOrUpdateDocument(documentValue, documentName, processInstanceId, this.getAuthorId());
            }
            return newValue;
        }
        catch (SBonitaException e) {
            throw new SOperationExecutionException(e);
        }
    }

    @Override
    public String getType() {
        return "DOCUMENT";
    }

    @Override
    public void delete(SLeftOperand leftOperand, long containerId, String containerType) throws SOperationExecutionException {
        throw new SOperationExecutionException("Deleting a document is not supported");
    }

    @Override
    public void loadLeftOperandInContext(SLeftOperand sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) {
    }

    @Override
    public void loadLeftOperandInContext(List<SLeftOperand> sLeftOperand, SExpressionContext expressionContext, Map<String, Object> contextToSet) throws SBonitaReadException {
        for (SLeftOperand leftOperand : sLeftOperand) {
            this.loadLeftOperandInContext(leftOperand, expressionContext, contextToSet);
        }
    }
}

