/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.profile;

import java.util.List;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.profile.ProfileMember;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.model.SProfileMember;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchEntityDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;

public class SearchProfileMembersForProfile
extends AbstractSearchEntity<ProfileMember, SProfileMember> {
    private final ProfileService profileService;
    private final String querySuffix;

    public SearchProfileMembersForProfile(String querySuffix, ProfileService profileService, SearchEntityDescriptor searchDescriptor, SearchOptions searchOptions) {
        super(searchDescriptor, searchOptions);
        this.querySuffix = querySuffix;
        this.profileService = profileService;
    }

    @Override
    public long executeCount(QueryOptions searchOptions) throws SBonitaReadException {
        return this.profileService.getNumberOfProfileMembers(this.querySuffix, searchOptions);
    }

    @Override
    public List<SProfileMember> executeSearch(QueryOptions searchOptions) throws SBonitaReadException {
        return this.profileService.searchProfileMembers(this.querySuffix, searchOptions);
    }

    @Override
    public List<ProfileMember> convertToClientObjects(List<SProfileMember> serverObjects) {
        return ModelConvertor.toProfileMembers(serverObjects);
    }
}

