/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.xml.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.xml.ElementBinding;
import org.bonitasoft.engine.xml.ElementBindingsFactory;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.SInvalidSchemaException;
import org.bonitasoft.engine.xml.SValidationException;
import org.bonitasoft.engine.xml.SXMLParseException;
import org.bonitasoft.engine.xml.XMLSchemaValidator;
import org.bonitasoft.engine.xml.parse.BindingHandler;
import org.bonitasoft.engine.xml.parse.LogErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXParser
implements Parser {
    private static final String UTF_8 = "UTF-8";
    private List<Class<? extends ElementBinding>> bindings;
    private final XMLSchemaValidator validator;
    private final TechnicalLoggerService logger;
    private ElementBindingsFactory bindingsFactory;

    public SAXParser(XMLSchemaValidator validator, TechnicalLoggerService logger) {
        this.validator = validator;
        this.logger = logger;
    }

    @Override
    public Object getObjectFromXML(URI xmlURI) throws SXMLParseException, IOException {
        File xmlFile = new File(xmlURI);
        return this.getObjectFromXML(xmlFile);
    }

    @Override
    public Object getObjectFromXML(String pathname) throws SXMLParseException, IOException {
        File xmlFile = new File(pathname);
        return this.getObjectFromXML(xmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectFromXML(File xmlFile) throws SXMLParseException, IOException {
        FileInputStream fileInputStream = new FileInputStream(xmlFile);
        try {
            Object object = this.getObjectFromXML(fileInputStream);
            return object;
        }
        finally {
            fileInputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectFromXML(InputStream xmlStream) throws SXMLParseException, IOException {
        InputStreamReader xmlInputStreamReader = new InputStreamReader(xmlStream, Charset.forName(UTF_8));
        try {
            Object object = this.getObjectFromXML(xmlInputStreamReader);
            return object;
        }
        finally {
            xmlInputStreamReader.close();
        }
    }

    @Override
    public Object getObjectFromXML(Reader xmlReader) throws SXMLParseException, IOException {
        BindingHandler handler = this.getBinders() != null ? new BindingHandler(this.getBinders()) : new BindingHandler(this.bindingsFactory);
        LogErrorHandler errorhandler = new LogErrorHandler(this.logger);
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(handler);
            reader.setErrorHandler(errorhandler);
            InputSource xmlInputSource = new InputSource(xmlReader);
            reader.parse(xmlInputSource);
            return handler.getModel();
        }
        catch (SAXException e) {
            throw new SXMLParseException(e);
        }
    }

    @Override
    public List<Class<? extends ElementBinding>> getBinders() {
        return this.bindings;
    }

    @Override
    public void setBindings(List<Class<? extends ElementBinding>> bindings) {
        this.bindings = bindings;
    }

    @Override
    public void setSchema(InputStream xsdInputStream) throws SInvalidSchemaException {
        this.validator.setSchema(new StreamSource(xsdInputStream));
    }

    @Override
    public void validate(Reader xmlReader) throws SValidationException, IOException {
        this.validator.validate(xmlReader);
    }

    @Override
    public void validate(URI xmlURI) throws SValidationException, IOException {
        File xmlFile = new File(xmlURI);
        this.validate(xmlFile);
    }

    @Override
    public void validate(String pathname) throws SValidationException, IOException {
        File xmlFile = new File(pathname);
        this.validate(xmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(File xmlFile) throws SValidationException, IOException {
        FileReader xmlReader = new FileReader(xmlFile);
        try {
            this.validate(xmlReader);
        }
        finally {
            xmlReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(InputStream xmlStream) throws SValidationException, IOException {
        InputStreamReader xmlInputStreamReader = new InputStreamReader(xmlStream, Charset.forName("utf-8"));
        try {
            this.validate(xmlInputStreamReader);
        }
        finally {
            xmlInputStreamReader.close();
        }
    }

    public void setBindingsFactory(ElementBindingsFactory bindingsFactory) {
        this.bindingsFactory = bindingsFactory;
    }
}

