CREATE TABLE QRTZ_CALENDARS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  CALENDAR_NAME VARCHAR2 (200)  NOT NULL ,
  CALENDAR BLOB NOT NULL
);

CREATE TABLE QRTZ_CRON_TRIGGERS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  TRIGGER_NAME VARCHAR2 (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR2 (200)  NOT NULL ,
  CRON_EXPRESSION VARCHAR2 (120)  NOT NULL ,
  TIME_ZONE_ID VARCHAR2 (80) 
);

CREATE TABLE QRTZ_FIRED_TRIGGERS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  ENTRY_ID VARCHAR2 (95)  NOT NULL ,
  TRIGGER_NAME VARCHAR2 (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR2 (200)  NOT NULL ,
  INSTANCE_NAME VARCHAR2 (200)  NOT NULL ,
  FIRED_TIME NUMBER(19, 0) NOT NULL ,
  SCHED_TIME NUMBER(19, 0) NOT NULL ,
  PRIORITY NUMBER(10, 0) NOT NULL ,
  STATE VARCHAR2 (16)  NOT NULL,
  JOB_NAME VARCHAR2 (200)  NULL ,
  JOB_GROUP VARCHAR2 (200)  NULL ,
  IS_NONCONCURRENT NUMBER(1)  NULL ,
  REQUESTS_RECOVERY NUMBER(1)  NULL 
);

CREATE TABLE QRTZ_PAUSED_TRIGGER_GRPS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  TRIGGER_GROUP VARCHAR2 (200)  NOT NULL 
);

CREATE TABLE QRTZ_SCHEDULER_STATE (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  INSTANCE_NAME VARCHAR2 (200)  NOT NULL ,
  LAST_CHECKIN_TIME NUMBER(19, 0) NOT NULL ,
  CHECKIN_INTERVAL NUMBER(19, 0) NOT NULL
);

CREATE TABLE QRTZ_LOCKS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  LOCK_NAME VARCHAR2 (40)  NOT NULL 
);

CREATE TABLE QRTZ_JOB_DETAILS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  JOB_NAME VARCHAR2 (200)  NOT NULL ,
  JOB_GROUP VARCHAR2 (200)  NOT NULL ,
  DESCRIPTION VARCHAR2 (250) NULL ,
  JOB_CLASS_NAME VARCHAR2 (250)  NOT NULL ,
  IS_DURABLE NUMBER(1)  NOT NULL ,
  IS_NONCONCURRENT NUMBER(1)  NOT NULL ,
  IS_UPDATE_DATA NUMBER(1)  NOT NULL ,
  REQUESTS_RECOVERY NUMBER(1)  NOT NULL ,
  JOB_DATA BLOB NULL
);

CREATE TABLE QRTZ_SIMPLE_TRIGGERS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  TRIGGER_NAME VARCHAR2 (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR2 (200)  NOT NULL ,
  REPEAT_COUNT NUMBER(19, 0) NOT NULL ,
  REPEAT_INTERVAL NUMBER(19, 0) NOT NULL ,
  TIMES_TRIGGERED NUMBER(19, 0) NOT NULL
);

CREATE TABLE qrtz_simprop_triggers
  (          
    SCHED_NAME VARCHAR2(120) NOT NULL,
    TRIGGER_NAME VARCHAR2(200) NOT NULL,
    TRIGGER_GROUP VARCHAR2(200) NOT NULL,
    STR_PROP_1 VARCHAR2(512) NULL,
    STR_PROP_2 VARCHAR2(512) NULL,
    STR_PROP_3 VARCHAR2(512) NULL,
    INT_PROP_1 NUMBER(10, 0) NULL,
    INT_PROP_2 NUMBER(10, 0) NULL,
    LONG_PROP_1 NUMBER(19, 0) NULL,
    LONG_PROP_2 NUMBER(19, 0) NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 NUMBER(1) NULL,
    BOOL_PROP_2 NUMBER(1) NULL
);

CREATE TABLE QRTZ_BLOB_TRIGGERS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  TRIGGER_NAME VARCHAR2 (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR2 (200)  NOT NULL ,
  BLOB_DATA BLOB NULL
);

CREATE TABLE QRTZ_TRIGGERS (
  SCHED_NAME VARCHAR2(120) NOT NULL,
  TRIGGER_NAME VARCHAR2 (200)  NOT NULL ,
  TRIGGER_GROUP VARCHAR2 (200)  NOT NULL ,
  JOB_NAME VARCHAR2 (200)  NOT NULL ,
  JOB_GROUP VARCHAR2 (200)  NOT NULL ,
  DESCRIPTION VARCHAR2 (250) NULL ,
  NEXT_FIRE_TIME NUMBER(19, 0) NULL ,
  PREV_FIRE_TIME NUMBER(19, 0) NULL ,
  PRIORITY NUMBER(10, 0) NULL ,
  TRIGGER_STATE VARCHAR2 (16)  NOT NULL ,
  TRIGGER_TYPE VARCHAR2 (8)  NOT NULL ,
  START_TIME NUMBER(19, 0) NOT NULL ,
  END_TIME NUMBER(19, 0) NULL ,
  CALENDAR_NAME VARCHAR2 (200)  NULL ,
  MISFIRE_INSTR SMALLINT NULL ,
  JOB_DATA BLOB NULL
);

ALTER TABLE QRTZ_CALENDARS  ADD
  CONSTRAINT PK_QRTZ_CALENDARS PRIMARY KEY  
  (
    SCHED_NAME,
    CALENDAR_NAME
  );

ALTER TABLE QRTZ_CRON_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_CRON_TRIGGERS PRIMARY KEY  
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_FIRED_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_FIRED_TRIGGERS PRIMARY KEY  
  (
    SCHED_NAME,
    ENTRY_ID
  );

ALTER TABLE QRTZ_PAUSED_TRIGGER_GRPS  ADD
  CONSTRAINT PK_QRTZ_PAUSED_TRIGGER_GRPS PRIMARY KEY  
  (
    SCHED_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_SCHEDULER_STATE  ADD
  CONSTRAINT PK_QRTZ_SCHEDULER_STATE PRIMARY KEY  
  (
    SCHED_NAME,
    INSTANCE_NAME
  );

ALTER TABLE QRTZ_LOCKS  ADD
  CONSTRAINT PK_QRTZ_LOCKS PRIMARY KEY  
  (
    SCHED_NAME,
    LOCK_NAME
  );

ALTER TABLE QRTZ_JOB_DETAILS  ADD
  CONSTRAINT PK_QRTZ_JOB_DETAILS PRIMARY KEY  
  (
    SCHED_NAME,
    JOB_NAME,
    JOB_GROUP
  );

ALTER TABLE QRTZ_SIMPLE_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_SIMPLE_TRIGGERS PRIMARY KEY  
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_SIMPROP_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_SIMPROP_TRIGGERS PRIMARY KEY  
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_TRIGGERS  ADD
  CONSTRAINT PK_QRTZ_TRIGGERS PRIMARY KEY  
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  );

ALTER TABLE QRTZ_CRON_TRIGGERS ADD
  CONSTRAINT FK_QRTZ_CRON_TRIGGERS FOREIGN KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) REFERENCES QRTZ_TRIGGERS (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) ON DELETE CASCADE;


ALTER TABLE QRTZ_SIMPLE_TRIGGERS ADD
  CONSTRAINT FK_QRTZ_SIMPLE_TRIGGERS FOREIGN KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) REFERENCES QRTZ_TRIGGERS (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) ON DELETE CASCADE;

ALTER TABLE QRTZ_SIMPROP_TRIGGERS ADD
  CONSTRAINT FK_QRTZ_SIMPROP_TRIGGERS FOREIGN KEY
  (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) REFERENCES QRTZ_TRIGGERS (
    SCHED_NAME,
    TRIGGER_NAME,
    TRIGGER_GROUP
  ) ON DELETE CASCADE;


ALTER TABLE QRTZ_TRIGGERS ADD
  CONSTRAINT FK_QRTZ_TRIGGERS FOREIGN KEY
  (
    SCHED_NAME,
    JOB_NAME,
    JOB_GROUP
  ) REFERENCES QRTZ_JOB_DETAILS (
    SCHED_NAME,
    JOB_NAME,
    JOB_GROUP
  );
  
COMMIT;
