/**
 * Copyright (C) 2015 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 **/
package org.bonitasoft.engine.supervisor.mapping.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.bonitasoft.engine.persistence.PersistentObject;


@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class SProcessSupervisor implements PersistentObject {

    public static final String ID_KEY = "id";
    public static final String USER_ID_KEY = "userId";
    public static final String GROUP_ID_KEY = "groupId";
    public static final String ROLE_ID_KEY = "roleId";
    public static final String PROCESS_DEF_ID_KEY = "processDefId";
    private long id;
    private long tenantId;
    private long processDefId;
    @Builder.Default
    private long userId = -1;
    @Builder.Default
    private long groupId = -1;
    @Builder.Default
    private long roleId = -1;

    public SProcessSupervisor(final long processDefId) {
        this.processDefId = processDefId;
    }


}
