/**
 * Copyright (C) 2019 Bonitasoft S.A.
 * Bonitasoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 **/
package org.bonitasoft.engine.identity.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.PersistentObjectId;
import org.hibernate.annotations.Filter;

/**
 * @author Baptiste Mesta
 */
@Data
@NoArgsConstructor
@ToString(exclude = "sUser")
@EqualsAndHashCode(exclude = "sUser")
@Builder
@AllArgsConstructor
@Entity
@Table(name = "user_login")
@Filter(name = "tenantFilter")
@IdClass(PersistentObjectId.class)
public class SUserLogin implements PersistentObject {

    @Id
    private long id;
    @Id
    private long tenantId;
    @Column
    private Long lastConnection;
    @OneToOne
    @PrimaryKeyJoinColumn
    private SUser sUser;

    public SUserLogin(Long lastConnection) {
        this.lastConnection = lastConnection;
    }
}
