/**
 * Copyright (C) 2015 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 **/
package org.bonitasoft.engine.profile.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;

/**
 * @author Zhao Na
 * @author Celine Souchet
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(propOrder = {})
public class ExportedProfileMapping {

    @XmlElementWrapper(name = "users")
    @XmlElement(name = "user")
    private List<String> users;
    @XmlElementWrapper(name = "groups")
    @XmlElement(name = "group")
    private List<String> groups;
    @XmlElementWrapper(name = "roles")
    @XmlElement(name = "role")
    private List<String> roles;
    @XmlElementWrapper(name = "memberships")
    @XmlElement(name = "membership")
    private List<ExportedMembership> memberships;

    public ExportedProfileMapping() {
        users = new ArrayList<>();
        groups = new ArrayList<>();
        roles = new ArrayList<>();
        memberships = new ArrayList<>();
    }

    public List<String> getUsers() {
        return users == null ? Collections.<String>emptyList() : users;
    }

    public void setUsers(final List<String> users) {
        this.users = users;
    }

    public List<String> getGroups() {
        return groups == null ? Collections.<String>emptyList() : groups;
    }

    public void setGroups(final List<String> groups) {
        this.groups = groups;
    }

    public List<String> getRoles() {
        return roles == null ? Collections.<String>emptyList() : roles;
    }

    public void setRoles(final List<String> roles) {
        this.roles = roles;
    }

    public List<ExportedMembership> getMemberships() {
        return memberships == null ? Collections.<ExportedMembership>emptyList() : memberships;
    }

    public void setMemberships(final List<ExportedMembership> memberships) {
        this.memberships = memberships;
    }

}
