/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze;

import com.google.inject.Singleton;
import com.strobel.assembler.metadata.DeobfuscationUtilities;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.JarTypeLoader;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.DecompilerSettings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bonitasoft.plugin.analyze.report.model.ActorFilterImplementation;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.ConnectorImplementation;
import org.bonitasoft.plugin.analyze.report.model.Definition;
import org.bonitasoft.plugin.analyze.report.model.DescriptorIdentifier;
import org.bonitasoft.plugin.analyze.report.model.Implementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Named
@Singleton
public class ConnectorResolver {
    public static final String CONNECTOR_TYPE = "org/bonitasoft/engine/connector/Connector";
    public static final String FILTER_TYPE = "org/bonitasoft/engine/filter/UserFilter";
    public static final String ABSTRACT_CONNECTOR_TYPE = "org/bonitasoft/engine/connector/AbstractConnector";
    public static final String ABSTRACT_FILTER_TYPE = "org/bonitasoft/engine/filter/AbstractUserFilter";
    private static final Set<String> FILTER_TYPES = Set.of("org/bonitasoft/engine/filter/UserFilter", "org/bonitasoft/engine/filter/AbstractUserFilter");
    private static final Set<String> CONNECTOR_TYPES = Set.of("org/bonitasoft/engine/connector/Connector", "org/bonitasoft/engine/connector/AbstractConnector");
    private static final Set<String> IMPLEMENTATION_SUPER_TYPES = Set.of("org/bonitasoft/engine/filter/UserFilter", "org/bonitasoft/engine/filter/AbstractUserFilter", "org/bonitasoft/engine/connector/Connector", "org/bonitasoft/engine/connector/AbstractConnector");
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorResolver.class);
    private static final String IMPLEMENTATION_EXTENSION = ".impl";
    private static final String DEFINITION_EXTENSION = ".def";
    private static final String IMPLEMENTATION_NS = "http://www.bonitasoft.org/ns/connector/implementation/6.0";
    private static final String DEFINITION_NS = "http://www.bonitasoft.org/ns/connector/definition/6.1";

    public static String readElement(Document document, String elementName) {
        String textContent = document.getElementsByTagName(elementName).item(0).getTextContent();
        if (textContent != null) {
            textContent = textContent.trim();
        }
        return textContent;
    }

    public List<Implementation> findAllImplementations(org.apache.maven.artifact.Artifact artifact) throws IOException {
        return this.findImplementationDescriptors(artifact.getFile()).stream().map(resource -> {
            Document document = resource.getDocument();
            String className = ConnectorResolver.readElement(document, "implementationClassname");
            String implementationId = ConnectorResolver.readElement(document, "implementationId");
            String implementationVersion = ConnectorResolver.readElement(document, "implementationVersion");
            String definitionId = ConnectorResolver.readElement(document, "definitionId");
            String definitionVersion = ConnectorResolver.readElement(document, "definitionVersion");
            Set<String> hierarchy = this.detectImplementationHierarchy(className, artifact.getFile());
            if (!Collections.disjoint(hierarchy, CONNECTOR_TYPES)) {
                return ConnectorImplementation.create((String)className, (DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (DescriptorIdentifier)new DescriptorIdentifier(implementationId, implementationVersion), (Artifact)ConnectorResolver.create(artifact), (String)resource.getPath());
            }
            if (!Collections.disjoint(hierarchy, FILTER_TYPES)) {
                return ActorFilterImplementation.create((String)className, (DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (DescriptorIdentifier)new DescriptorIdentifier(implementationId, implementationVersion), (Artifact)ConnectorResolver.create(artifact), (String)resource.getPath());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Artifact create(org.apache.maven.artifact.Artifact artifact) {
        return Artifact.create((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (String)artifact.getClassifier(), (String)artifact.getFile().getAbsolutePath());
    }

    public List<Definition> findAllDefinitions(org.apache.maven.artifact.Artifact artifact) throws IOException {
        return this.findDefinitionDescriptors(artifact.getFile()).stream().map(resource -> {
            Document document = resource.getDocument();
            String definitionId = ConnectorResolver.readElement(document, "id");
            String definitionVersion = ConnectorResolver.readElement(document, "version");
            return Definition.create((DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (Artifact)ConnectorResolver.create(artifact), (String)resource.getPath());
        }).collect(Collectors.toList());
    }

    private List<DocumentResource> findImplementationDescriptors(File artifactFile) throws IOException {
        return this.getDocumentResources(artifactFile, IMPLEMENTATION_EXTENSION, IMPLEMENTATION_NS);
    }

    private List<DocumentResource> findDefinitionDescriptors(File artifactFile) throws IOException {
        return this.getDocumentResources(artifactFile, DEFINITION_EXTENSION, DEFINITION_NS);
    }

    private List<DocumentResource> getDocumentResources(File artifactFile, String extension, String namespace) throws IOException {
        return ConnectorResolver.findJarEntries(artifactFile, entry -> entry.getName().endsWith(extension)).stream().map(entry -> this.createDocumentResource(artifactFile, (JarEntry)entry, namespace)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DocumentResource createDocumentResource(File file, JarEntry entry, String implementationNs) {
        try (JarFile jarFile = new JarFile(file);
             InputStream is = jarFile.getInputStream(entry);){
            Document document = this.asXMLDocument(is, implementationNs);
            if (document == null) return null;
            DocumentResource documentResource = new DocumentResource(entry.toString(), document);
            return documentResource;
        }
        catch (IOException e) {
            LOGGER.error(String.format("Failed to read %s in %s.", entry, file), (Throwable)e);
            return null;
        }
    }

    static List<JarEntry> findJarEntries(File file, Predicate<? super JarEntry> entryPredicate) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            List<JarEntry> list = jarFile.stream().filter(entryPredicate).collect(Collectors.toList());
            return list;
        }
    }

    public Set<String> detectImplementationHierarchy(String className, File file) {
        HashSet<String> hierarchy = new HashSet<String>();
        LOGGER.debug("Resolving connector type for {} in {}", (Object)className, (Object)file);
        try (JarFile jarFile = new JarFile(file);){
            JarTypeLoader loader = new JarTypeLoader(jarFile);
            DecompilerSettings decompilerSettings = DecompilerSettings.javaDefaults();
            decompilerSettings.setTypeLoader((ITypeLoader)loader);
            MetadataSystem metadataSystem = new MetadataSystem((ITypeLoader)loader);
            TypeDefinition resolvedType = this.lookupType(className, metadataSystem);
            String superType = null;
            if (resolvedType != null) {
                if (resolvedType.getBaseType() != null) {
                    superType = resolvedType.getBaseType().getInternalName();
                    hierarchy.add(superType);
                }
                resolvedType.getExplicitInterfaces().stream().map(TypeReference::getInternalName).forEach(hierarchy::add);
            }
            while (resolvedType != null && superType != null && !superType.equals("java/lang/Object") && Collections.disjoint(hierarchy, IMPLEMENTATION_SUPER_TYPES)) {
                className = superType;
                LOGGER.debug("Resolving connector type for {} in {}", (Object)className, (Object)jarFile);
                resolvedType = this.lookupType(className, metadataSystem);
                if (resolvedType == null) continue;
                if (resolvedType.getBaseType() != null) {
                    superType = resolvedType.getBaseType().getInternalName();
                    hierarchy.add(superType);
                }
                resolvedType.getExplicitInterfaces().stream().map(TypeReference::getInternalName).forEach(hierarchy::add);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read jar file.", (Throwable)e);
        }
        return hierarchy;
    }

    private TypeDefinition lookupType(String className, MetadataSystem metadataSystem) {
        TypeDefinition resolvedType;
        TypeReference type = metadataSystem.lookupType(this.toTypeFormat(className));
        if (type == null || (resolvedType = type.resolve()) == null) {
            LOGGER.error("Failed to resolved type {}.", (Object)className);
            return null;
        }
        DeobfuscationUtilities.processType((TypeDefinition)resolvedType);
        return resolvedType;
    }

    private String toTypeFormat(String className) {
        return className.replace(".", "/");
    }

    private Document asXMLDocument(InputStream source, String namespace) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(source));
            Node firstChild = document.getFirstChild();
            String namespaceURI = firstChild.getNamespaceURI();
            if (namespace.equals(namespaceURI)) {
                return document;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            return null;
        }
        return null;
    }

    public static class DocumentResource {
        private final String path;
        private final Document document;

        public DocumentResource(String path, Document document) {
            this.path = path;
            this.document = document;
        }

        public String getPath() {
            return this.path;
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

