/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze;

import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Named;
import org.bonitasoft.plugin.analyze.ArtifactAnalyser;
import org.bonitasoft.plugin.analyze.ConnectorResolver;
import org.bonitasoft.plugin.analyze.report.AnalysisResultReportException;
import org.bonitasoft.plugin.analyze.report.model.ActorFilterImplementation;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.ConnectorImplementation;
import org.bonitasoft.plugin.analyze.report.model.CustomPage;
import org.bonitasoft.plugin.analyze.report.model.Definition;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.bonitasoft.plugin.analyze.report.model.Form;
import org.bonitasoft.plugin.analyze.report.model.Implementation;
import org.bonitasoft.plugin.analyze.report.model.Page;
import org.bonitasoft.plugin.analyze.report.model.RestAPIExtension;
import org.bonitasoft.plugin.analyze.report.model.Theme;

@Named
@Singleton
public class DefaultArtifactAnalyser
implements ArtifactAnalyser {
    private final ConnectorResolver connectorResolver;

    @Inject
    public DefaultArtifactAnalyser(ConnectorResolver connectorResolver) {
        this.connectorResolver = connectorResolver;
    }

    @Override
    public DependencyReport analyse(List<org.apache.maven.artifact.Artifact> artifacts) {
        DependencyReport dependencyReport = new DependencyReport();
        artifacts.forEach(artifact -> {
            try {
                this.analyze((org.apache.maven.artifact.Artifact)artifact, dependencyReport);
            }
            catch (IOException e) {
                throw new AnalysisResultReportException("Failed to analyse artifacts: " + artifact.getId(), e);
            }
        });
        return dependencyReport;
    }

    private DependencyReport analyze(org.apache.maven.artifact.Artifact artifact, DependencyReport result) throws IOException {
        File artifactFile = artifact.getFile();
        String fileName = artifactFile.getName();
        if (fileName.endsWith(".jar") && this.hasConnectorDescriptor(artifactFile)) {
            this.analyseConnectorArtifact(artifact, result);
        }
        if (fileName.endsWith(".zip") && this.hasCustomPageDescriptor(artifactFile)) {
            this.analyseCustomPageArtifact(artifact, result);
        }
        return result;
    }

    private void analyseConnectorArtifact(org.apache.maven.artifact.Artifact artifact, DependencyReport result) throws IOException {
        List<Implementation> allImplementations = this.connectorResolver.findAllImplementations(artifact);
        List<Definition> allDefinitions = this.connectorResolver.findAllDefinitions(artifact);
        List<ConnectorImplementation> connectorImplementations = allImplementations.stream().filter(ConnectorImplementation.class::isInstance).map(ConnectorImplementation.class::cast).collect(Collectors.toList());
        List<ActorFilterImplementation> filterImplementations = allImplementations.stream().filter(ActorFilterImplementation.class::isInstance).map(ActorFilterImplementation.class::cast).collect(Collectors.toList());
        allDefinitions.stream().filter(def -> this.hasMatchingImplementation((Definition)def, (List<? extends Implementation>)connectorImplementations)).forEach(arg_0 -> ((DependencyReport)result).addConnectorDefinition(arg_0));
        allDefinitions.stream().filter(def -> this.hasMatchingImplementation((Definition)def, (List<? extends Implementation>)filterImplementations)).forEach(arg_0 -> ((DependencyReport)result).addFilterDefinition(arg_0));
        connectorImplementations.forEach(arg_0 -> ((DependencyReport)result).addConnectorImplementation(arg_0));
        filterImplementations.forEach(arg_0 -> ((DependencyReport)result).addFilterImplementation(arg_0));
    }

    protected boolean hasMatchingImplementation(Definition def, List<? extends Implementation> connectorImplementations) {
        return connectorImplementations.stream().anyMatch(implementation -> Objects.equals(def.getDefinitionId(), implementation.getDefinitionId()) && Objects.equals(def.getDefinitionVersion(), implementation.getDefinitionVersion()));
    }

    protected void analyseCustomPageArtifact(org.apache.maven.artifact.Artifact artifact, DependencyReport result) throws IOException {
        Properties properties = this.readPageProperties(artifact.getFile());
        String contentType = properties.getProperty("contentType");
        CustomPage.CustomPageType customPageType = CustomPage.CustomPageType.valueOf((String)contentType.toUpperCase());
        String name = properties.getProperty("name");
        String displayName = properties.getProperty("displayName");
        String description = properties.getProperty("description");
        switch (customPageType) {
            case FORM: {
                result.addForm(Form.create((String)name, (String)displayName, (String)description, (Artifact)DefaultArtifactAnalyser.create(artifact)));
                break;
            }
            case PAGE: {
                result.addPage(Page.create((String)name, (String)displayName, (String)description, (Artifact)DefaultArtifactAnalyser.create(artifact)));
                break;
            }
            case THEME: {
                result.addTheme(Theme.create((String)name, (String)displayName, (String)description, (Artifact)DefaultArtifactAnalyser.create(artifact)));
                break;
            }
            case APIEXTENSION: {
                result.addRestAPIExtension(RestAPIExtension.create((String)name, (String)displayName, (String)description, (Artifact)DefaultArtifactAnalyser.create(artifact)));
                break;
            }
            default: {
                throw new AnalysisResultReportException("Unsupported Custom Page type: " + contentType);
            }
        }
    }

    private static Artifact create(org.apache.maven.artifact.Artifact artifact) {
        return Artifact.create((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getVersion(), (String)artifact.getClassifier(), (String)artifact.getFile().getAbsolutePath());
    }

    protected boolean hasConnectorDescriptor(File artifactFile) throws IOException {
        return DefaultArtifactAnalyser.findJarEntry(artifactFile, entry -> entry.getName().endsWith(".impl")).isPresent();
    }

    protected boolean hasCustomPageDescriptor(File artifactFile) throws IOException {
        return DefaultArtifactAnalyser.findZipEntry(artifactFile, entry -> entry.getName().equals("page.properties")).isPresent();
    }

    private static Optional<? extends ZipEntry> findZipEntry(File file, Predicate<? super ZipEntry> entryPredicate) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Optional<? super ZipEntry> optional = zipFile.stream().filter(entryPredicate).findFirst();
            return optional;
        }
    }

    protected Properties readPageProperties(File artifactFile) throws IOException {
        return DefaultArtifactAnalyser.findZipEntry(artifactFile, entry -> entry.getName().equals("page.properties")).map(entry -> {
            try (ZipFile zipFile = new ZipFile(artifactFile);){
                Properties properties;
                try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream((ZipEntry)entry), StandardCharsets.UTF_8);){
                    Properties prop = new Properties();
                    prop.load(reader);
                    properties = prop;
                }
                return properties;
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).orElseThrow(() -> new IllegalArgumentException(String.format("No page.properties found in %s", artifactFile)));
    }

    static Optional<JarEntry> findJarEntry(File file, Predicate<? super JarEntry> entryPredicate) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Optional<JarEntry> optional = jarFile.stream().filter(entryPredicate).findFirst();
            return optional;
        }
    }
}

