/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.report;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.IOException;
import org.bonitasoft.plugin.analyze.report.AnalysisResultReportException;
import org.bonitasoft.plugin.analyze.report.DependencyReporter;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;

public class JsonDependencyReporter
implements DependencyReporter {
    private final ObjectMapper mapper = new ObjectMapper().findAndRegisterModules().enable(SerializationFeature.INDENT_OUTPUT).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final File outputFile;

    public JsonDependencyReporter(File outputFile) {
        this.outputFile = outputFile;
    }

    @Override
    public void report(DependencyReport dependencyReport) {
        try {
            File parentFile = this.outputFile.getParentFile();
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            }
            this.mapper.writeValue(this.outputFile, (Object)dependencyReport);
        }
        catch (IOException e) {
            throw new AnalysisResultReportException("Failed to generate report", e);
        }
    }
}

