/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.cfr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.maven.artifact.Artifact;
import org.benf.cfr.reader.bytecode.analysis.types.JavaRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.state.ClassFileSourceImpl;
import org.benf.cfr.reader.state.DCCommonState;
import org.benf.cfr.reader.util.AnalysisType;
import org.benf.cfr.reader.util.getopt.GetOptSinkFactory;
import org.benf.cfr.reader.util.getopt.Options;
import org.benf.cfr.reader.util.getopt.OptionsImpl;
import org.bonitasoft.plugin.analyze.ConnectorResolver;
import org.bonitasoft.plugin.analyze.IssueCollector;
import org.bonitasoft.plugin.analyze.report.model.ActorFilterImplementation;
import org.bonitasoft.plugin.analyze.report.model.ConnectorImplementation;
import org.bonitasoft.plugin.analyze.report.model.Definition;
import org.bonitasoft.plugin.analyze.report.model.DescriptorIdentifier;
import org.bonitasoft.plugin.analyze.report.model.Implementation;
import org.bonitasoft.plugin.analyze.report.model.Issue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Named
public class CFRConnectorResolver
implements ConnectorResolver {
    private static final String CONNECTOR_TYPE = "org.bonitasoft.engine.connector.Connector";
    private static final String FILTER_TYPE = "org.bonitasoft.engine.filter.UserFilter";
    private static final String ABSTRACT_CONNECTOR_TYPE = "org.bonitasoft.engine.connector.AbstractConnector";
    private static final String ABSTRACT_FILTER_TYPE = "org.bonitasoft.engine.filter.AbstractUserFilter";
    private static final Set<String> FILTER_TYPES = Set.of("org.bonitasoft.engine.filter.UserFilter", "org.bonitasoft.engine.filter.AbstractUserFilter");
    private static final Set<String> CONNECTOR_TYPES = Set.of("org.bonitasoft.engine.connector.Connector", "org.bonitasoft.engine.connector.AbstractConnector");
    private static final Logger LOGGER = LoggerFactory.getLogger(CFRConnectorResolver.class);
    private static final String IMPLEMENTATION_EXTENSION = ".impl";
    private static final String DEFINITION_EXTENSION = ".def";
    private static final String IMPLEMENTATION_NS = "http://www.bonitasoft.org/ns/connector/implementation/6.0";
    private static final String DEFINITION_NS = "http://www.bonitasoft.org/ns/connector/definition/6.1";

    private static String readElement(Document document, String elementName) {
        String textContent = document.getElementsByTagName(elementName).item(0).getTextContent();
        if (textContent != null) {
            textContent = textContent.trim();
        }
        return textContent;
    }

    @Override
    public List<Implementation> findAllImplementations(Artifact artifact, IssueCollector issueCollector) throws IOException {
        return this.findImplementationDescriptors(artifact, issueCollector).stream().map(resource -> {
            Document document = resource.getDocument();
            String className = CFRConnectorResolver.readElement(document, "implementationClassname");
            String implementationId = CFRConnectorResolver.readElement(document, "implementationId");
            String implementationVersion = CFRConnectorResolver.readElement(document, "implementationVersion");
            String definitionId = CFRConnectorResolver.readElement(document, "definitionId");
            String definitionVersion = CFRConnectorResolver.readElement(document, "definitionVersion");
            Set<String> hierarchy = this.detectImplementationHierarchy(className, artifact, resource.getPath(), issueCollector);
            if (!Collections.disjoint(hierarchy, CONNECTOR_TYPES)) {
                return ConnectorImplementation.create((String)className, (DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (DescriptorIdentifier)new DescriptorIdentifier(implementationId, implementationVersion), (org.bonitasoft.plugin.analyze.report.model.Artifact)CFRConnectorResolver.create(artifact), (String)resource.getPath());
            }
            if (!Collections.disjoint(hierarchy, FILTER_TYPES)) {
                return ActorFilterImplementation.create((String)className, (DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (DescriptorIdentifier)new DescriptorIdentifier(implementationId, implementationVersion), (org.bonitasoft.plugin.analyze.report.model.Artifact)CFRConnectorResolver.create(artifact), (String)resource.getPath());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static org.bonitasoft.plugin.analyze.report.model.Artifact create(Artifact artifact) {
        return org.bonitasoft.plugin.analyze.report.model.Artifact.create((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)(artifact.getBaseVersion() == null ? artifact.getVersion() : artifact.getBaseVersion()), (String)artifact.getClassifier(), (String)artifact.getFile().getAbsolutePath());
    }

    @Override
    public List<Definition> findAllDefinitions(Artifact artifact, IssueCollector issueCollector) throws IOException {
        return this.findDefinitionDescriptors(artifact, issueCollector).stream().map(resource -> {
            Document document = resource.getDocument();
            String definitionId = CFRConnectorResolver.readElement(document, "id");
            String definitionVersion = CFRConnectorResolver.readElement(document, "version");
            return Definition.create((DescriptorIdentifier)new DescriptorIdentifier(definitionId, definitionVersion), (org.bonitasoft.plugin.analyze.report.model.Artifact)CFRConnectorResolver.create(artifact), (String)resource.getPath());
        }).collect(Collectors.toList());
    }

    private List<DocumentResource> findImplementationDescriptors(Artifact artifact, IssueCollector issueCollector) throws IOException {
        return this.getDocumentResources(artifact, IMPLEMENTATION_EXTENSION, IMPLEMENTATION_NS, issueCollector);
    }

    private List<DocumentResource> findDefinitionDescriptors(Artifact artifact, IssueCollector issueCollector) throws IOException {
        return this.getDocumentResources(artifact, DEFINITION_EXTENSION, DEFINITION_NS, issueCollector);
    }

    private List<DocumentResource> getDocumentResources(Artifact artifact, String extension, String namespace, IssueCollector issueCollector) throws IOException {
        return CFRConnectorResolver.findJarEntries(artifact.getFile(), entry -> entry.getName().endsWith(extension)).stream().map(entry -> this.createDocumentResource(artifact, (JarEntry)entry, namespace, issueCollector)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DocumentResource createDocumentResource(Artifact artifact, JarEntry entry, String implementationNs, IssueCollector issueCollector) {
        try (JarFile jarFile = new JarFile(artifact.getFile());
             InputStream is = jarFile.getInputStream(entry);){
            Document document = this.asXMLDocument(is, implementationNs);
            if (document != null) {
                DocumentResource documentResource = new DocumentResource(entry.toString(), document);
                return documentResource;
            }
            issueCollector.addIssue(Issue.create((Issue.Type)Issue.Type.INVALID_DESCRIPTOR_FILE, (String)String.format("%s is not compliant with '%s' XML schema definition", entry, implementationNs), (Issue.Severity)Issue.Severity.ERROR, (String[])new String[]{artifact.getId()}));
            return null;
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("Failed to parser connector descriptor", (Throwable)e);
            return null;
        }
        catch (SAXException e) {
            issueCollector.addIssue(Issue.create((Issue.Type)Issue.Type.INVALID_DESCRIPTOR_FILE, (String)String.format("%s is not a valid XML file: %s", entry, e.toString()), (Issue.Severity)Issue.Severity.ERROR, (String[])new String[]{artifact.getId()}));
            return null;
        }
        catch (IOException e) {
            LOGGER.error("Failed to read {} in {}.", new Object[]{entry, artifact.getFile(), e});
        }
        return null;
    }

    static List<JarEntry> findJarEntries(File file, Predicate<? super JarEntry> entryPredicate) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            List<JarEntry> list = jarFile.stream().filter(entryPredicate).collect(Collectors.toList());
            return list;
        }
    }

    private ClassFile loadClassFile(DCCommonState dcCommonState, Map<Integer, List<JavaTypeInstance>> loadedTypes, String className) throws ClassNotFoundException {
        return loadedTypes.values().stream().flatMap(Collection::stream).filter(type -> Objects.equals(className, type.toString())).map(dcCommonState::getClassFile).findFirst().orElseThrow(() -> new ClassNotFoundException(className));
    }

    private Set<String> detectImplementationHierarchy(String className, Artifact artifact, String resourcePath, IssueCollector issueCollector) {
        HashSet<String> hierarchy = new HashSet<String>();
        File file = artifact.getFile();
        LOGGER.debug("Resolving connector type for {} in {}", (Object)className, (Object)file);
        GetOptSinkFactory<Options> factory = OptionsImpl.getFactory();
        Options options = factory.create(Map.of());
        ClassFileSourceImpl classFileSource = new ClassFileSourceImpl(options);
        classFileSource.informAnalysisRelativePathDetail(null, null);
        DCCommonState dcCommonState = new DCCommonState(options, classFileSource);
        TreeMap<Integer, List<JavaTypeInstance>> types = dcCommonState.explicitlyLoadJar(file.getAbsolutePath(), AnalysisType.JAR);
        try {
            ClassFile classFile = this.loadClassFile(dcCommonState, types, className);
            if (classFile != null) {
                classFile.getBindingSupers().getBoundSuperClasses().keySet().stream().map(JavaRefTypeInstance::getRawName).forEach(hierarchy::add);
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Failed to load class {} from jar {}", new Object[]{className, file, e});
            issueCollector.addIssue(Issue.create((Issue.Type)Issue.Type.INVALID_DESCRIPTOR_FILE, (String)String.format("%s declares an unknown 'implementationClassname': %s", resourcePath, className), (Issue.Severity)Issue.Severity.ERROR, (String[])new String[]{artifact.getId()}));
        }
        return hierarchy;
    }

    private Document asXMLDocument(InputStream source, String namespace) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(source));
        Node firstChild = document.getFirstChild();
        String namespaceURI = firstChild.getNamespaceURI();
        if (namespace.equals(namespaceURI)) {
            return document;
        }
        return null;
    }

    public static class DocumentResource {
        private final String path;
        private final Document document;

        public DocumentResource(String path, Document document) {
            this.path = path;
            this.document = document;
        }

        public String getPath() {
            return this.path;
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

