/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.report;

import org.apache.maven.plugin.logging.Log;
import org.bonitasoft.plugin.analyze.report.DependencyReporter;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.CustomPage;
import org.bonitasoft.plugin.analyze.report.model.Definition;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.bonitasoft.plugin.analyze.report.model.Implementation;
import org.bonitasoft.plugin.analyze.report.model.Issue;

public class LogDependencyReporter
implements DependencyReporter {
    private final Log log;

    public LogDependencyReporter(Log log) {
        this.log = log;
    }

    private static String asString(CustomPage customPage) {
        return customPage.getName() + LogDependencyReporter.asStringLocation(customPage.getArtifact());
    }

    private static String asStringLocation(Artifact artifact) {
        return " in " + artifact;
    }

    private static String asString(Definition definition) {
        return definition.getDefinitionId() + "-" + definition.getDefinitionVersion() + LogDependencyReporter.asStringLocation(definition.getArtifact());
    }

    private static String asString(Implementation implementation) {
        return implementation.getImplementationId() + "-" + implementation.getImplementationVersion() + " for " + implementation.getDefinitionId() + "-" + implementation.getDefinitionVersion() + LogDependencyReporter.asStringLocation(implementation.getArtifact());
    }

    @Override
    public void report(DependencyReport dependencyReport) {
        dependencyReport.getIssues().stream().filter(issue -> Issue.Severity.valueOf((String)issue.getSeverity()) == Issue.Severity.ERROR).forEach(issue -> this.log.error((CharSequence)issue.getMessage()));
        dependencyReport.getIssues().stream().filter(issue -> Issue.Severity.valueOf((String)issue.getSeverity()) == Issue.Severity.WARNING).forEach(issue -> this.log.warn((CharSequence)issue.getMessage()));
        dependencyReport.getIssues().stream().filter(issue -> Issue.Severity.valueOf((String)issue.getSeverity()) == Issue.Severity.INFO).forEach(issue -> this.log.info((CharSequence)issue.getMessage()));
        this.log.info((CharSequence)String.format("=== %s Connector definitions found ===", dependencyReport.getConnectorDefinitions().size()));
        dependencyReport.getConnectorDefinitions().stream().map(LogDependencyReporter::asString).forEach(arg_0 -> ((Log)this.log).info(arg_0));
        this.log.info((CharSequence)String.format("=== %s Connector implementations found ===", dependencyReport.getConnectorImplementations().size()));
        dependencyReport.getConnectorImplementations().stream().map(LogDependencyReporter::asString).forEach(arg_0 -> ((Log)this.log).info(arg_0));
        this.log.info((CharSequence)String.format("=== %s Actor filter definitions found ===", dependencyReport.getFilterDefinitions().size()));
        dependencyReport.getFilterDefinitions().stream().map(LogDependencyReporter::asString).forEach(arg_0 -> ((Log)this.log).info(arg_0));
        this.log.info((CharSequence)String.format("=== %s Actor filter implementations found ===", dependencyReport.getFilterImplementations().size()));
        dependencyReport.getFilterImplementations().stream().map(LogDependencyReporter::asString).forEach(arg_0 -> ((Log)this.log).info(arg_0));
        this.log.info((CharSequence)String.format("=== %s Pages found ===", dependencyReport.getPages().size()));
        dependencyReport.getPages().stream().map(LogDependencyReporter::asString).forEach(arg_0 -> ((Log)this.log).info(arg_0));
        this.log.info((CharSequence)String.format("=== %s Forms found", dependencyReport.getForms().size()));
        dependencyReport.getForms().stream().map(LogDependencyReporter::asString).forEach(arg_0 -> ((Log)this.log).info(arg_0));
        this.log.info((CharSequence)String.format("=== %s Rest API Extensions found ===", dependencyReport.getRestApiExtensions().size()));
        dependencyReport.getRestApiExtensions().stream().map(LogDependencyReporter::asString).forEach(arg_0 -> ((Log)this.log).info(arg_0));
        this.log.info((CharSequence)String.format("=== %s Themes found ===", dependencyReport.getThemes().size()));
        dependencyReport.getThemes().stream().map(LogDependencyReporter::asString).forEach(arg_0 -> ((Log)this.log).info(arg_0));
    }
}

