/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.bdm.module.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.project.MavenProject;
import org.bonitasoft.plugin.bdm.module.BdmModuleGenerator;
import org.bonitasoft.plugin.bdm.module.ModuleGenerationException;

@Named
public class BdmModuleGeneratorImpl
implements BdmModuleGenerator {
    static final String BDM_PARENT_MODULE = "bdm";
    static final String BDM_PARENT_MODULE_SUFFIX = "-bdm-parent";
    static final String MODEL_MODULE_NAME = "model";
    static final String MODEL_MODULE_NAME_SUFFIX = "-bdm-model";
    static final String DAO_CLIENT_MODULE_NAME = "dao-client";
    static final String DAO_CLIENT_MODULE_NAME_SUFFIX = "-bdm-dao-client";
    static final String POM_FILE_NAME = "pom.xml";
    static final String BDM_MODEL_ARTIFACT_ID_PLACEHOLDER = "_BDM_MODEL_ARTIFACT_ID_PLACEHOLDER_";
    private ModelReader modelReader;
    private ModelWriter modelWriter;

    @Inject
    public BdmModuleGeneratorImpl(ModelReader modelReader, ModelWriter modelWriter) {
        this.modelReader = modelReader;
        this.modelWriter = modelWriter;
    }

    @Override
    public Path create(String projectId, MavenProject parentProject) throws ModuleGenerationException {
        Path parentModuleFolder = this.createModule(projectId, parentProject.getModel(), parentProject.getBasedir().toPath().resolve(BDM_PARENT_MODULE), "/bdm.parent.module.xml", BDM_PARENT_MODULE_SUFFIX);
        try {
            Model parentModel = this.modelReader.read(parentModuleFolder.resolve(POM_FILE_NAME).toFile(), null);
            parentModel.setGroupId(parentProject.getGroupId());
            parentModel.setVersion(parentProject.getVersion());
            this.createModule(projectId, parentModel, parentModuleFolder.resolve(MODEL_MODULE_NAME), "/bdm.model.module.xml", MODEL_MODULE_NAME_SUFFIX);
            Path daoClientModule = this.createModule(projectId, parentModel, parentModuleFolder.resolve(DAO_CLIENT_MODULE_NAME), "/bdm.dao.module.xml", DAO_CLIENT_MODULE_NAME_SUFFIX);
            this.updateBdmModelDependency(daoClientModule, projectId + MODEL_MODULE_NAME_SUFFIX);
            Model parentProjectModel = this.modelReader.read(parentProject.getFile(), null);
            if (parentProjectModel.getModules().stream().noneMatch(BDM_PARENT_MODULE::equals)) {
                parentProjectModel.getModules().add(BDM_PARENT_MODULE);
            }
            this.modelWriter.write(parentProject.getFile(), null, parentProjectModel);
        }
        catch (IOException e) {
            throw new ModuleGenerationException("Failed to add bdm module to parent pom.", e);
        }
        return parentModuleFolder;
    }

    private void updateBdmModelDependency(Path daoClientModule, String bdmModelArtifactId) throws IOException {
        File pomFile = daoClientModule.resolve(POM_FILE_NAME).toFile();
        Model model = this.modelReader.read(pomFile, null);
        Dependency dep = model.getDependencies().stream().filter(d -> BDM_MODEL_ARTIFACT_ID_PLACEHOLDER.equals(d.getArtifactId())).findFirst().orElseThrow();
        dep.setArtifactId(bdmModelArtifactId);
        this.modelWriter.write(pomFile, null, model);
    }

    Path createModule(String projectId, Model parent, Path moduleFolder, String templateFileName, String moduleNameSuffix) throws ModuleGenerationException {
        Path modulePom = moduleFolder.resolve(POM_FILE_NAME);
        modulePom.toFile().getParentFile().mkdirs();
        try (InputStream is = BdmModuleGeneratorImpl.class.getResourceAsStream(templateFileName);
             OutputStream os = Files.newOutputStream(modulePom, new OpenOption[0]);){
            Model modelTemplate = this.modelReader.read(is, null);
            modelTemplate.setArtifactId(projectId + moduleNameSuffix);
            Parent parentModel = modelTemplate.getParent();
            parentModel.setGroupId(parent.getGroupId());
            parentModel.setArtifactId(parent.getArtifactId());
            parentModel.setVersion(parent.getVersion());
            this.modelWriter.write(os, null, modelTemplate);
        }
        catch (IOException e) {
            throw new ModuleGenerationException(String.format("Failed to write %s module pom.", moduleFolder.getFileName()), e);
        }
        return moduleFolder;
    }
}

