/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.install;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.inject.Inject;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.ProjectArtifactFactory;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.bonitasoft.plugin.install.InstallFileExecutionException;

@Mojo(name="install", defaultPhase=LifecyclePhase.NONE)
public class InstallProjectStoreMojo
extends AbstractMojo {
    private static final String GROUP_ID = "groupId";
    private static final String VERSION = "version";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String INSTALL_PLUGIN_VERSION = "3.1.0";
    private static final String INSTALL_PLUGIN_GROUP_ID = "org.apache.maven.plugins";
    private static final String INSTALL_PLUGIN_ARTIFACT_ID = "maven-install-plugin";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue=".store", required=true)
    private File projectStore;
    @Component
    private Maven maven;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private PluginVersionResolver pluginVersionResolver;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private File buildDirectory;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    private ModelReader modelReader;
    private ModelWriter modelWriter;
    private ProjectArtifactFactory artifactFactory;

    @Inject
    public InstallProjectStoreMojo(ProjectArtifactFactory artifactFactory, ModelReader modelReader, ModelWriter modelWriter) {
        this.artifactFactory = artifactFactory;
        this.modelReader = modelReader;
        this.modelWriter = modelWriter;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.projectStore.exists()) {
            return;
        }
        Set<Artifact> projectArtifacts = this.getProjectArtifacts();
        for (Artifact artifact : projectArtifacts) {
            File artifactFile = this.findFileInProjectStore(artifact);
            if (!artifactFile.exists()) continue;
            this.installFileToLocalRepository(artifact, artifactFile);
        }
    }

    private void installFileToLocalRepository(Artifact artifact, File artifactFile) throws MojoExecutionException {
        if (artifact.isSnapshot()) {
            try {
                this.installArtifact(artifact, artifactFile);
            }
            catch (InstallFileExecutionException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
        try {
            this.artifactResolver.resolveArtifact(buildingRequest, artifact);
        }
        catch (IllegalArgumentException e) {
            throw new MojoExecutionException(String.format("Failed to resolve artifact %s", artifact), (Exception)e);
        }
        catch (ArtifactResolverException e) {
            try {
                this.installArtifact(artifact, artifactFile);
            }
            catch (InstallFileExecutionException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
    }

    private Set<Artifact> getProjectArtifacts() throws MojoExecutionException {
        try {
            return this.artifactFactory.createArtifacts(this.project);
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private void installArtifact(Artifact artifact, File artifactFile) throws InstallFileExecutionException {
        File pomFile = null;
        try {
            MavenExecutionResult executionResult;
            if (this.shouldCreateDummyPomFile(artifactFile)) {
                pomFile = this.createDummyPomFile(artifact);
            }
            if ((executionResult = this.maven.execute(this.newInstallFileExecutionRequest(artifact, artifactFile, pomFile))).hasExceptions()) {
                throw new InstallFileExecutionException(executionResult.getExceptions());
            }
        }
        catch (IOException e) {
            throw new InstallFileExecutionException("Failed to create artifact a pom file.", e);
        }
        finally {
            try {
                if (pomFile != null) {
                    Files.deleteIfExists(pomFile.toPath());
                }
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldCreateDummyPomFile(File artifactFile) throws IOException {
        Optional<Model> existingPom = this.findPomFile(artifactFile);
        if (existingPom.isPresent()) {
            File pomFile = Files.createTempFile("pom", ".xml", new FileAttribute[0]).toFile();
            try {
                boolean bl;
                FileOutputStream fos = new FileOutputStream(pomFile);
                try {
                    Model model = existingPom.orElseThrow();
                    this.modelWriter.write((OutputStream)fos, null, model);
                    ProjectBuildingRequest buildingRequest = this.newResolveArtifactProjectBuildingRequest();
                    buildingRequest.setProcessPlugins(false);
                    buildingRequest.setResolveDependencies(true);
                    buildingRequest.setValidationLevel(0);
                    ProjectBuildingResult buildingResult = this.projectBuilder.build(pomFile, buildingRequest);
                    DependencyResolutionResult dependencyResolutionResult = buildingResult.getDependencyResolutionResult();
                    bl = !dependencyResolutionResult.getUnresolvedDependencies().isEmpty();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            fos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (ProjectBuildingException e) {
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                fos.close();
                return bl;
            }
            finally {
                Files.deleteIfExists(pomFile.toPath());
            }
        }
        return false;
    }

    static String getExtension(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1 && fileName.length() > index + 1) {
            return fileName.substring(index + 1, fileName.length());
        }
        return null;
    }

    private Optional<Model> findPomFile(File artifactFile) {
        String extension = InstallProjectStoreMojo.getExtension(artifactFile.getName());
        if ("jar".equalsIgnoreCase(extension)) {
            Optional<Model> optional;
            String fileName = artifactFile.getName();
            String fileNameWithoutExtension = fileName.substring(0, fileName.length() - 4);
            JarFile jarFile = new JarFile(artifactFile);
            try {
                optional = jarFile.stream().filter(entry -> entry.getName().matches("META-INF/maven/[^/]*/[^/]*/pom.properties")).map(entry -> {
                    Properties properties;
                    block8: {
                        Properties properties2 = new Properties();
                        InputStream is = jarFile.getInputStream((ZipEntry)entry);
                        try {
                            properties2.load(is);
                            properties = properties2;
                            if (is == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                this.getLog().error((Throwable)e);
                                return null;
                            }
                        }
                        is.close();
                    }
                    return properties;
                }).filter(Objects::nonNull).filter(properties -> {
                    String artifactId = properties.getProperty(ARTIFACT_ID);
                    String version = properties.getProperty(VERSION);
                    return fileNameWithoutExtension.equals(String.format("%s-%s", artifactId, version)) || fileNameWithoutExtension.equals(artifactId);
                }).findFirst().map(pomProperties -> {
                    Model model;
                    block8: {
                        ZipEntry pomEntry = jarFile.getEntry(String.format("META-INF/maven/%s/%s/pom.xml", pomProperties.getProperty(GROUP_ID), pomProperties.getProperty(ARTIFACT_ID)));
                        InputStream is = jarFile.getInputStream(pomEntry);
                        try {
                            model = this.modelReader.read(is, null);
                            if (is == null) break block8;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                this.getLog().error((Throwable)e);
                                return null;
                            }
                        }
                        is.close();
                    }
                    return model;
                });
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Failed to read jar " + artifactFile.getName()), (Throwable)e);
                }
            }
            jarFile.close();
            return optional;
        }
        return Optional.empty();
    }

    private File createDummyPomFile(Artifact artifact) throws IOException {
        File workdir = this.buildDirectory.toPath().resolve("install-plugin-workdir").toFile();
        if (!workdir.exists()) {
            workdir.mkdirs();
        }
        Path pomFile = Files.createTempFile(workdir.toPath(), "pom", ".xml", new FileAttribute[0]);
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(artifact.getGroupId());
        model.setArtifactId(artifact.getArtifactId());
        model.setVersion(artifact.getVersion());
        model.setPackaging(artifact.getType());
        try (OutputStream os = Files.newOutputStream(pomFile, new OpenOption[0]);){
            this.modelWriter.write(os, null, model);
        }
        return pomFile.toFile();
    }

    private File findFileInProjectStore(Artifact artifact) {
        String artifactPath = String.format("%s/%s/%s/%s", artifact.getGroupId().replace(".", "/"), artifact.getArtifactId(), artifact.getVersion(), this.artifactFileName(artifact));
        return this.projectStore.toPath().resolve(Paths.get(artifactPath, new String[0])).toFile();
    }

    private String artifactFileName(Artifact artifact) {
        if (artifact.getClassifier() != null) {
            return String.format("%s-%s-%s.%s", artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), artifact.getType());
        }
        return String.format("%s-%s.%s", artifact.getArtifactId(), artifact.getVersion(), artifact.getType());
    }

    private MavenExecutionRequest newInstallFileExecutionRequest(Artifact artifact, File artifactFile, File pomFile) {
        DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
        executionRequest.setGoals(Arrays.asList(String.format("%s:%s:%s:install-file", INSTALL_PLUGIN_GROUP_ID, INSTALL_PLUGIN_ARTIFACT_ID, INSTALL_PLUGIN_VERSION)));
        executionRequest.setLocalRepository(this.localRepository);
        Properties installFileProperties = new Properties();
        installFileProperties.setProperty(GROUP_ID, artifact.getGroupId());
        installFileProperties.setProperty(ARTIFACT_ID, artifact.getArtifactId());
        installFileProperties.setProperty(VERSION, artifact.getVersion());
        installFileProperties.setProperty("file", artifactFile.getAbsolutePath());
        if (pomFile != null) {
            installFileProperties.setProperty("pomFile", pomFile.getAbsolutePath());
        }
        if (artifact.getClassifier() != null) {
            installFileProperties.setProperty("classifier", artifact.getClassifier());
        }
        installFileProperties.setProperty("packaging", artifact.getType());
        executionRequest.setUserProperties(installFileProperties);
        return executionRequest;
    }

    private ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        return buildingRequest;
    }
}

