/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.bdm.codegen;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.plugin.bdm.codegen.BusinessDataModelGenerator;
import org.bonitasoft.plugin.bdm.codegen.BusinessDataModelParser;
import org.bonitasoft.plugin.bdm.codegen.CodeGenerationException;
import org.bonitasoft.plugin.bdm.codegen.ParseException;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractGenerateBdmMojo
extends AbstractMojo {
    @Parameter(required=true)
    protected File bdmModelFile;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/java")
    protected File outputFolder;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    private BusinessDataModelParser businessDataModelReader;
    private BusinessDataModelGenerator generator;
    private BuildContext buildContext;

    AbstractGenerateBdmMojo(BusinessDataModelParser businessDataModelReader, BusinessDataModelGenerator generator, BuildContext buildContext) {
        this.businessDataModelReader = businessDataModelReader;
        this.generator = generator;
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Stream<Path> files;
        if (this.bdmModelFile == null || !this.bdmModelFile.exists()) {
            this.getLog().info((CharSequence)"Skipping Business Data Model sources generation (no descriptor found)...");
            return;
        }
        String relpath = this.bdmModelFile.toPath().getFileName().toString();
        if (!this.buildContext.hasDelta(relpath)) {
            this.getLog().info((CharSequence)"Skipping Business Data Model sources generation (generated sources are up to date)...");
            return;
        }
        this.getLog().info((CharSequence)"Generating Business Data Model sources...");
        Instant instant = Instant.now();
        BusinessObjectModel model = null;
        try {
            model = this.businessDataModelReader.parse(this.bdmModelFile);
        }
        catch (ParseException e) {
            throw new MojoFailureException("Error while parsing the model descriptor", (Throwable)e);
        }
        if (this.outputFolder.exists()) {
            try {
                files = Files.walk(this.outputFolder.toPath(), new FileVisitOption[0]);
                try {
                    files.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                finally {
                    if (files != null) {
                        files.close();
                    }
                }
            }
            catch (IOException e) {
                throw new MojoFailureException(String.format("Failed to clean output directory: %s", this.outputFolder));
            }
        }
        if (!this.outputFolder.mkdirs()) {
            throw new MojoFailureException(String.format("Failed to create output directory: %s", this.outputFolder));
        }
        try {
            this.generator.generate(model, this.outputFolder.toPath());
        }
        catch (CodeGenerationException e) {
            throw new MojoFailureException("Error while generating bdm model sources", (Throwable)e);
        }
        try {
            files = Files.walk(this.outputFolder.toPath(), new FileVisitOption[0]);
            try {
                files.filter(this.exludedGeneratedSources()).forEach(file -> {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                });
            }
            finally {
                if (files != null) {
                    files.close();
                }
            }
        }
        catch (IOException e) {
            throw new MojoFailureException((Throwable)e);
        }
        this.getLog().info((CharSequence)String.format("Business Data Model model sources generation completed in %s.", Duration.between(Instant.now(), instant)));
        this.buildContext.refresh(this.outputFolder);
    }

    protected abstract Predicate<Path> exludedGeneratedSources();
}

