/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.ProjectArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.InvalidDependencyVersionException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.bonitasoft.plugin.analyze.ArtifactAnalyser;
import org.bonitasoft.plugin.analyze.DependencyValidator;
import org.bonitasoft.plugin.analyze.report.AnalysisResultReportException;
import org.bonitasoft.plugin.analyze.report.DependencyReporter;
import org.bonitasoft.plugin.analyze.report.JsonDependencyReporter;
import org.bonitasoft.plugin.analyze.report.LogDependencyReporter;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="analyze", defaultPhase=LifecyclePhase.NONE)
public class AnalyzeBonitaDependencyMojo
extends AbstractMojo {
    protected final ArtifactResolver artifactResolver;
    protected final ArtifactAnalyser artifactAnalyser;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    protected List<ArtifactRepository> remoteRepositories;
    @Parameter(defaultValue="${project.build.directory}/bonita-dependencies.json", property="bonita.analyze.outputFile")
    protected File outputFile;
    @Parameter(defaultValue="true", property="bonita.validateDependencies")
    protected boolean validateDeps;
    private DependencyValidator dependencyValidator;
    private ProjectArtifactFactory artifactFactory;
    @Parameter(property="includeScope", defaultValue="runtime")
    protected String includeScope = "runtime";
    @Parameter(property="excludeScope", defaultValue="")
    protected String excludeScope;

    @Inject
    public AnalyzeBonitaDependencyMojo(ArtifactResolver artifactResolver, ArtifactAnalyser artifactAnalyser, DependencyValidator dependencyValidator, ProjectArtifactFactory artifactFactory) {
        this.artifactResolver = artifactResolver;
        this.artifactAnalyser = artifactAnalyser;
        this.dependencyValidator = dependencyValidator;
        this.artifactFactory = artifactFactory;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Artifact> resolvedArtifacts;
        ProjectBuildingRequest buildingRequest = this.newProjectBuildingRequest();
        try {
            resolvedArtifacts = this.resolveArtifacts(this.getProjectArtifacts(), buildingRequest);
        }
        catch (MojoExecutionException | ArtifactFilterException e) {
            throw new MojoExecutionException(e);
        }
        DependencyReport dependencyReport = this.artifactAnalyser.analyse(resolvedArtifacts);
        if (this.validateDeps) {
            this.dependencyValidator.validate(this.project, buildingRequest).stream().forEach(arg_0 -> ((DependencyReport)dependencyReport).addIssue(arg_0));
        }
        this.getReporters().forEach(reporter -> reporter.report(dependencyReport));
    }

    private Set<Artifact> getProjectArtifacts() throws MojoExecutionException {
        try {
            return this.artifactFactory.createArtifacts(this.project);
        }
        catch (InvalidDependencyVersionException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    protected List<DependencyReporter> getReporters() {
        ArrayList<DependencyReporter> reporters = new ArrayList<DependencyReporter>();
        reporters.add(new LogDependencyReporter(this.getLog()));
        if (this.outputFile != null) {
            reporters.add(new JsonDependencyReporter(this.outputFile));
        }
        return reporters;
    }

    protected List<Artifact> resolveArtifacts(Set<Artifact> artifacts, ProjectBuildingRequest buildingRequest) throws ArtifactFilterException {
        FilterArtifacts filter = new FilterArtifacts();
        filter.addFilter((ArtifactsFilter)new ScopeFilter(AnalyzeBonitaDependencyMojo.cleanToBeTokenizedString(this.includeScope), AnalyzeBonitaDependencyMojo.cleanToBeTokenizedString(this.excludeScope)));
        return filter.filter(artifacts).stream().map(artifact -> this.resolve(buildingRequest, (Artifact)artifact)).collect(Collectors.toList());
    }

    Artifact resolve(ProjectBuildingRequest buildingRequest, Artifact artifact) {
        try {
            ArtifactResult result = this.artifactResolver.resolveArtifact(buildingRequest, artifact);
            Artifact resolvedArtifact = result.getArtifact();
            File artifactFile = resolvedArtifact.getFile();
            if (artifactFile == null || !artifactFile.exists()) {
                throw new MojoExecutionException(String.format("Failed to resolve artifact %s", artifact));
            }
            return resolvedArtifact;
        }
        catch (Exception e) {
            throw new AnalysisResultReportException(String.format("Failed to analyze artifact %s", artifact), e);
        }
    }

    ProjectBuildingRequest newProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteRepositories);
        buildingRequest.setProject(this.project);
        return buildingRequest;
    }

    static String cleanToBeTokenizedString(String str) {
        String ret = "";
        if (!StringUtils.isEmpty((String)str)) {
            ret = str.trim().replaceAll("[\\s]*,[\\s]*", ",");
        }
        return ret;
    }
}

