/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.bdm.codegen.impl;

import java.nio.file.Path;
import javax.inject.Named;
import org.bonitasoft.engine.bdm.model.BusinessObjectModel;
import org.bonitasoft.engine.business.data.generator.client.ClientBDMCodeGenerator;
import org.bonitasoft.plugin.bdm.codegen.BusinessDataModelGenerator;
import org.bonitasoft.plugin.bdm.codegen.CodeGenerationException;

@Named
public class BusinessDataModelGeneratorImpl
implements BusinessDataModelGenerator {
    @Override
    public void generate(BusinessObjectModel model, Path outputFolder) throws CodeGenerationException {
        if (!outputFolder.toFile().isDirectory()) {
            throw new CodeGenerationException(String.format("Output folder %s must be a directory", outputFolder));
        }
        try {
            System.setProperty("sysprop.bonita.bdm.db.vendor", "h2");
            new ClientBDMCodeGenerator().generateBom(model, outputFolder.toFile());
        }
        catch (Exception e) {
            throw new CodeGenerationException("Failed to generate sources.", e);
        }
    }
}

