/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.bdm.module;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.bonitasoft.plugin.bdm.module.BdmModuleGenerator;
import org.bonitasoft.plugin.bdm.module.DefaultBomFactory;
import org.bonitasoft.plugin.bdm.module.ModuleGenerationException;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="create-bdm-module", defaultPhase=LifecyclePhase.NONE)
public class CreateBdmModuleMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(required=true, property="bonitaProjectId")
    protected String bonitaProjectId;
    private BuildContext buildContext;
    private BdmModuleGenerator moduleGenerator;
    private DefaultBomFactory defaultBomFactory;

    @Inject
    public CreateBdmModuleMojo(BdmModuleGenerator moduleGenerator, DefaultBomFactory defaultBomProvider, BuildContext buildContext) {
        this.moduleGenerator = moduleGenerator;
        this.buildContext = buildContext;
        this.defaultBomFactory = defaultBomProvider;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"pom".equals(this.project.getPackaging()) || !Objects.equals(this.project.getArtifactId(), this.bonitaProjectId + "-parent")) {
            return;
        }
        Instant instant = Instant.now();
        this.getLog().info((CharSequence)"Creating Business Data Model maven modules...");
        try {
            Path modulePath = this.moduleGenerator.create(this.bonitaProjectId, this.project);
            if (!Files.exists(modulePath.resolve("bom.xml"), new LinkOption[0])) {
                this.defaultBomFactory.createDefaultBom(this.project.getGroupId(), modulePath);
            }
            this.buildContext.refresh(modulePath.toFile());
        }
        catch (ModuleGenerationException e) {
            throw new MojoFailureException("Error while generating the Business Data Model maven modules", (Throwable)e);
        }
        catch (IOException ioe) {
            throw new MojoFailureException("Error while generating the default Business Data Model file descriptor", (Throwable)ioe);
        }
        this.getLog().info((CharSequence)String.format("Business Data Model Maven modules generation completed in %s.", Duration.between(Instant.now(), instant)));
    }
}

