/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.CollectingDependencyNodeVisitor;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.bonitasoft.plugin.analyze.DependencyValidator;
import org.bonitasoft.plugin.analyze.report.model.Issue;

@Named
@Singleton
public class IncompatibleDependencyValidator
implements DependencyValidator {
    private static final Set<String> CONFLICTING_ARTIFACTS = Set.of("org.codehaus.groovy:groovy-all:jar", "org.bonitasoft.engine:bonita-server:jar", "com.bonitasoft.engine:bonita-server-sp:jar", "org.bonitasoft.engine:bonita-client:jar", "com.bonitasoft.engine:bonita-client-sp:jar", "org.bonitasoft.engine:bonita-common:jar", "com.bonitasoft.engine:bonita-common-sp:jar", "org.bonitasoft.web:bonita-web-extensions:jar", "com.bonitasoft.web:bonita-web-extensions-sp:jar");
    private DependencyGraphBuilder dependencyGraphBuilder;

    @Inject
    public IncompatibleDependencyValidator(DependencyGraphBuilder dependencyGraphBuilder) {
        this.dependencyGraphBuilder = dependencyGraphBuilder;
    }

    private static boolean isConflictingArtifact(Artifact artifact) {
        return CONFLICTING_ARTIFACTS.contains(String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getType()));
    }

    private String rootNodeId(DependencyNode node, String projectArtifactId) {
        DependencyNode rootNode = node;
        while (rootNode.getParent() != null && rootNode.getParent().getArtifact() != null && !Objects.equals(rootNode.getParent().getArtifact().getId(), projectArtifactId)) {
            rootNode = rootNode.getParent();
        }
        return rootNode.getArtifact().getId();
    }

    @Override
    public List<Issue> validate(MavenProject project, ProjectBuildingRequest projectBuildingRequest) throws MojoExecutionException {
        try {
            DependencyNode dependencyGraph = this.dependencyGraphBuilder.buildDependencyGraph(projectBuildingRequest, (ArtifactFilter)new ScopeArtifactFilter("runtime"));
            final ArrayList conflictingNodes = new ArrayList();
            dependencyGraph.accept((DependencyNodeVisitor)new CollectingDependencyNodeVisitor(){

                public boolean visit(DependencyNode node) {
                    if (IncompatibleDependencyValidator.isConflictingArtifact(node.getArtifact())) {
                        conflictingNodes.add(node);
                    }
                    return super.visit(node);
                }
            });
            return conflictingNodes.stream().map(node -> this.createIssue((DependencyNode)node, project.getArtifact().getId())).collect(Collectors.toList());
        }
        catch (DependencyGraphBuilderException e) {
            throw new MojoExecutionException("Failed to build dependency graph", (Exception)((Object)e));
        }
    }

    private Issue createIssue(DependencyNode node, String projectArtifactId) {
        String nodeId = node.getArtifact().getId();
        String rootId = this.rootNodeId(node, projectArtifactId);
        if (Objects.equals(rootId, nodeId)) {
            return Issue.create((Issue.Type)Issue.Type.INCOMPATIBLE_DEPENDENCY, (String)String.format("%s is conflicting with Bonita provided dependencies.", nodeId), (Issue.Severity)Issue.Severity.ERROR, (String[])new String[]{nodeId});
        }
        return Issue.create((Issue.Type)Issue.Type.INCOMPATIBLE_DEPENDENCY, (String)String.format("%s depends on %s which is conflicting with Bonita provided dependencies.", rootId, nodeId), (Issue.Severity)Issue.Severity.ERROR, (String[])new String[]{rootId, nodeId});
    }
}

