/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.build;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.DefaultArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.bonitasoft.engine.business.application.exporter.ApplicationNodeContainerConverter;
import org.bonitasoft.engine.business.application.xml.ApplicationNodeContainer;
import org.bonitasoft.engine.business.application.xml.ApplicationPageNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Mojo(name="copy-provided-pages", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=true)
public class CopyProvidedPagesMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(CopyProvidedPagesMojo.class);
    protected static final Map<String, DefaultArtifactCoordinate> PROVIDED_PAGES = Map.of("custompage_tasklist", CopyProvidedPagesMojo.buildPageArtifactCoordinate("page-user-task-list"), "custompage_processlistBonita", CopyProvidedPagesMojo.buildPageArtifactCoordinate("page-user-process-list"), "custompage_userCaseListBonita", CopyProvidedPagesMojo.buildPageArtifactCoordinate("page-user-case-list"), "custompage_userCaseDetailsBonita", CopyProvidedPagesMojo.buildPageArtifactCoordinate("page-user-case-details"));
    private static final String APPLICATION_SOURCE_DIR = "applications/";
    private static final String PAGE_GROUP_ID = "org.bonitasoft.web.page";
    private static final String PAGE_EXTENSION = "zip";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Parameter(defaultValue="${project.build.directory}/provided-pages", readonly=true, required=true)
    protected File outputFolder;
    private final ArtifactResolver artifactResolver;
    private final ApplicationNodeContainerConverter converter = new ApplicationNodeContainerConverter();

    @Inject
    public CopyProvidedPagesMojo(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<DefaultArtifactCoordinate> providedPages;
        if (this.outputFolder.exists()) {
            try {
                FileUtils.deleteDirectory((File)this.outputFolder);
            }
            catch (IOException e) {
                throw new MojoExecutionException(String.format("Failed to clean output directory: %s", this.outputFolder), (Exception)e);
            }
        }
        if ((providedPages = this.detectProvidedPages()).isEmpty()) {
            log.debug("No provided pages detected");
            return;
        }
        try {
            Files.createDirectories(this.outputFolder.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Failed to create output directory: %s", this.outputFolder), (Exception)e);
        }
        for (ArtifactCoordinate artifactCoordinate : providedPages) {
            this.copyArtifact(artifactCoordinate);
        }
    }

    protected List<DefaultArtifactCoordinate> detectProvidedPages() throws MojoFailureException {
        List<DefaultArtifactCoordinate> list;
        block9: {
            Path appSourceDir = this.project.getBasedir().toPath().resolve(APPLICATION_SOURCE_DIR);
            if (!Files.exists(appSourceDir, new LinkOption[0]) || !Files.isDirectory(appSourceDir, new LinkOption[0])) {
                log.debug("Applications source directory [{}] does not exist or is not a directory", (Object)appSourceDir);
                return Collections.emptyList();
            }
            log.info("Detecting provided pages usage in applications...");
            Stream<Path> sourcePaths = Files.list(appSourceDir);
            try {
                List<DefaultArtifactCoordinate> providedPages = sourcePaths.filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().matches("^.*\\.xml$")).map(this::toApplicationContainerNode).filter(Objects::nonNull).flatMap(this::listPages).filter(PROVIDED_PAGES::containsKey).distinct().map(PROVIDED_PAGES::get).map(this::setArtifactVersion).collect(Collectors.toList());
                log.info("Found the usage of {} provided pages", (Object)providedPages.size());
                log.debug("Page artifacts coordinates: {}", providedPages);
                list = providedPages;
                if (sourcePaths == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (sourcePaths != null) {
                        try {
                            sourcePaths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MojoFailureException(String.format("Failed to list files in directory: %s", appSourceDir), (Throwable)e);
                }
            }
            sourcePaths.close();
        }
        return list;
    }

    protected ApplicationNodeContainer toApplicationContainerNode(Path file) {
        try {
            return this.converter.unmarshallFromXML(Files.readAllBytes(file));
        }
        catch (IOException | JAXBException | SAXException e) {
            log.warn("Cannot parse {}. File skipped from provided page detection.", (Object)file);
            return null;
        }
    }

    protected Stream<String> listPages(ApplicationNodeContainer applicationNode) {
        return applicationNode.getApplications().stream().flatMap(application -> application.getApplicationPages().stream().map(ApplicationPageNode::getCustomPage));
    }

    protected DefaultArtifactCoordinate setArtifactVersion(DefaultArtifactCoordinate artifactCoordinate) {
        String version = this.project.getDependencyManagement().getDependencies().stream().filter(dependency -> dependency.getGroupId().equals(artifactCoordinate.getGroupId()) && dependency.getArtifactId().equals(artifactCoordinate.getArtifactId())).findFirst().map(Dependency::getVersion).orElseThrow(() -> new NoSuchElementException(String.format("Missing declaration of dependency: %s", artifactCoordinate)));
        artifactCoordinate.setVersion(version);
        return artifactCoordinate;
    }

    private void copyArtifact(ArtifactCoordinate artifactCoordinate) throws MojoFailureException {
        File artifact = this.resolveArtifact(artifactCoordinate);
        try {
            log.info("Copying page artifact '{}' into {}", (Object)artifact.getName(), (Object)this.outputFolder);
            Files.copy(artifact.toPath(), this.outputFolder.toPath().resolve(artifact.getName()), new CopyOption[0]);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Failed to copy artifact: %s", artifactCoordinate), (Throwable)e);
        }
    }

    private File resolveArtifact(ArtifactCoordinate artifactCoordinate) throws MojoFailureException {
        try {
            return this.artifactResolver.resolveArtifact(this.session.getProjectBuildingRequest(), artifactCoordinate).getArtifact().getFile();
        }
        catch (ArtifactResolverException e) {
            throw new MojoFailureException(String.format("Failed to resolve artifact: %s", artifactCoordinate), (Throwable)e);
        }
    }

    private static DefaultArtifactCoordinate buildPageArtifactCoordinate(String artifactId) {
        DefaultArtifactCoordinate artifact = new DefaultArtifactCoordinate();
        artifact.setGroupId(PAGE_GROUP_ID);
        artifact.setArtifactId(artifactId);
        artifact.setExtension(PAGE_EXTENSION);
        return artifact;
    }
}

