/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.handler;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.bonitasoft.plugin.analyze.ConnectorResolver;
import org.bonitasoft.plugin.analyze.handler.AbstractArtifactAnalyzerHandler;
import org.bonitasoft.plugin.analyze.report.model.ActorFilterImplementation;
import org.bonitasoft.plugin.analyze.report.model.ConnectorImplementation;
import org.bonitasoft.plugin.analyze.report.model.Definition;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.bonitasoft.plugin.analyze.report.model.Implementation;
import org.bonitasoft.plugin.analyze.report.model.Issue;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConnectorAnalyzer
extends AbstractArtifactAnalyzerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorAnalyzer.class);
    private ConnectorResolver connectorResolver;

    ConnectorAnalyzer(LocalRepositoryManager localRepositoryManager, ConnectorResolver connectorResolver) {
        super(localRepositoryManager);
        this.connectorResolver = connectorResolver;
    }

    @Override
    public boolean appliesTo(Artifact artifact) {
        File file = artifact.getFile();
        String fileName = file.getName();
        try {
            return file.isFile() && fileName.endsWith(".jar") && this.hasConnectorDescriptor(file);
        }
        catch (IOException e) {
            LOGGER.warn("An error occured while reading {}", (Object)file, (Object)e);
            return false;
        }
    }

    @Override
    public DependencyReport analyze(Artifact artifact, DependencyReport report) throws IOException {
        Issue.Collector issueCollector = Issue.collector();
        List<Implementation> allImplementations = this.connectorResolver.findAllImplementations(artifact, issueCollector);
        List<Definition> allDefinitions = this.connectorResolver.findAllDefinitions(artifact, issueCollector);
        List<ConnectorImplementation> connectorImplementations = allImplementations.stream().filter(ConnectorImplementation.class::isInstance).map(ConnectorImplementation.class::cast).collect(Collectors.toList());
        List<ActorFilterImplementation> filterImplementations = allImplementations.stream().filter(ActorFilterImplementation.class::isInstance).map(ActorFilterImplementation.class::cast).collect(Collectors.toList());
        allDefinitions.stream().filter(def -> this.hasMatchingImplementation((Definition)def, (List<? extends Implementation>)connectorImplementations)).forEach(arg_0 -> ((DependencyReport)report).addConnectorDefinition(arg_0));
        allDefinitions.stream().filter(def -> this.hasMatchingImplementation((Definition)def, (List<? extends Implementation>)filterImplementations)).forEach(arg_0 -> ((DependencyReport)report).addFilterDefinition(arg_0));
        allDefinitions.stream().filter(def -> !this.hasMatchingImplementation((Definition)def, Stream.of(connectorImplementations, filterImplementations).flatMap(Collection::stream).collect(Collectors.toList()))).map(def -> Issue.create((Issue.Type)Issue.Type.UNKNOWN_DEFINITION_TYPE, (String)String.format("%s declares a definition '%s (%s)' but no matching implementation has been found. This definition will be ignored.", def.getJarEntry(), def.getDefinitionId(), def.getDefinitionVersion()), (Issue.Severity)Issue.Severity.WARNING, (String[])new String[]{artifact.getId()})).forEach(arg_0 -> ((DependencyReport)report).addIssue(arg_0));
        connectorImplementations.forEach(arg_0 -> ((DependencyReport)report).addConnectorImplementation(arg_0));
        filterImplementations.forEach(arg_0 -> ((DependencyReport)report).addFilterImplementation(arg_0));
        issueCollector.getIssues().forEach(arg_0 -> ((DependencyReport)report).addIssue(arg_0));
        return report;
    }

    boolean hasMatchingImplementation(Definition def, List<? extends Implementation> connectorImplementations) {
        return connectorImplementations.stream().anyMatch(implementation -> Objects.equals(def.getDefinitionId(), implementation.getDefinitionId()) && Objects.equals(def.getDefinitionVersion(), implementation.getDefinitionVersion()));
    }

    private Optional<JarEntry> findJarEntry(File file, Predicate<? super JarEntry> entryPredicate) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Optional<JarEntry> optional = jarFile.stream().filter(entryPredicate).findFirst();
            return optional;
        }
    }

    boolean hasConnectorDescriptor(File artifactFile) throws IOException {
        return this.findJarEntry(artifactFile, entry -> entry.getName().endsWith(".impl")).isPresent();
    }
}

