/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.build.page;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.bonitasoft.plugin.AbstractBuildMojo;
import org.bonitasoft.plugin.build.page.BuildPageException;
import org.bonitasoft.plugin.build.page.UidArtifactBuilder;
import org.bonitasoft.plugin.build.page.UidArtifactBuilderFactory;

@Mojo(name="uid-page", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresProject=false)
public class BuildUidPageMojo
extends AbstractBuildMojo {
    private static final String[] DEFAULT_EXCLUDES = new String[]{".metadata"};
    private static final String[] DEFAULT_INCLUDES = new String[]{"*"};
    @Parameter(property="page.includes")
    private String[] includes;
    @Parameter(property="page.excludes")
    private String[] excludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path pagesOutputDirectory = this.outputDirectory.toPath().resolve("pages");
        pagesOutputDirectory.toFile().mkdirs();
        UidArtifactBuilder artifactBuilder = UidArtifactBuilderFactory.create(this.uidWorkspaceProperties(this.outputDirectory.toPath()));
        Map<String, String> uidWorkspace = this.uidWorkspace();
        Path pagesFolder = Paths.get(uidWorkspace.get("workspacePath"), new String[0]).resolve(uidWorkspace.get("pagesFolderName"));
        try {
            artifactBuilder.buildPages(pagesFolder, this.selectPages(pagesFolder), pagesOutputDirectory);
        }
        catch (BuildPageException e) {
            throw new MojoExecutionException((Throwable)e);
        }
    }

    private String[] selectPages(Path pagesFolder) {
        FileSetManager fileSetManager = new FileSetManager();
        FileSet pageFileSet = new FileSet();
        pageFileSet.setDirectory(pagesFolder.toFile().getAbsolutePath());
        pageFileSet.setIncludes(Arrays.asList(this.getIncludes()));
        pageFileSet.setExcludes(Arrays.asList(this.getExcludes()));
        return fileSetManager.getIncludedDirectories(pageFileSet);
    }

    private String[] getIncludes() {
        if (this.includes != null && this.includes.length > 0) {
            return this.includes;
        }
        return DEFAULT_INCLUDES;
    }

    private String[] getExcludes() {
        if (this.excludes != null && this.excludes.length > 0) {
            return this.excludes;
        }
        return DEFAULT_EXCLUDES;
    }
}

