/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.extension.impl;

import java.io.IOException;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelReader;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.project.MavenProject;
import org.bonitasoft.plugin.module.AbstractModuleGenerator;
import org.bonitasoft.plugin.module.ModuleGenerationException;

@Named
public class ExtensionsModuleGeneratorImpl
extends AbstractModuleGenerator {
    static final String MODULE_SUFFIX = "-extensions";
    static final String EXTENSIONS_PARENT_MODULE = "extensions";
    static final String POM_FILE_NAME = "pom.xml";
    static final String BDM_MODEL_ARTIFACT_ID_PLACEHOLDER = "_BDM_MODEL_ARTIFACT_ID_PLACEHOLDER_";

    @Inject
    public ExtensionsModuleGeneratorImpl(ModelReader modelReader, ModelWriter modelWriter) {
        super(modelReader, modelWriter);
    }

    @Override
    public Path create(String projectId, MavenProject parentProject) throws ModuleGenerationException {
        Path modulePath = this.createModule(projectId, parentProject.getModel(), parentProject.getBasedir().toPath().resolve(EXTENSIONS_PARENT_MODULE), "/extensions.parent.module.xml", MODULE_SUFFIX);
        try {
            Model parentProjectModel = this.modelReader.read(parentProject.getFile(), null);
            if (parentProjectModel.getModules().stream().noneMatch(EXTENSIONS_PARENT_MODULE::equals)) {
                parentProjectModel.getModules().add(EXTENSIONS_PARENT_MODULE);
            }
            this.modelWriter.write(parentProject.getFile(), null, parentProjectModel);
        }
        catch (IOException e) {
            throw new ModuleGenerationException("Failed to add extensions module to parent pom.", e);
        }
        return modulePath;
    }
}

