/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze;

import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.bonitasoft.plugin.analyze.ArtifactAnalyzer;
import org.bonitasoft.plugin.analyze.handler.ArtifactAnalyzerHandler;
import org.bonitasoft.plugin.analyze.report.AnalysisResultReportException;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;

class DefaultArtifactAnalyzer
implements ArtifactAnalyzer {
    private final List<ArtifactAnalyzerHandler> handlers;

    public DefaultArtifactAnalyzer(List<ArtifactAnalyzerHandler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public DependencyReport analyze(List<Artifact> artifacts) {
        DependencyReport dependencyReport = new DependencyReport();
        artifacts.forEach(artifact -> {
            try {
                this.analyze((Artifact)artifact, dependencyReport, this.handlers);
            }
            catch (IOException e) {
                throw new AnalysisResultReportException("Failed to analyze artifacts: " + artifact.getId(), e);
            }
        });
        return dependencyReport;
    }

    private DependencyReport analyze(Artifact artifact, DependencyReport result, List<ArtifactAnalyzerHandler> handlers) throws IOException {
        for (ArtifactAnalyzerHandler handler : handlers) {
            if (!handler.appliesTo(artifact)) continue;
            handler.analyze(artifact, result);
        }
        return result;
    }
}

