/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.bind.JAXBException;
import org.bonitasoft.engine.business.application.exporter.ApplicationNodeContainerConverter;
import org.bonitasoft.engine.business.application.xml.ApplicationNode;
import org.bonitasoft.engine.business.application.xml.ApplicationNodeContainer;
import org.bonitasoft.plugin.analyze.handler.AbstractArtifactAnalyzerHandler;
import org.bonitasoft.plugin.analyze.report.model.ApplicationDescriptor;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

class ApplicationDescriptorAnalyzer
extends AbstractArtifactAnalyzerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDescriptorAnalyzer.class);
    private static final String APPLICATION_CLASSIFIER = "application";
    private ApplicationNodeContainerConverter converter = new ApplicationNodeContainerConverter();

    ApplicationDescriptorAnalyzer(LocalRepositoryManager localRepositoryManager) {
        super(localRepositoryManager);
    }

    @Override
    public boolean appliesTo(org.apache.maven.artifact.Artifact artifact) {
        File file = artifact.getFile();
        String fileName = file.getName();
        try {
            return file.isFile() && fileName.endsWith(".zip") && Objects.equals(artifact.getClassifier(), APPLICATION_CLASSIFIER) && this.hasApplicationDescriptor(file);
        }
        catch (IOException e) {
            LOGGER.warn("An error occured while reading {}", (Object)file, (Object)e);
            return false;
        }
    }

    @Override
    public DependencyReport analyze(org.apache.maven.artifact.Artifact artifact, DependencyReport report) throws IOException {
        Optional<ApplicationNode> descriptor = this.readApplicationDescriptorInArchive(artifact.getFile());
        descriptor.ifPresent(app -> report.addApplicationDescriptor(ApplicationDescriptor.create((String)app.getDisplayName(), (String)app.getVersion(), (String)app.getDescription(), (String)app.getProfile(), (String)app.getToken(), (Artifact)this.create(artifact))));
        return report;
    }

    Optional<ApplicationNode> readApplicationDescriptorInArchive(File artifactFile) throws IOException {
        return this.findZipEntry(artifactFile, entry -> entry.getName().matches("applications/(.*).xml")).map(entry -> {
            try (ZipFile zipFile = new ZipFile(artifactFile);){
                Optional optional;
                block13: {
                    InputStream is = zipFile.getInputStream((ZipEntry)entry);
                    try {
                        ApplicationNodeContainer container = this.converter.unmarshallFromXML(is.readAllBytes());
                        optional = container.getApplications().stream().findFirst();
                        if (is == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return optional;
            }
            catch (IOException | JAXBException | SAXException e) {
                LOGGER.warn("Failed to parse {} for application descriptor", (Object)artifactFile, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).orElseThrow(() -> new IllegalArgumentException(String.format("No application descriptor found in %s", artifactFile)));
    }

    boolean hasApplicationDescriptor(File artifactFile) throws IOException {
        return this.findZipEntry(artifactFile, entry -> entry.getName().matches("applications/(.*).xml")).isPresent();
    }
}

