/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.analyze.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bonitasoft.plugin.analyze.handler.AbstractArtifactAnalyzerHandler;
import org.bonitasoft.plugin.analyze.report.AnalysisResultReportException;
import org.bonitasoft.plugin.analyze.report.model.Artifact;
import org.bonitasoft.plugin.analyze.report.model.CustomPage;
import org.bonitasoft.plugin.analyze.report.model.DependencyReport;
import org.bonitasoft.plugin.analyze.report.model.Form;
import org.bonitasoft.plugin.analyze.report.model.Page;
import org.bonitasoft.plugin.analyze.report.model.RestAPIExtension;
import org.bonitasoft.plugin.analyze.report.model.Theme;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CustomPageAnalyzer
extends AbstractArtifactAnalyzerHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPageAnalyzer.class);
    private static final String CUSTOMPAGE_DESCRIPTOR_PROPERTIES = "page.properties";

    CustomPageAnalyzer(LocalRepositoryManager localRepositoryManager) {
        super(localRepositoryManager);
    }

    @Override
    public boolean appliesTo(org.apache.maven.artifact.Artifact artifact) {
        File file = artifact.getFile();
        String fileName = file.getName();
        try {
            return file.isFile() && fileName.endsWith(".zip") && this.hasCustomPageDescriptor(file);
        }
        catch (IOException e) {
            LOGGER.warn("An error occured while reading {}", (Object)file, (Object)e);
            return false;
        }
    }

    @Override
    public DependencyReport analyze(org.apache.maven.artifact.Artifact artifact, DependencyReport report) throws IOException {
        Properties properties = this.readPagePropertiesInArchive(artifact.getFile());
        this.analyzeCustomPageArtifact(artifact, properties, report);
        return report;
    }

    Properties readPagePropertiesInArchive(File artifactFile) throws IOException {
        return this.findZipEntry(artifactFile, entry -> entry.getName().equals(CUSTOMPAGE_DESCRIPTOR_PROPERTIES)).map(entry -> {
            try (ZipFile zipFile = new ZipFile(artifactFile);){
                Properties properties;
                try (InputStreamReader reader = new InputStreamReader(zipFile.getInputStream((ZipEntry)entry), StandardCharsets.UTF_8);){
                    Properties prop = new Properties();
                    prop.load(reader);
                    properties = prop;
                }
                return properties;
            }
            catch (IOException e) {
                return null;
            }
        }).filter(Objects::nonNull).orElseThrow(() -> new IllegalArgumentException(String.format("No page.properties found in %s", artifactFile)));
    }

    void analyzeCustomPageArtifact(org.apache.maven.artifact.Artifact artifact, Properties pageDescriptor, DependencyReport result) {
        String contentType = pageDescriptor.getProperty("contentType");
        CustomPage.CustomPageType customPageType = CustomPage.CustomPageType.valueOf((String)contentType.toUpperCase());
        String name = pageDescriptor.getProperty("name");
        String displayName = pageDescriptor.getProperty("displayName");
        String description = pageDescriptor.getProperty("description");
        switch (customPageType) {
            case FORM: {
                result.addForm(Form.create((String)name, (String)displayName, (String)description, (Artifact)this.create(artifact)));
                break;
            }
            case PAGE: {
                result.addPage(Page.create((String)name, (String)displayName, (String)description, (Artifact)this.create(artifact)));
                break;
            }
            case THEME: {
                result.addTheme(Theme.create((String)name, (String)displayName, (String)description, (Artifact)this.create(artifact)));
                break;
            }
            case APIEXTENSION: {
                result.addRestAPIExtension(RestAPIExtension.create((String)name, (String)displayName, (String)description, (Artifact)this.create(artifact)));
                break;
            }
            default: {
                throw new AnalysisResultReportException("Unsupported Custom Page type: " + contentType);
            }
        }
    }

    boolean hasCustomPageDescriptor(File artifactFile) throws IOException {
        return this.findZipEntry(artifactFile, entry -> entry.getName().equals(CUSTOMPAGE_DESCRIPTOR_PROPERTIES)).isPresent();
    }
}

