/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.plugin.build;

import java.io.File;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractConfigurationArchiveMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", required=true, readonly=true)
    protected List<MavenProject> reactorProjects;
    @Parameter(property="bonita.environment")
    protected String environment;
    @Parameter(property="bonita.parametersFile", defaultValue="${maven.multiModuleProjectDirectory}/.bcd_configurations/parameters-${bonita.environment}.yml")
    protected String parametersFile;

    protected MavenProject findAppModuleProject() throws MojoExecutionException {
        return this.reactorProjects.size() == 1 ? this.project : this.reactorProjects.stream().filter(p -> p.getBasedir().getName().equals("app")).findFirst().orElseThrow(() -> new MojoExecutionException(String.format("Application module not found in %s", this.project.getBasedir().toPath().resolve("app"))));
    }

    protected File defaultConfigurationFile() throws MojoExecutionException {
        MavenProject appModule = this.findAppModuleProject();
        return appModule.getAttachedArtifacts().stream().filter(artifact -> "bconf".equals(artifact.getType())).map(Artifact::getFile).findFirst().orElse(null);
    }

    protected String getEnvironment() throws MojoExecutionException {
        if (this.environment == null) {
            MavenProject appModule = this.findAppModuleProject();
            this.environment = appModule.getProperties().getProperty("bonita.environment");
            if (this.environment == null) {
                throw new MojoExecutionException("Required bonita.environment properties is not set.");
            }
        }
        return this.environment.toLowerCase();
    }

    protected File getAppModuleBuildDir() throws MojoExecutionException {
        MavenProject appModule = this.findAppModuleProject();
        return new File(appModule.getBuild().getDirectory());
    }

    protected File getAppModuleBaseDir() throws MojoExecutionException {
        MavenProject appModule = this.findAppModuleProject();
        return appModule.getBasedir();
    }
}

